/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.ConditionBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ViewReportConditionBean;
import com.xdja.pams.rptms.entity.Condition;
import com.xdja.pams.rptms.entity.ReportCondition;
import com.xdja.pams.rptms.service.BReportService;
import com.xdja.pams.rptms.service.ConditionManagerService;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.ViewReportService;
import com.xdja.pams.rptms.service.ViewReportUtils;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class ViewReportServiceImpl
implements ViewReportService {
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private ConditionManagerService conditionManagerService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommonCodePbService commonCodePbService;
    private static final Logger log = LoggerFactory.getLogger(ViewReportServiceImpl.class);
    @Autowired
    private ViewReportUtils viewReportUtils;
    private static final String COLON = "\uff1a";

    @Override
    public List<ViewReportConditionBean> getReportConditionList(String reportId) {
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u4fe1\u606f<\u5f00\u59cb>$$$$$$$$$$");
        log.debug("#>reportId:" + reportId);
        ReportBean report = this.reportManagerService.getReportById(reportId);
        List<ReportCondition> reportCondtitionList = report.getConditionList();
        ArrayList<ViewReportConditionBean> ViewReportConditionBeanList = new ArrayList<ViewReportConditionBean>();
        if (reportCondtitionList == null || reportCondtitionList.size() == 0) {
            log.debug("$\u65e0\u53c2\u6570");
            return ViewReportConditionBeanList;
        }
        for (ReportCondition reportCondtion : reportCondtitionList) {
            ViewReportConditionBean viewReportConditionBean = new ViewReportConditionBean();
            ConditionBean condition = this.conditionManagerService.getConditionById(reportCondtion.getConditionId());
            viewReportConditionBean.setType(condition.getConditionType());
            viewReportConditionBean.setName(condition.getConditionName() + COLON);
            viewReportConditionBean.setIsShowName(reportCondtion.getFlagConditionName());
            if ("0".equals(viewReportConditionBean.getIsShowName())) {
                log.debug("$\u53c2\u6570\u540d\u79f0\u4e0d\u663e\u793a");
                viewReportConditionBean.setName("");
            }
            viewReportConditionBean.setIsShow(reportCondtion.getFlagCondition());
            viewReportConditionBean.setIsRequired("1".equals(reportCondtion.getFlagRequired()) ? "true" : "false");
            viewReportConditionBean.setIdAndNameAttributeValue(condition.getConditionShowId());
            viewReportConditionBean.setDefaultValue(this.getDefaultValue(condition));
            viewReportConditionBean.setConditionJsonData(this.getConditionJsonData(condition));
            log.debug("$<\u53c2\u6570\u4fe1\u606f:" + Util.toJsonStr(viewReportConditionBean));
            ViewReportConditionBeanList.add(viewReportConditionBean);
        }
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u53c2\u6570<\u7ed3\u675f>$$$$$$$$$$");
        return ViewReportConditionBeanList;
    }

    private String getConditionJsonData(Condition condition) {
        String type = condition.getConditionType();
        String conditiondata = condition.getConditionData();
        String dataOriginCode = condition.getDataOriginCode();
        String dataSourceId = condition.getDatasourceId();
        if ("2".equals(type) || "3".equals(type)) {
            if ("1".equals(dataOriginCode)) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode node = objectMapper.readTree(conditiondata);
                    node.get(0);
                }
                catch (Exception e2) {
                    log.error("$Json\u6570\u636e\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e2);
                    conditiondata = "";
                }
                return conditiondata;
            }
            List<Object> mapList = new ArrayList();
            try {
                mapList = this.viewReportUtils.excuteSql(dataSourceId, conditiondata);
            }
            catch (Exception e3) {
                log.error("#\u4e0b\u62c9\u6846\u6570\u636e\u5c01\u88c5\u5f02\u5e38", (Throwable)e3);
                mapList = new ArrayList();
            }
            HashMap<String, String> map0 = new HashMap<String, String>();
            map0.put("NAME", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
            map0.put("CODE", "");
            mapList.add(0, map0);
            return Util.toJsonStr(mapList);
        }
        if ("8".equals(type)) {
            String jsonList = this.commonCodePbService.queryJsonByType(conditiondata);
            return jsonList;
        }
        return "";
    }

    private String getDefaultValue(Condition condition) {
        String defaultValue = "";
        try {
            defaultValue = condition.getDefaultValue();
            String type = condition.getConditionType();
            String dataSourceId = condition.getDatasourceId();
            if ("4".equals(type) && "2".equals(condition.getDataOriginCode())) {
                log.info("#\u65e5\u671f\u7c7b\u578b-Sql\u53d6\u503c\uff1a" + condition.getDataOriginCode());
                defaultValue = this.viewReportUtils.queryForObject(dataSourceId, defaultValue, String.class, new Object[0]);
            }
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u9ed8\u8ba4\u503c\u5f02\u5e38", (Throwable)e2);
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    public List<Map<String, Object>> getReportData(ReportBean reportBean, Map<String, Object> allParams, Page page) {
        String sqlStr = reportBean.getReportSql();
        if (sqlStr.startsWith("com.xdja")) {
            try {
                Class<?> clz = Class.forName(sqlStr);
                BReportService breportService = (BReportService)BeanUtils.getBean(clz);
                return breportService.getReportData(reportBean, allParams, page);
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                return new ArrayList<Map<String, Object>>();
            }
        }
        sqlStr = this.viewReportUtils.fileParams(sqlStr, allParams);
        List<Map<String, Object>> list = null;
        StringBuffer sCount = new StringBuffer();
        if (page != null) {
            if (sqlStr.indexOf("?") > 0) {
                sCount.append("{ call ").append(sqlStr).append("}");
                list = this.viewReportUtils.excuteProcedure(reportBean.getDatasourceId(), sCount.toString());
            } else {
                sCount.append("select * from ( select reportdata.*,rownum reportrownum from ( ").append(sqlStr).append(" ) reportdata ) where reportrownum >").append(page.getRp() * (page.getPage() - 1)).append(" and reportrownum<= ").append(page.getRp() * page.getPage());
                list = this.viewReportUtils.excuteSql(reportBean.getDatasourceId(), sCount.toString());
            }
        } else if (sqlStr.indexOf("?") > 0) {
            sCount.append("{ call ").append(sqlStr).append("}");
            list = this.viewReportUtils.excuteProcedure(reportBean.getDatasourceId(), sCount.toString());
        } else {
            list = this.viewReportUtils.excuteSql(reportBean.getDatasourceId(), sqlStr);
        }
        if (list == null) {
            list = new ArrayList<Map<String, Object>>();
        }
        return list;
    }

    @Override
    public Page getReportDataPagination(ReportBean reportBean, Map<String, Object> allParams, Page page) {
        String sqlStr = reportBean.getReportSql();
        if (sqlStr.startsWith("com.xdja")) {
            try {
                Class<?> clz = Class.forName(sqlStr);
                BReportService breportService = (BReportService)BeanUtils.getBean(clz);
                return breportService.getReportDataPagination(reportBean, allParams, page);
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                return new Page();
            }
        }
        if ((sqlStr = this.viewReportUtils.fileParams(sqlStr, allParams)).indexOf("?") < 0) {
            StringBuffer sCount = new StringBuffer("select count(*) CNT from (");
            sCount.append(sqlStr).append(" )");
            if (page != null) {
                List<Map<String, Object>> list = this.viewReportUtils.excuteSql(reportBean.getDatasourceId(), sCount.toString());
                if (list == null || list.isEmpty()) {
                    page.setTotal(0);
                } else {
                    Map<String, Object> data = list.get(0);
                    BigDecimal count = (BigDecimal)data.get("CNT");
                    page.setTotal(Integer.parseInt(String.valueOf(count)));
                }
            } else {
                page = new Page();
                page.setTotal(0);
            }
        } else {
            page.setTotal(0);
        }
        return page;
    }
}

