/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.ApplyForm;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.ApplyTerminalService;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.IdentityService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class ApplyTerminalController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(ApplyTerminalController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private DeviceService devieService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private CommonCodePbService commonCodeService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    ApplyTerminalService ats;
    @Autowired
    WorkflowUtilService wus;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private DevicePbService dps;

    @RequestMapping(value={"scms/applyterminalcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnListForStart("safeCard");
            if (wfbList == null || wfbList.size() != 1) {
                map.put((Object)"workflowFlowBean", null);
            } else {
                map.put((Object)"workflowFlowBean", (Object)Util.toJsonStr(wfbList.get(0)));
            }
            map.put((Object)"powerId", (Object)"SCMS02");
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/applyterminalcontroller/queryByCodeOrName.do"})
    public void queryByCodeOrName(String q, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (StringUtils.isBlank((CharSequence)q)) {
                map.put("total", "0");
                map.put("rows", new ArrayList());
            } else {
                String controlDepIds = this.getControlDeps(request);
                String controlPolice = this.getControlPolices(request);
                Page page = new Page();
                page.setPage(1);
                page.setRp(20);
                List<Person> list = this.userManagerService.queryPersonListByNameOrCode(q.trim(), controlDepIds, controlPolice, page);
                ArrayList listmap = new ArrayList();
                for (Person person : list) {
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("id", person.getId());
                    map1.put("code", person.getCode());
                    map1.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
                    map1.put("depname", person.getDepartment().getName());
                    CommonCode code = this.commonCodeService.getByCode(person.getPosition(), "2011");
                    map1.put("position", code != null ? code.getName() : "");
                    map1.put("identifier", person.getIdentifier());
                    code = this.commonCodeService.getByCode(person.getPolice(), "2012");
                    map1.put("personTypeName", this.commonCodeService.getCodeNameByCode(person.getPersonType(), "PERSON_TYPE"));
                    map1.put("police", code != null ? code.getName() : "");
                    ArrayList tmpList = new ArrayList();
                    for (Mobile m : person.getMobiledList()) {
                        HashMap<String, String> map2 = new HashMap<String, String>();
                        map2.put("id", m.getId());
                        map2.put("mobile", m.getMobile());
                        tmpList.add(map2);
                    }
                    map1.put("mobile", Util.toJsonStr(tmpList));
                    listmap.add(map1);
                }
                map.put("total", listmap.size());
                map.put("rows", listmap);
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u7533\u8bf7\u4eba\u59d3\u540d\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/applyterminalcontroller/save.do"})
    public void save(ApplyForm deviceList, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 1;
        try {
            if (deviceList == null || deviceList.getDeviceList() == null || deviceList.getDeviceList().isEmpty()) {
                operateResult = 0;
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.reqParameterError"));
            } else {
                List<Person> depPersons = null;
                depPersons = "1".equals(deviceList.getApplyType()) ? this.userManagerService.getWorkFlowUserListByDepAndDepApply(deviceList.getGroupId(), deviceList.getApplyDepId(), deviceList.getPowerId(), deviceList.getFlowDep()) : this.userManagerService.getWorkFlowUserListByDep(deviceList.getGroupId(), deviceList.getPersonId(), deviceList.getPowerId(), deviceList.getFlowDep());
                StringBuffer depPersonIds = new StringBuffer();
                if (depPersons != null) {
                    for (Person p : depPersons) {
                        depPersonIds.append(p.getId()).append(",");
                    }
                    if (deviceList.getFlowUser() != null) {
                        deviceList.setFlowUser(depPersonIds.toString() + deviceList.getFlowUser());
                    } else {
                        deviceList.setFlowUser(depPersonIds.toString());
                    }
                }
                boolean cardFlag = false;
                if (!Util.varCheckEmp(deviceList.getFlowDep()) && Util.varCheckEmp(deviceList.getFlowUser())) {
                    operateResult = 0;
                    rr.setRtnCode("1");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.nofindflowuserError"));
                    cardFlag = true;
                }
                if ("one".equals(this.scps.getValueByCode("cardcount"))) {
                    List<Device> dList;
                    if (deviceList.getDeviceList().size() > 1) {
                        operateResult = 0;
                        rr.setRtnCode("1");
                        rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.oneCardError2"));
                        cardFlag = true;
                    }
                    if (!"1".equals(deviceList.getApplyType()) && (dList = this.dps.getByPersonId(deviceList.getPersonId())) != null && !dList.isEmpty()) {
                        operateResult = 0;
                        rr.setRtnCode("1");
                        rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.oneCardError"));
                        cardFlag = true;
                    }
                }
                boolean flag = false;
                if (!cardFlag) {
                    if (Util.varCheckEmp(deviceList.getFlowUser()) && Util.varCheckEmp(deviceList.getFlowDep())) {
                        String tmp = "";
                        ArrayList<Person> personList = new ArrayList<Person>();
                        List<Person> persons = this.userManagerService.getWorkFlowUserList(deviceList.getGroupId(), deviceList.getPersonId(), deviceList.getPowerId());
                        List<Person> depPersonAll = this.userManagerService.getWorkFlowUserListByGroupDep(deviceList.getGroupId(), deviceList.getPersonId(), deviceList.getPowerId());
                        personList.addAll(persons);
                        if (depPersonAll != null) {
                            personList.addAll(depPersonAll);
                        }
                        if (personList == null || personList.isEmpty()) {
                            operateResult = 0;
                            rr.setRtnCode("1");
                            rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflowUser"));
                            flag = true;
                            log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflowUser"));
                        } else {
                            for (Person p : personList) {
                                tmp = tmp + p.getId() + ",";
                            }
                            deviceList.setFlowUser(tmp);
                        }
                    }
                    if (!flag) {
                        deviceList.setUserId(this.person.getId());
                        deviceList.setUserName(this.person.getName());
                        if ("1".equals(deviceList.getApplyType())) {
                            this.ats.ApplyTerminalByDep(deviceList);
                        } else {
                            this.ats.ApplyTerminal(deviceList);
                        }
                        rr.setRtnCode("0");
                        rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                    }
                }
            }
        }
        catch (ActivitiException e2) {
            if (e2.getMessage().indexOf("no processes deployed with key") != -1) {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"), (Throwable)e2);
                operateResult = 0;
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.notWorkflow"));
            } else {
                log.error(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"), (Throwable)e2);
                operateResult = 0;
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.apply.error.startWorkflowError"));
            }
        }
        catch (Exception e3) {
            log.error("\u5b89\u5168\u5361\u7533\u8bf7\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e3);
            operateResult = 0;
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e3.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    public DeviceService getDevieService() {
        return this.devieService;
    }

    public void setDevieService(DeviceService devieService) {
        this.devieService = devieService;
    }

    public UserManageService getUserManagerService() {
        return this.userManagerService;
    }

    public void setUserManagerService(UserManageService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

