/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.entity.DeviceHistory;
import com.xdja.pams.scms.service.DeviceHistoryService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class DeviceHistoryController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DeviceHistoryController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private DeviceHistoryService deviceHistoryService;
    @Autowired
    private CommonCodePbService commonCodeService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManagerService;

    @RequestMapping(value={"scms/devicehistorycontroller/index"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/devicehistorycontroller/query"})
    public void query(QueryForm form, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        int operateResult = 0;
        String controlDeps = this.getControlDeps(request);
        form.setControlDeps(controlDeps);
        try {
            List<DeviceHistory> list = this.deviceHistoryService.query(form, page);
            for (DeviceHistory dh : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                Person personb = this.userManagerService.queryPersonById(dh.getPersonId());
                map.put("id", dh.getId());
                map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
                map.put("code", personb.getCode());
                map.put("depname", personb.getDepartment().getName());
                map.put("identifier", personb.getIdentifier());
                map.put("mobile", dh.getMobile());
                map.put("patchDate", Util.getDate("yyyy-MM-dd", dh.getPatchDate()));
                CommonCode code = this.commonCodeService.getByCode(dh.getType(), "2000");
                map.put("cardType", code != null ? code.getName() : "");
                map.put("operator", dh.getOperator());
                map.put("personTypeName", this.commonCodeService.getCodeNameByCode(personb.getPersonType(), "PERSON_TYPE"));
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    public DeviceHistoryService getDeviceHistoryService() {
        return this.deviceHistoryService;
    }

    public void setDeviceHistoryService(DeviceHistoryService deviceHistoryService) {
        this.deviceHistoryService = deviceHistoryService;
    }

    public CommonCodePbService getCommonCodeService() {
        return this.commonCodeService;
    }

    public void setCommonCodeService(CommonCodePbService commonCodeService) {
        this.commonCodeService = commonCodeService;
    }
}

