/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.util.Strings;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IssuingDoubleCertInAirApiControl {
    private static final Logger log = LoggerFactory.getLogger(IssuingDoubleCertInAirApiControl.class);
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/apply.do"})
    public void apply(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u5b9e\u4f53\u8ba4\u8bc1\u8bf7\u6c42\u53c2\u6570: {}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String type = jsonObject.getString("type");
            String hardNo = jsonObject.getString("hardNo");
            String identity = jsonObject.getString("identifyNo");
            String phone = jsonObject.getString("phone");
            if (Strings.isEmpty(type) || Strings.isEmpty(hardNo) || Strings.isEmpty(identity) || Strings.isEmpty(phone)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.apply2(type, hardNo, identity, phone);
            log.debug("\u5b9e\u4f53\u8ba4\u8bc1\u8fd4\u56de\u6570\u636e: {}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/certDownload.do"})
    public void certDownload(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u7b7e\u53d1\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String type = jsonObject.getString("type");
            String p10 = jsonObject.getString("p10");
            String pubKey = jsonObject.getString("pubkey");
            String identity = jsonObject.getString("identifyNo");
            String imsi = jsonObject.getString("imsi");
            String imei = jsonObject.getString("imei");
            String phone = jsonObject.getString("phone");
            String commType = jsonObject.getString("commType");
            String osType = jsonObject.getString("osType");
            String terminalBand = jsonObject.getString("terminalBand");
            String terminalType = jsonObject.getString("terminalType");
            if (Strings.isEmpty(hardNo) || Strings.isEmpty(type) || Strings.isEmpty(p10) || Strings.isEmpty(identity) || Strings.isEmpty(imsi) || Strings.isEmpty(imei)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.certDownload2(type, null, hardNo, p10, pubKey, identity, imsi, imei, phone, commType, osType, terminalBand, terminalType, "inair");
            log.debug("\u7b7e\u53d1\u8bc1\u4e66\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/revoke.do"})
    public void revoke(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u64a4\u9500\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String sn = jsonObject.getString("sn");
            String reason = jsonObject.getString("reason");
            if (Strings.isEmpty(hardNo) || Strings.isEmpty(sn)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            if (reason != null && reason.length() > 50) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.revokeApply(hardNo, sn, reason);
            log.debug("\u64a4\u9500\u8bc1\u4e66\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/queryState.do"})
    public void queryState(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u67e5\u8be2\u8bc1\u4e66\u72b6\u6001\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String sn = jsonObject.getString("sn");
            if (Strings.isEmpty(hardNo)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.queryState(hardNo, sn);
            log.debug("\u67e5\u8be2\u8bc1\u4e66\u72b6\u6001\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    public void review(@RequestBody String param, HttpServletResponse response) {
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/applyDelayRenew.do"})
    public void applyDelayOrRenew(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u5ef6\u671f\u6216\u66f4\u65b0\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String pubKey = jsonObject.getString("pubKey");
            String type = jsonObject.getString("type");
            String sn = jsonObject.getString("sn");
            String reason = jsonObject.getString("reason");
            if (Strings.isEmpty(hardNo) || Strings.isEmpty(pubKey) || Strings.isEmpty(sn) || Strings.isEmpty(type) || type.length() != 1 || !"12".contains(type)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.delayOrRenew(hardNo, sn, pubKey, type, reason, "inair");
            log.debug("\u5ef6\u671f\u6216\u66f4\u65b0\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/renew.do"})
    public void renew(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u66f4\u65b0\u8bc1\u4e66\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String pubKey = jsonObject.getString("pubKey");
            String p10 = jsonObject.getString("p10");
            String isUpDateKey = jsonObject.getString("isUpDateKey");
            if (Strings.isEmpty(hardNo)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.renew(hardNo, pubKey, p10, isUpDateKey, true, "inair");
            log.debug("\u5ef6\u671f\u6216\u66f4\u65b0\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    public void unFreezeApply(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u7533\u8bf7\u89e3\u51bb\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String reason = jsonObject.getString("reason");
            String sn = jsonObject.getString("sn");
            if (Strings.isEmpty(hardNo) || Strings.isEmpty(reason) || Strings.isEmpty(sn)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.applyUnfreeze(hardNo, sn, reason);
            log.debug("\u7533\u8bf7\u89e3\u51bb\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }

    @RequestMapping(value={"scms/issuingdoublecertinaircontrol/reportWriteState.do"})
    public void reportWriteState(@RequestBody String param, HttpServletResponse response) {
        try {
            log.debug("\u5199\u5361\u72b6\u6001\u4e0a\u62a5\u8bf7\u6c42\u53c2\u6570:{}", (Object)param);
            if (Strings.isEmpty(param)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String hardNo = jsonObject.getString("hardNo");
            String state = jsonObject.getString("state");
            if (Strings.isEmpty(hardNo) || Strings.isEmpty(state)) {
                CertInAirRtn.rtnParamErr(response);
                return;
            }
            CertInAirRtn r = this.issuingDoubleCertInAirService.reportWriteState(hardNo, state);
            log.debug("\u5199\u5361\u72b6\u6001\u4e0a\u62a5\u8fd4\u56de\u6570\u636e:{}", (Object)r);
            CertInAirRtn.rtn(response, r);
        }
        catch (Exception e2) {
            CertInAirRtn.rtnSysErr(response);
        }
    }
}

