/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.dao.impl;

import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.PersonImei;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.dao.DeviceDao;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.sso.bean.SynQueryParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceDaoImpl
implements DeviceDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public Device save(Device device) {
        device.setTimestamp(new Date().getTime());
        this.baseDao.create(device);
        return device;
    }

    @Override
    public void update(Device device) {
        device.setTimestamp(new Date().getTime());
        this.baseDao.update(device);
    }

    @Override
    public void delete(Device device) {
        device.setTimestamp(new Date().getTime());
        this.baseDao.delete(device);
    }

    @Override
    public Device get(Serializable id) {
        return (Device)this.baseDao.getObjectById(Device.class, id);
    }

    @Override
    public Device getByCardNO(String cardNO) {
        return (Device)this.baseDao.getObjectByHQL("from Device where upper(hardNo)=upper(?)", new String[]{cardNO});
    }

    @Override
    public Device getByEnaasUserId(String enaasUserId) {
        return (Device)this.baseDao.getObjectByHQL("from Device where enaasUserId=?", new String[]{enaasUserId});
    }

    @Override
    public List<Device> getByMobile(String mobile) {
        return this.baseDao.getListByHQL("select a from Device a,Mobile b where a.mobile.id=b.id and b.mobile=?", new String[]{mobile});
    }

    @Override
    public List<Device> getUsableByMobile(String mobile) {
        String hql = "select a from Device a,Mobile b where a.mobile.id=b.id and a.revokeFlag <> '1' and a.state <> '0' and b.mobile=?";
        return this.baseDao.getListByHQL(hql, new String[]{mobile});
    }

    @Override
    public Long getMaxLastUpdateTime() {
        String sql = " select max(n_last_update_time) from t_device";
        BigDecimal lastUpdateTime = (BigDecimal)this.baseDao.getObjectBySQL(sql, null);
        if (lastUpdateTime == null) {
            return null;
        }
        return lastUpdateTime.longValue();
    }

    @Override
    public List<Device> query(QueryForm form, Page page) {
        StringBuilder selectb = new StringBuilder("from t_device device,t_person person where device.person_id=person.id ");
        if ("11".equals(form.getCardState())) {
            selectb.append(" and (device.revokeFlag='1')");
        } else if (!"all".equalsIgnoreCase(form.getCardState())) {
            selectb.append(" and (device.revokeFlag<>'1' or device.revokeFlag is null)");
        }
        selectb.append(" and person.flag='0'");
        ArrayList<String> list = new ArrayList<String>();
        if (form != null) {
            if (StringUtils.isNotBlank((CharSequence)form.getCode())) {
                selectb.append(" and person.code like ? ");
                list.add("%" + form.getCode() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getName())) {
                selectb.append(" and person.name like ?");
                list.add("%" + form.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getMobile())) {
                selectb.append(" and device.mobile_id =(select id from t_bims_mobile where mobile=?)");
                list.add(form.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getPersonType())) {
                selectb.append(" and person.person_type = ?");
                list.add(form.getPersonType());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getCardType())) {
                selectb.append(" and device.type=?");
                list.add(form.getCardType());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getCardState()) && !"all".equalsIgnoreCase(form.getCardState())) {
                selectb.append(" and device.state=?");
                list.add(form.getCardState());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getEnaasState())) {
                selectb.append(" and device.enaas_state=?");
                list.add(form.getEnaasState());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getDepName())) {
                selectb.append(" and person.dep_id in (" + BimsUtil.getDepIdByName() + ")");
                list.add("%" + form.getDepName() + "%");
            }
            if (form.getIsContain() != null && form.getIsContain().contains("true")) {
                if (StringUtils.isNotBlank((CharSequence)form.getDepId())) {
                    selectb.append("and person.dep_Id in (select id from t_department connect by prior id = parent_id start with id = '" + form.getDepId() + "')");
                } else {
                    selectb.append("and person.dep_id in (" + BimsUtil.getChildDepsSql(form.getControlDeps()) + ")");
                }
            } else if (StringUtils.isNotBlank((CharSequence)form.getDepId())) {
                selectb.append("and person.dep_Id = '" + form.getDepId() + "' ");
            } else {
                selectb.append("and person.dep_id in (" + BimsUtil.getChildDepsSql(form.getControlDeps()) + ")");
            }
            if (!"all".equals(form.getControlPolice())) {
                selectb.append("and person.police in (" + BimsUtil.getControlPoliceSql(form.getControlPolice()) + ")");
            }
            if (form.getMinLastUpdateTime() != null) {
                selectb.append(" and device.n_last_update_time > " + form.getMinLastUpdateTime());
            }
            if (form.getMaxLastUpdateTime() != null) {
                selectb.append(" and device.n_last_update_time <= " + form.getMaxLastUpdateTime());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getSnPeriod())) {
                String snPeried = form.getSnPeriod();
                if ("0".equals(snPeried)) {
                    selectb.append(" and length(nvl(device.sn,'')) = 15 ");
                } else if ("1".equals(snPeried)) {
                    selectb.append(" and length(nvl(device.sn,'')) = 32 ");
                }
            }
        }
        String selectCount = " select count(*) " + selectb.toString();
        String select = " select device.* " + selectb.toString() + " order by person.code ";
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        return this.baseDao.getListBySQL(selectCount, select, values, page, Device.class);
    }

    @Override
    public List<Device> queryDeviceByImeiImsiIccid(QueryForm form, Page page) {
        StringBuilder selectb = new StringBuilder("from t_device where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)form.getIccid())) {
            selectb.append("  and (iccid=? or cardid=?)");
            list.add(form.getIccid());
            list.add(form.getIccid());
        }
        if (StringUtils.isNotBlank((CharSequence)form.getImei())) {
            selectb.append(" and imei=?");
            list.add(form.getImei());
        }
        if (StringUtils.isNotBlank((CharSequence)form.getImsi())) {
            selectb.append(" and imsi=?");
            list.add(form.getImsi());
        }
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        String selectCount = "select count(*) " + selectb.toString();
        String select = "select * " + selectb.toString();
        return this.baseDao.getListBySQL(selectCount, select, values, page, Device.class);
    }

    @Override
    public List<Device> getApproveCard() {
        String sql = "from Device where state='1'  and (revokeFlag<>'1' or revokeFlag is null)";
        return this.baseDao.getListByHQL(sql, null);
    }

    @Override
    public List<Device> queryByPersonId(String personId) {
        return this.baseDao.getListByHQL("from Device where personId=?  and (revokeFlag<>'1' or revokeFlag is null)", new String[]{personId});
    }

    @Override
    public List<Device> queryAllByPersonId(String personId) {
        return this.baseDao.getListByHQL("from Device where personId=? ", new String[]{personId});
    }

    @Override
    public void updateState(String id, String state) {
        long nowtime = new Date().getTime();
        if ("3".equals(state)) {
            this.baseDao.updateBySql("update t_device set state=?,open_date=sysdate,n_last_update_time=? where id=?", new Object[]{state, nowtime, id});
        }
        if ("4".endsWith(state)) {
            this.baseDao.updateBySql("update t_device set state=?,pause_date=sysdate,n_last_update_time=? where id=?", new Object[]{state, nowtime, id});
        }
    }

    @Override
    public void reBand(String id) {
        long nowtime = new Date().getTime();
        this.baseDao.updateBySql("update t_device set imei='',imsi='',n_last_update_time=? where id=?", new Object[]{nowtime, id});
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void updateBindingState(String bindingState, String personId) {
        long nowtime = new Date().getTime();
        this.baseDao.updateBySql("update t_device set binding_state=?,binding_date=sysdate,imei='',imsi='',n_last_update_time=? where person_id=?", new Object[]{bindingState, nowtime, personId});
    }

    @Override
    public void updateBindingStateById(String bindingState, String id) {
        long nowtime = new Date().getTime();
        this.baseDao.updateBySql("update t_device set binding_state=?,binding_date=sysdate,imei='',imsi='',n_last_update_time=? where id=?", new Object[]{bindingState, nowtime, id});
    }

    @Override
    public List<Device> queryWriteByPersonId(String personId) {
        return this.baseDao.getListByHQL("from Device where personId=? and (state ='2' or state='3' or state='4') and (revokeFlag<>'1' or revokeFlag is null)", new String[]{personId});
    }

    @Override
    public void updateBindStateAll(String bindState) {
        long nowtime = new Date().getTime();
        this.baseDao.updateBySql("update t_device set binding_state=?,binding_date=sysdate,imei='',imsi='',n_last_update_time=? ", new Object[]{bindState, nowtime});
    }

    @Override
    public List<Device> queryListBySql(String select) {
        return this.baseDao.getListBySQL(select, null, Device.class);
    }

    @Override
    public List<Device> querySynDeviceList(SynQueryParam synQueryParam, Page page) {
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "from Device where timestamp > ? ";
        list.add(Long.parseLong(synQueryParam.getLastTime()));
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getUseType())) {
            sql = sql + " and useType= ?";
            list.add(synQueryParam.getUseType());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getCardType())) {
            sql = sql + " and type= ?";
            list.add(synQueryParam.getCardType());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getId())) {
            String[] userIdArray = synQueryParam.getId().split(",");
            String userIdsSql = "";
            for (String userId : userIdArray) {
                userIdsSql = userIdsSql + "'" + userId + "',";
            }
            userIdsSql = userIdsSql.substring(0, userIdsSql.length() - 1);
            sql = sql + " and personId in (" + userIdsSql + ")";
        }
        sql = sql + " order by timestamp asc";
        String selectCount = "select count(*) " + sql;
        String select = sql;
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        return this.baseDao.getListByHQL(selectCount, select, values, page);
    }

    public List getImeisOrImsis(String imeiOrimsi, String flag) {
        if (flag.equals("imei")) {
            return this.baseDao.getListByHQL("from Device where imei=?", new String[]{imeiOrimsi});
        }
        return this.baseDao.getListByHQL("from Device where imsi=?", new String[]{imeiOrimsi});
    }

    @Override
    public List<PersonImei> queryPersonImei(String userIds, String deps) {
        StringBuffer selectb = new StringBuffer("select p.id as \"userId\",d.iccid as \"imei\"  from t_person p, t_device d where p.id=d.person_id and d.iccid is not null ");
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            String[] userIdArray = userIds.split(",");
            String userIdsSql = "";
            for (String userId : userIdArray) {
                userIdsSql = userIdsSql + "'" + userId + "',";
            }
            userIdsSql = userIdsSql.substring(0, userIdsSql.length() - 1);
            selectb.append("and p.id in (" + userIdsSql + ")");
        }
        if (StringUtils.isNotBlank((CharSequence)deps)) {
            selectb.append("and p.dep_id in (" + BimsUtil.getChildDepsSql(deps) + ")");
        }
        return this.baseDao.getListBySQL(selectb.toString(), null, PersonImei.class);
    }

    @Override
    public List<Device> queryVideoDeviceList(long timestamp, Page page) {
        ArrayList<Long> list = new ArrayList<Long>();
        String sql = "from Device where timestamp > ? and state = '3' ";
        list.add(timestamp);
        sql = sql + " order by timestamp asc";
        String selectCount = "select count(*) " + sql;
        String select = sql;
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        return this.baseDao.getListByHQL(selectCount, select, values, page);
    }
}

