/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.dao.TerminalLogDao;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.service.TerminalReportService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalLogServiceImpl
implements TerminalLogService {
    @Autowired
    private TerminalLogDao terminalLogDao;
    @Autowired
    private TerminalReportService terminalReportService;

    @Override
    public List<TerminalLog> query(Page page) {
        return this.terminalLogDao.query(page);
    }

    @Override
    @Transactional(readOnly=false)
    public TerminalLog save(TerminalLog terminalLog) {
        if (StringUtils.isBlank((CharSequence)terminalLog.getReadFlag())) {
            terminalLog.setReadFlag("0");
        }
        if (StringUtils.isBlank((CharSequence)terminalLog.getSynchoreFlag())) {
            terminalLog.setSynchoreFlag("0");
        }
        return this.terminalLogDao.save(terminalLog);
    }

    @Override
    @Transactional(readOnly=false)
    public void update(TerminalLog terminalLog) {
        if (StringUtils.isBlank((CharSequence)terminalLog.getReadFlag())) {
            terminalLog.setReadFlag("0");
        }
        if (StringUtils.isBlank((CharSequence)terminalLog.getSynchoreFlag())) {
            terminalLog.setSynchoreFlag("0");
        }
        this.terminalLogDao.update(terminalLog);
    }

    @Override
    @Transactional(readOnly=false)
    public void update(String id, String readFlag) {
        this.terminalLogDao.update(id, readFlag);
    }

    @Override
    @Transactional
    public void submit() throws Exception {
        List<TerminalLog> failList = this.terminalLogDao.queryFail();
        for (TerminalLog terminalLog : failList) {
            String rtnFlag = this.terminalReportService.report(terminalLog);
            if (rtnFlag != null) continue;
            throw new Exception();
        }
    }

    public void terminalReport() {
    }

    public TerminalLogDao getTerminalLogDao() {
        return this.terminalLogDao;
    }

    public void setTerminalLogDao(TerminalLogDao terminalLogDao) {
        this.terminalLogDao = terminalLogDao;
    }
}

