/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.smcs.bean.ReportInfo;
import com.xdja.pams.smcs.bean.SmcsTypeEnum;
import com.xdja.pams.smcs.dao.SmcsDao;
import com.xdja.pams.smcs.service.impl.SmcsAbstactReportServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcsDeviceReportServiceImpl
extends SmcsAbstactReportServiceImpl<Device> {
    @Autowired
    private SmcsDao smcsDao;
    private static final Logger log = LoggerFactory.getLogger(SmcsAbstactReportServiceImpl.class);

    @Override
    public List<Device> queryAscReportList(Long lastUpdateTime, Integer batchSize) {
        return this.smcsDao.queryAscDeviceList(lastUpdateTime, batchSize);
    }

    @Override
    protected long getObjectUpdateTime(Device device) {
        return device.getTimestamp();
    }

    @Override
    protected boolean isDeleteObject(Device device) {
        return false;
    }

    @Override
    protected Map<String, String> formatDeleteReportMap(Device reportDevice) {
        return null;
    }

    @Override
    protected List<Map<String, String>> formatReportList(List<Device> reportList) throws Exception {
        ArrayList<Map<String, String>> formatList = new ArrayList<Map<String, String>>();
        for (Device device : reportList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("deviceId", device.getId());
            map.put("userId", device.getPersonId());
            map.put("name", device.getName());
            map.put("state", device.getState());
            map.put("type", device.getType());
            map.put("isUse", device.getFlag());
            if (device.getApplyDate() != null) {
                map.put("applyDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getApplyDate()));
            }
            if (device.getOpenDate() != null) {
                map.put("openDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getOpenDate()));
            }
            if (device.getExamineDate() != null) {
                map.put("examineDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getExamineDate()));
            }
            if (device.getRevocationDate() != null) {
                map.put("revocationDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getRevocationDate()));
            }
            if (device.getPauseDate() != null) {
                map.put("pauseDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getPauseDate()));
            }
            map.put("sn", device.getSn());
            map.put("hardNo", device.getHardNo());
            map.put("iccid", device.getIccid());
            map.put("algType", device.getAlgType());
            map.put("certificate", "");
            if (device.getWriteCardDate() != null) {
                map.put("writeCardDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getWriteCardDate()));
            }
            map.put("imsi", device.getImsi());
            map.put("imei", device.getImei());
            map.put("lockState", device.getLockState());
            map.put("bindingState", device.getBindingState());
            if (device.getBindingDate() != null) {
                map.put("bindingDate", Util.getDate("yyyy-MM-dd HH:mm:ss", device.getBindingDate()));
            }
            map.put("commType", device.getCommType());
            map.put("time", Util.getDate("yyyy-MM-dd HH:mm:ss"));
            formatList.add(map);
        }
        return formatList;
    }

    @Override
    public void doReport() throws Exception {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSwitchCode("SMCS_DEVICE_SWITCH");
        reportInfo.setTimestampCode("SMCS_DEVICE_TIMESTAMP");
        reportInfo.setSaveUrl("/api/public/person/device/save");
        reportInfo.setSmcsTypeEnum(SmcsTypeEnum.smcsDevice);
        log.debug("\u589e\u91cf\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5b89\u5168\u5361\u7ebf\u7a0b\u5f00\u59cb\u3002reportInfo:{}", (Object)JSON.toJSONString((Object)reportInfo));
        super.doReport(reportInfo);
    }
}

