/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.EncryptDeciphering;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sso.bean.CheckBillResult;
import com.xdja.pams.sso.bean.LoginParam;
import com.xdja.pams.sso.bean.LoginRst;
import com.xdja.pams.sso.bean.LoginTypeRst;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.bean.UpdatePasswordParam;
import com.xdja.pams.sso.bean.UserInfo;
import com.xdja.pams.sso.service.AppPlatformService;
import com.xdja.pams.sso.service.SingleSignOnService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SingleSignOnControl
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SingleSignOnService singleSignOnService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private AppPlatformService appPlatformService;
    private static Logger log = Logger.getLogger(SingleSignOnControl.class);

    @RequestMapping(value={"/sso/singlesignoncontrol/getlogintype.do"})
    public void getLoginType(HttpServletRequest request, PageParam page, HttpServletResponse response) {
        LoginTypeRst rst = new LoginTypeRst();
        try {
            String loginType = this.singleSignOnService.getLoginType();
            rst.setFlag("0");
            rst.setMessage("");
            rst.setLoginType(loginType);
        }
        catch (Exception e2) {
            log.error((Object)("\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u5931\u8d25\uff1a" + e2.getMessage()), (Throwable)e2);
            rst.setFlag("1");
            rst.setMessage(e2.getMessage());
            rst.setLoginType("");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rst));
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/login.do"})
    public void login(HttpServletRequest request, HttpServletResponse response, LoginParam loginParam) {
        LoginRst loginRst = null;
        long startTime = new Date().getTime();
        try {
            loginRst = this.singleSignOnService.login(loginParam);
            log.info((Object)("\u751f\u6210\u7968\u636e\u8017\u65f6\uff1a" + (new Date().getTime() - startTime)));
            if (StringUtils.isNotBlank((CharSequence)loginRst.getResult().getId())) {
                int operateResult = 1;
                if (!"0".equals(loginRst.getResult().getFlag())) {
                    operateResult = 0;
                    log.info((Object)("\u767b\u5f55\u5931\u8d25:" + loginRst.getResult().getMessage() + ",\u786c\u4ef6\u7f16\u53f7\uff1a" + loginParam.getCardNo()));
                } else {
                    log.info((Object)("\u767b\u5f55\u6210\u529f\uff0c\u786c\u4ef6\u7f16\u53f7\uff1a" + loginParam.getCardNo()));
                }
                long startTime2 = new Date().getTime();
                Person person = this.userManagerService.queryPersonById(loginRst.getResult().getId());
                if (person != null) {
                    this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), 6, operateResult, "", "", "", "SSO", "");
                }
                log.info((Object)("\u4fdd\u5b58\u767b\u5f55\u65e5\u5fd7\u8017\u65f6\uff1a" + (new Date().getTime() - startTime2)));
            } else {
                log.info((Object)("\u767b\u5f55\u5931\u8d25\uff0c\u786c\u4ef6\u7f16\u53f7\uff1a" + loginParam.getCardNo()));
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff1a" + e2.getMessage()), (Throwable)e2);
            loginRst = new LoginRst("1", MessageManager.getProMessage(this.message, "sso.singlesignonservice.error.loginfail") + ":" + e2.getMessage());
        }
        log.info((Object)("\u8fd4\u56de\u7968\u636e\u8017\u65f6\uff1a" + (new Date().getTime() - startTime)));
        Util.writeUtf8Text(response, Util.toJsonStr(loginRst));
    }

    public SystemLogService getSystemLogService() {
        return this.systemLogService;
    }

    public void setSystemLogService(SystemLogService systemLogService) {
        this.systemLogService = systemLogService;
    }

    public UserManageService getUserManagerService() {
        return this.userManagerService;
    }

    public void setUserManagerService(UserManageService userManagerService) {
        this.userManagerService = userManagerService;
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/checkbill.do"})
    public void checkBill(HttpServletResponse response, HttpServletRequest request, String strBill) {
        CheckBillResult result = null;
        try {
            strBill = EncryptDeciphering.getInstance().decrypt(strBill);
            log.info((Object)("\u7968\u636e\u9a8c\u8bc1\u53c2\u6570:" + strBill));
            Result result0 = this.singleSignOnService.checkBill(strBill);
            result = new CheckBillResult(result0.getFlag(), result0.getMessage(), result0.getId());
            if ("0".equals(result.getFlag())) {
                result.setUserInfo(this.singleSignOnService.getUserInfoFromBillJson(strBill));
            }
            if (StringUtils.isNotBlank((CharSequence)result.getId())) {
                Person person;
                int operateResult = 1;
                if (!"0".equals(result.getFlag())) {
                    operateResult = 0;
                }
                if ((person = this.userManagerService.queryPersonById(result.getId())) != null) {
                    this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), 7, operateResult, "", "", "", "SSO", "");
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u7528\u6237\u7968\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a" + e2.getMessage()), (Throwable)e2);
            result = new CheckBillResult("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.checkerror"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/checkbill2.do"})
    public void checkBill2(HttpServletResponse response, HttpServletRequest request, String strBill) {
        CheckBillResult result = null;
        try {
            strBill = EncryptDeciphering.getInstance().decrypt(strBill);
            log.info((Object)("\u7968\u636e\u9a8c\u8bc1\u53c2\u6570:" + strBill));
            Result result0 = this.singleSignOnService.checkBill(strBill);
            result = new CheckBillResult(result0.getFlag(), result0.getMessage(), result0.getId());
            if ("0".equals(result.getFlag())) {
                UserInfo userInfo = this.singleSignOnService.getUserInfoFromBillJson(strBill);
                List<String> limits = this.appPlatformService.getLimitAndType(userInfo.getId());
                if (limits != null) {
                    userInfo.setLimits(limits.toArray(new String[0]));
                }
                result.setUserInfo(userInfo);
            }
            if (StringUtils.isNotBlank((CharSequence)result.getId())) {
                Person person;
                int operateResult = 1;
                if (!"0".equals(result.getFlag())) {
                    operateResult = 0;
                }
                if ((person = this.userManagerService.queryPersonById(result.getId())) != null) {
                    this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), 7, operateResult, "", "", "", "SSO", "");
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u7528\u6237\u7968\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a" + e2.getMessage()), (Throwable)e2);
            result = new CheckBillResult("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.checkerror"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/delaybill.do"})
    public void delayBill(HttpServletResponse response, HttpServletRequest request, String strBill) {
        LoginRst loginRst = null;
        try {
            strBill = EncryptDeciphering.getInstance().decrypt(strBill);
            log.info((Object)("\u7968\u636e\u9a8c\u8bc1\u53c2\u6570:" + strBill));
            loginRst = this.singleSignOnService.delayBill(strBill);
            if (StringUtils.isNotBlank((CharSequence)loginRst.getResult().getId())) {
                Person person;
                int operateResult = 1;
                if (!"0".equals(loginRst.getResult().getFlag())) {
                    operateResult = 0;
                }
                if ((person = this.userManagerService.queryPersonById(loginRst.getResult().getId())) != null) {
                    this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), Util.getRemortIP(request), 8, operateResult, "", "", "", "SSO", "");
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u7528\u6237\u7968\u636e\u5ef6\u671f\u5931\u8d25\uff1a" + e2.getMessage()), (Throwable)e2);
            loginRst = new LoginRst("1", MessageManager.getProMessage(this.message, "sso.singlesignonservice.error.delaybillfail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(loginRst));
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/updatepassword.do"})
    public void updatePassword(HttpServletResponse response, HttpServletRequest request, UpdatePasswordParam param) {
        Result result = null;
        try {
            result = this.singleSignOnService.updatePassword(param);
        }
        catch (Exception e2) {
            log.error((Object)("\u7528\u6237\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff1a" + e2.getMessage()));
            result = new Result("1", e2.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sso/singlesignoncontrol/limitstest.do"})
    public void limitsTest(HttpServletResponse response, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)request.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        String rst = "{\"jsonrpc\":\"2.0\" ,\"id\":\"1\",\"result\":{\"resultStatus\":\"0\",\"content\":[{\"appName\":\"com.xdja.authorizelogin\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.simc.jx.plugin\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.example.startmyactivity\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.xxcj\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.hcbd\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.txl\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.jwzs\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.gps\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.mam\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.tyrztest\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.service.XmppService\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"},{\"appName\":\"com.xdja.jwt.zhcx\",\"typeId\":\"4\",\"appVersion\":\"1.0.12345\"}]}}";
        Util.writeUtf8Text(response, rst);
    }

    public SingleSignOnService getSingleSignOnService() {
        return this.singleSignOnService;
    }

    public void setSingleSignOnService(SingleSignOnService singleSignOnService) {
        this.singleSignOnService = singleSignOnService;
    }
}

