/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class CommonCodeController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(CommonCodeController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/syms/commoncodecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/syms/commoncodecontroller/getTreeChild.do"})
    public void getTreeChild(String id, HttpServletResponse response) throws IOException {
        List<CommonCode> list = this.commonCodeService.queryByTypeIdDictManage(id);
        ArrayList treelist = new ArrayList();
        for (CommonCode code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", code.getId());
            map.put("text", code.getName());
            map.put("state", "closed");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("selectAble", "true");
            attributes.put("code", code.getCode());
            attributes.put("name", code.getName());
            attributes.put("status", code.getStatus());
            map.put("attributes", attributes);
            treelist.add(map);
        }
        String jsonlist = Util.toJsonStr(treelist);
        if (StringUtils.isBlank((CharSequence)id)) {
            jsonlist = "[{\"text\":\"\u5b57\u5178\u7c7b\u578b\",\"checked\":\"true\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/syms/commoncodecontroller/getTreeChildQuery.do"})
    public void getTreeChildQuery(String id, HttpServletResponse response) throws IOException {
        List<CommonCode> list = this.commonCodeService.queryByTypeIdDictManage(id);
        CommonCode commonCode = null;
        if (!StringUtils.isBlank((CharSequence)id)) {
            commonCode = this.commonCodeService.get((Serializable)((Object)id));
        }
        ArrayList treelist = new ArrayList();
        for (CommonCode code : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", code.getId());
            map.put("text", code.getName());
            map.put("state", "closed");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("selectAble", "true");
            attributes.put("code", code.getCode());
            attributes.put("name", code.getName());
            attributes.put("status", code.getStatus());
            map.put("attributes", attributes);
            treelist.add(map);
        }
        String jsonlist = Util.toJsonStr(treelist);
        jsonlist = StringUtils.isBlank((CharSequence)id) ? "[{\"text\":\"\u5b57\u5178\u7c7b\u578b\",\"checked\":\"true\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]" : "[{\"id\":\"" + commonCode.getId() + "\",\"text\":\"" + commonCode.getName() + "\",\"checked\":\"true\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/syms/commoncodecontroller/queryList.do"})
    public void queryCommonCodeList(String type, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        ArrayList codelist = new ArrayList();
        try {
            List<CommonCode> list = this.commonCodeService.queryByTypeId(type);
            for (CommonCode code : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", code.getId());
                map.put("name", code.getName());
                map.put("code", code.getCode());
                map.put("orderField", code.getOrderField());
                map.put("note", code.getNote());
                map.put("status", code.getStatus());
                codelist.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(codelist.size()));
        map.put("rows", codelist);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text(response, json);
    }

    @RequestMapping(value={"/syms/commoncodecontroller/queryListDictManage.do"})
    public void queryCommonCodeListDictManage(String type, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        ArrayList codelist = new ArrayList();
        try {
            List<CommonCode> list = this.commonCodeService.queryByTypeIdDictManage(type);
            for (CommonCode code : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", code.getId());
                map.put("name", code.getName());
                map.put("code", code.getCode());
                map.put("orderField", code.getOrderField());
                map.put("note", code.getNote());
                map.put("status", code.getStatus());
                codelist.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(codelist.size()));
        map.put("rows", codelist);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text(response, json);
    }

    @RequestMapping(value={"/syms/commoncodecontroller/addType.do"})
    public String addType(String id, ModelMap map) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            map.put((Object)"id", (Object)id);
        }
        return "syms/commoncode/default/addType";
    }

    @RequestMapping(value={"/syms/commoncodecontroller/addCode.do"})
    public String addCode(String id, String type, ModelMap map) {
        CommonCode pCode = this.commonCodeService.get((Serializable)((Object)type));
        map.put((Object)"pCode", (Object)pCode);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            map.put((Object)"id", (Object)id);
        }
        return "syms/commoncode/default/addCode";
    }

    @RequestMapping(value={"/syms/commoncodecontroller/saveCommonCode.do"})
    public void saveCommoncode(CommonCode commonCode, HttpServletResponse response, HttpServletRequest request) throws IOException {
        HashMap<String, String> rst = new HashMap<String, String>();
        int operateResult = 0;
        Object jsonStr = null;
        Operator operator = null;
        Person person = null;
        try {
            if (StringUtils.isBlank((CharSequence)commonCode.getCode()) || StringUtils.isBlank((CharSequence)commonCode.getName())) {
                rst.put("flag", "0");
                rst.put("message", "\u53c2\u6570\u9519\u8bef");
                log.error("\u4fdd\u5b58\u5b57\u5178\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
            } else {
                HttpSession session = request.getSession();
                operator = (Operator)session.getAttribute("operator");
                person = operator.getPerson();
                this.commonCodeService.save(commonCode);
                operateResult = 1;
                rst.put("flag", "1");
                rst.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            rst.put("flag", "0");
            rst.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            log.error("\u4fdd\u5b58\u5b57\u5178\u5931\u8d25");
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(rst));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/update.do"})
    public void updateCommonCode(CommonCode code, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)code.getCode()) || StringUtils.isBlank((CharSequence)code.getName()) || StringUtils.isBlank((CharSequence)code.getId())) {
            map.put("flag", "0");
            map.put("message", "\u53c2\u6570\u9519\u8bef");
            log.error("\u66f4\u65b0\u5b57\u5178\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        } else {
            HttpSession session = request.getSession();
            operator = (Operator)session.getAttribute("operator");
            person = operator.getPerson();
            try {
                this.commonCodeService.update(code);
                operateResult = 1;
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                operateResult = 0;
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.commonCodeService.delete((Serializable)((Object)id));
            operateResult = 1;
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/checkType.do"})
    public void checkType(String typeCode, String typeName, String id, HttpServletResponse response) {
        boolean flag = false;
        try {
            flag = this.commonCodeService.checkCode(typeCode, typeName, null, id);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, Boolean.toString(flag));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/checkCode.do"})
    public void checkCode(String code, String name, String pcodeId, String id, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)pcodeId)) {
            CommonCode pcode = this.commonCodeService.get((Serializable)((Object)pcodeId));
            if (pcode != null) {
                boolean flag = this.commonCodeService.checkCode(code, name, pcode.getCode(), id);
                Util.writeUtf8Text(response, Boolean.toString(flag));
            } else {
                Util.writeUtf8Text(response, Boolean.toString(false));
            }
        }
    }

    @RequestMapping(value={"/syms/commoncodecontroller/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        CommonCode code = this.commonCodeService.get((Serializable)((Object)id));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", code.getId());
        map.put("name", code.getName());
        map.put("code", code.getCode());
        map.put("note", code.getNote());
        map.put("orderField", code.getOrderField());
        map.put("status", code.getStatus());
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/getCommonCodeByName.do"})
    public void getCommonCodeByName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String name = URLDecoder.decode(q, "Utf-8");
            List<Map<String, Object>> listmap = this.commonCodeService.getCommonCodeJsonByName(name, limit);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    public CommonCodeService getCommonCodeService() {
        return this.commonCodeService;
    }

    public void setCommonCodeService(CommonCodeService commonCodeService) {
        this.commonCodeService = commonCodeService;
    }

    @RequestMapping(value={"/syms/commoncodecontroller/getCommonCodeByNameDictManage.do"})
    public void getCommonCodeByNameDictManage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String name = URLDecoder.decode(q, "Utf-8");
            List<Map<String, Object>> listmap = this.commonCodeService.getCommonCodeJsonByNameDictManage(name, limit);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/syms/commoncodecontroller/updDictStatus.do"})
    public void updDictStatus(CommonCode code, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            boolean existDisableParentTypeFlag = false;
            if (StringUtils.isNotBlank((CharSequence)code.getStatus()) && "1".equals(code.getStatus())) {
                existDisableParentTypeFlag = this.commonCodeService.queryExistDisableParentType(code);
            }
            if (existDisableParentTypeFlag) {
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.check.fail"));
            } else {
                this.commonCodeService.updDictStatus(code);
                operateResult = 1;
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/syms/commoncodecontroller/updDictStatusBatch.do"})
    public void updDictStatusBatch(String ids, String status, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            boolean existDisableParentTypeFlag = false;
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                String[] commoncodeIdArray = ids.split(",");
                StringBuffer sb = new StringBuffer(" ");
                for (String id : commoncodeIdArray) {
                    sb.append("'");
                    sb.append(id);
                    sb.append("',");
                }
                ids = sb.toString();
                ids = ids.substring(0, ids.length() - 1);
            }
            if (!StringUtils.isNotBlank((CharSequence)ids) || !StringUtils.isNotBlank((CharSequence)status)) {
                existDisableParentTypeFlag = false;
            } else if ("1".equals(status)) {
                existDisableParentTypeFlag = this.commonCodeService.queryExistDisableParentTypeBatch(ids);
            }
            if (existDisableParentTypeFlag) {
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.check.fail"));
            } else {
                this.commonCodeService.updDictStatusBatch(ids, status);
                operateResult = 1;
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }
}

