/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.bean.DinfoUpdataBean;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
@RequestMapping(value={"syms/dinfo_sysconfigcontroller"})
public class DInfoSysConfigController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DInfoSysConfigController.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final String NOTDIVERSION = "0";
    private static final String _FJ = "_FJ";
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            SystemConfig sysCfgTheme = this.systemConfigService.getByCode("systemTheme");
            if (sysCfgTheme != null) {
                map.put((Object)"sysCfgTheme", (Object)sysCfgTheme);
            }
            String theme = this.operator.getPerson().getTheme();
            map.put((Object)"theme", (Object)theme);
            SystemConfig isDiversionComConfig = this.systemConfigService.getByCode("-Dinfo_IS_DIVERSION_COM");
            map.put((Object)"isDiversionCom", (Object)isDiversionComConfig.getValue());
            SystemConfig isDiversionPersionTypeConfig = this.systemConfigService.getByCode("-Dinfo_IS_DIVERSION_PERSONTYPE");
            map.put((Object)"isDiversionPersonType", (Object)isDiversionPersionTypeConfig.getValue());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/queryD.do"})
    public void query(HttpServletResponse response, String name, String isDiversionCom, String isDiversionPersonType, String isDiversionComF, String isDiversionPersonTypeF) {
        SystemConfig dInfoLT;
        SystemConfig dInfoDX;
        SystemConfig dInfo;
        if (Strings.isEmpty(isDiversionCom)) {
            isDiversionCom = isDiversionComF;
        }
        if (Strings.isEmpty(isDiversionPersonType)) {
            isDiversionPersonType = isDiversionPersonTypeF;
        }
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        if (NOTDIVERSION.equals(isDiversionCom)) {
            if (NOTDIVERSION.equals(isDiversionPersonType)) {
                dInfo = this.systemConfigService.getByCode("-Dinfo");
                list.add(dInfo);
                List<SystemConfig> s_list = this.systemConfigService.getByType(dInfo.getId());
                this.systemConfigService.updateDInfoConfig(s_list, isDiversionCom, isDiversionPersonType);
            } else {
                dInfo = this.systemConfigService.getByCode("-Dinfo");
                SystemConfig dInfo_fj = this.systemConfigService.getByCode("-Dinfo_FJ");
                list.add(dInfo);
                list.add(dInfo_fj);
                List<SystemConfig> s_list = this.systemConfigService.getByType(dInfo.getId());
                List<SystemConfig> s_list_fj = this.systemConfigService.getByType(dInfo_fj.getId());
                this.systemConfigService.updateDInfoConfig(s_list, isDiversionCom, isDiversionPersonType);
                this.systemConfigService.updateDInfoConfig(s_list_fj, isDiversionCom, isDiversionPersonType);
            }
        } else if (NOTDIVERSION.equals(isDiversionPersonType)) {
            dInfo = this.systemConfigService.getByCode("-Dinfo");
            dInfoDX = this.systemConfigService.getByCode("-Dinfo_DX");
            dInfoLT = this.systemConfigService.getByCode("-Dinfo_LT");
            list.add(dInfo);
            list.add(dInfoDX);
            list.add(dInfoLT);
            List<SystemConfig> s_list = this.systemConfigService.getByType(dInfo.getId());
            List<SystemConfig> s_list_dx = this.systemConfigService.getByType(dInfoDX.getId());
            List<SystemConfig> s_list_lt = this.systemConfigService.getByType(dInfoLT.getId());
            this.systemConfigService.updateDInfoConfig(s_list, isDiversionCom, isDiversionPersonType);
            this.systemConfigService.updateDInfoConfig(s_list_dx, isDiversionCom, isDiversionPersonType);
            this.systemConfigService.updateDInfoConfig(s_list_lt, isDiversionCom, isDiversionPersonType);
        } else {
            dInfo = this.systemConfigService.getByCode("-Dinfo");
            dInfoDX = this.systemConfigService.getByCode("-Dinfo_DX");
            dInfoLT = this.systemConfigService.getByCode("-Dinfo_LT");
            SystemConfig dInfo_fj = this.systemConfigService.getByCode("-Dinfo_FJ");
            SystemConfig dInfoDX_fj = this.systemConfigService.getByCode("-Dinfo_DX_FJ");
            SystemConfig dInfoLT_fj = this.systemConfigService.getByCode("-Dinfo_LT_FJ");
            list.add(dInfo);
            list.add(dInfoDX);
            list.add(dInfoLT);
            list.add(dInfo_fj);
            list.add(dInfoDX_fj);
            list.add(dInfoLT_fj);
        }
        SystemConfig isDiversionComConfig = this.systemConfigService.getByCode("-Dinfo_IS_DIVERSION_COM");
        SystemConfig isDiversionPersonTypeConfig = this.systemConfigService.getByCode("-Dinfo_IS_DIVERSION_PERSONTYPE");
        isDiversionComConfig.setValue(isDiversionCom);
        isDiversionPersonTypeConfig.setValue(isDiversionPersonType);
        this.systemConfigService.update(isDiversionComConfig);
        this.systemConfigService.update(isDiversionPersonTypeConfig);
        try {
            for (SystemConfig pSC : list) {
                List<SystemConfig> list2 = pSC.getcSystemConfig();
                for (int i = 0; i < list2.size(); ++i) {
                    for (int j = i + 1; j < list2.size(); ++j) {
                        if (list2.get(i).getCode().compareTo(list2.get(j).getCode()) <= 0) continue;
                        SystemConfig temp = list2.get(i);
                        list2.set(i, list2.get(j));
                        list2.set(j, temp);
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        ArrayList listmap = new ArrayList();
        for (SystemConfig pSC : list) {
            String id = "";
            List<SystemConfig> listMatch = null;
            if (!Util.varCheckEmp(name)) {
                if (pSC.getName().contains(name)) {
                    id = pSC.getId();
                } else {
                    for (SystemConfig cSC : pSC.getcSystemConfig()) {
                        if (!cSC.getName().contains(name)) continue;
                        id = pSC.getId();
                        break;
                    }
                }
                if (!Util.varCheckEmp(id)) {
                    listMatch = this.systemConfigService.getById(id).getcSystemConfig();
                }
            } else {
                listMatch = pSC.getcSystemConfig();
            }
            if (null == listMatch) continue;
            for (SystemConfig cSC : listMatch) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", cSC.getId());
                map.put("name", cSC.getName());
                map.put("code", cSC.getCode());
                map.put("value", cSC.getValue());
                map.put("note", cSC.getNote());
                map.put("group", pSC.getName());
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("type", "validatebox");
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("validType", "length[0,128]");
                editor.put("options", options);
                map.put("editor", editor);
                map.put("type", pSC.getId());
                listmap.add(map);
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/update.do"})
    public void update(@RequestBody String json, HttpServletRequest request, HttpServletResponse response) {
        Map<Object, Object> map;
        DinfoUpdataBean dinfoUpdataBean = (DinfoUpdataBean)JSON.parseObject((String)json, DinfoUpdataBean.class);
        List<SystemConfig> list = dinfoUpdataBean.getSystemConfigs();
        String isDiversionCom = dinfoUpdataBean.getIsDiversionCom();
        String isDiversionPersonType = dinfoUpdataBean.getIsDiversionPersonType();
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        try {
            map = this.systemConfigService.updateDInfoConfig(list, isDiversionCom, isDiversionPersonType);
        }
        catch (Exception e2) {
            map = new HashMap();
            map.put("flag", NOTDIVERSION);
            map.put("message", e2.getMessage());
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, Integer.parseInt((String)map.get("flag")), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }
}

