/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.dao.CommonCodeDao;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonCodeServiceImpl
implements CommonCodeService,
CommonCodePbService {
    @Autowired
    private CommonCodeDao commonCodeDao;

    @Override
    public List<CommonCode> queryByType(String type) {
        return this.commonCodeDao.queryByType(type);
    }

    @Override
    public String queryJsonByType(String type) {
        String json = Util.toJsonStr(this.queryByType(type));
        return json;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public CommonCode save(CommonCode commonCode) {
        return this.commonCodeDao.save(commonCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(CommonCode commonCode) {
        this.commonCodeDao.update(commonCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void delete(Serializable id) {
        CommonCode commonCode = this.get(id);
        this.commonCodeDao.delete(commonCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteByType(String type) {
        this.commonCodeDao.deleteByType(type);
    }

    @Override
    public boolean checkCode(String code, String name, String type, String id) {
        CommonCode commonCode = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            commonCode = this.getByCode(code, type);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            commonCode = this.getByName(name, type);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            if (commonCode == null) {
                return true;
            }
            return commonCode == null || commonCode.getId().equals(id);
        }
        return commonCode == null;
    }

    @Override
    public CommonCode get(Serializable id) {
        return this.commonCodeDao.get(id);
    }

    @Override
    public CommonCode getByCode(String code, String type) {
        return this.commonCodeDao.getByTypeAndCode(type, code);
    }

    public CommonCode getByName(String name, String type) {
        return this.commonCodeDao.getByTypeAndName(type, name);
    }

    public CommonCodeDao getCommonCodeDao() {
        return this.commonCodeDao;
    }

    public void setCommonCodeDao(CommonCodeDao commonCodeDao) {
        this.commonCodeDao = commonCodeDao;
    }

    @Override
    public String getCodeNameByCode(String code, String type) {
        String rtn = null;
        CommonCode cc = this.getByCode(code, type);
        if (cc != null) {
            String tmpName = cc.getName();
            rtn = tmpName == null ? "&nbsp;" : tmpName;
        }
        return rtn;
    }

    @Override
    public List<CommonCode> queryByTypeId(String id) {
        return this.commonCodeDao.queryByTypeId(id);
    }

    @Override
    public List<Map<String, Object>> getCommonCodeJsonByName(String q, String limit) {
        CommonCode commonCode = new CommonCode();
        commonCode.setName(q);
        Page page = new Page("1", limit);
        List<CommonCode> commonCodeList = this.commonCodeDao.queryByName(commonCode, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (CommonCode getCommonCode : commonCodeList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", getCommonCode.getName());
            item.put("codeId", getCommonCode.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public void updDictStatus(CommonCode code) throws Exception {
        this.commonCodeDao.updDictStatus(code);
    }

    @Override
    public boolean queryExistDisableParentType(CommonCode code) throws Exception {
        return this.commonCodeDao.queryExistDisableParentType(code);
    }

    @Override
    public List<Map<String, Object>> getCommonCodeJsonByNameDictManage(String q, String limit) {
        CommonCode commonCode = new CommonCode();
        commonCode.setName(q);
        Page page = new Page("1", limit);
        List<CommonCode> commonCodeList = this.commonCodeDao.queryByNameDictManage(commonCode, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (CommonCode getCommonCode : commonCodeList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", getCommonCode.getName());
            item.put("codeId", getCommonCode.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public List<CommonCode> queryByTypeIdDictManage(String id) {
        return this.commonCodeDao.queryByTypeIdDictManage(id);
    }

    @Override
    public boolean queryExistDisableParentTypeBatch(String ids) {
        return this.commonCodeDao.queryExistDisableParentTypeBatch(ids);
    }

    @Override
    public void updDictStatusBatch(String ids, String status) {
        this.commonCodeDao.updDictStatusBatch(ids, status);
    }

    @Override
    public List<?> getListBySqlDynamic(String selCount, String selSql, String[] values, Page page, List<String> nameKeys, String className) throws Exception {
        return this.commonCodeDao.getListBySqlDynamic(selCount, selSql, values, page, nameKeys, className);
    }
}

