/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.control;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.syn.bean.MDPPersonRoleBean;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.entity.MDPPerson;
import com.xdja.pams.syn.service.MdpPersonService;
import com.xdja.pams.syn.service.PersonMDPService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.mdpcard.entity.ThirdKey;
import pams.function.mdp.mdpcard.service.MdpCardService;

@Controller
@Scope(value="session")
public class PamsToMDPControl {
    private static final Logger log = LoggerFactory.getLogger(PamsToMDPControl.class);
    @Autowired
    private PersonMDPService personMDPService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private MdpPersonService mdpPersonService;
    @Autowired
    private MdpCardService mdpCardService;

    @RequestMapping(value={"sso/pamstomdpcontrol/queryMDPAndPolice.do"})
    public String queryMDPAndPolice(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        SynRst<Object> synRst = new SynRst();
        try {
            log.info("\u67e5\u8be2\u53c2\u6570" + Util.toJsonStr(param));
            synRst = this.personMDPService.queryMDPAndPolice(param);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7528\u6237\u548c\u8b66\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String synRstJson = Util.toJsonStr(synRst);
        log.debug("\u67e5\u8be2\u6210\u529f" + synRstJson);
        Util.writeUtf8Text(response, synRstJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/addMDPPerson.do"})
    public String addMDPPerson(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        Result result = new Result();
        try {
            result = this.personMDPService.addMDPPerson(param);
        }
        catch (Exception e2) {
            log.error("\u6dfb\u52a0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + param.getPerson(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8Text(response, resultJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/updateMDPPerson.do"})
    public String updateMDPPerson(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        Result result = new Result();
        try {
            result = this.personMDPService.updateMDPPerson(param);
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8Text(response, resultJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/deleteMDPPerson.do"})
    public String deletMDPPerson(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        Result result = new Result();
        try {
            result = this.personMDPService.deleteMDPPerson(param);
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + param.getPersonId(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8Text(response, resultJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/updatePassword.do"})
    public String updatePassword(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        Result result = new Result();
        try {
            result = this.personMDPService.updatePassword(param);
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u7528\u6237\u5bc6\u7801\u5931\u8d25\uff1a" + param.getPersonId(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8Text(response, resultJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/updateMDPPasswordForAdmin.do"})
    public String updateMDPPasswordForAdmin(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        Result result = new Result();
        try {
            result = this.personMDPService.updateMDPPasswordForAdmin(param);
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u7528\u6237\u5bc6\u7801\u5931\u8d25\uff1a" + param.getPersonId(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8Text(response, resultJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/queryPersonById.do"})
    public String queryPersonById(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        SynRst<Object> synRst = new SynRst();
        String pageNo = "1";
        String pageSize = "1";
        param.setPageNo(pageNo);
        param.setPageSize(pageSize);
        try {
            synRst = this.personMDPService.queryMDPAndPolice(param);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7528\u6237\u548c\u8b66\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String synRstJson = Util.toJsonStr(synRst);
        Util.writeUtf8Text(response, synRstJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/queryPersonByUserName.do"})
    public String queryPersonByUserName(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, QueryParamPoliceAndMDP param) {
        SynRst<Object> synRst = new SynRst();
        try {
            synRst = this.personMDPService.queryMDPAndPoliceByUserName(param);
        }
        catch (Exception e2) {
            log.error("\u6839\u636e\u7528\u6237\u540d\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String synRstJson = Util.toJsonStr(synRst);
        Util.writeUtf8Text(response, synRstJson);
        return null;
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/queryMDPPersonRole.do"})
    public void queryMDPPersonRole(HttpServletRequest request, HttpServletResponse response, String[] personIds) {
        HashMap<String, ArrayList<MDPPersonRoleBean>> map = new HashMap<String, ArrayList<MDPPersonRoleBean>>();
        try {
            List<MDPPersonRoleBean> list = this.personMDPService.queryMDPPersonRole(personIds);
            for (MDPPersonRoleBean r : list) {
                ArrayList<MDPPersonRoleBean> v = (ArrayList<MDPPersonRoleBean>)map.get(r.getPersonId());
                if (v == null) {
                    v = new ArrayList<MDPPersonRoleBean>();
                    map.put(r.getPersonId(), v);
                }
                v.add(r);
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u7528\u6237\u89d2\u8272\u5931\u8d25", (Throwable)e2);
        }
        String synRstJson = Util.toJsonStr(map);
        Util.writeUtf8Text(response, synRstJson);
    }

    @RequestMapping(value={"sso/pamstomdpcontrol/queryMDPAndPoliceRole.do"})
    public void queryMDPAndPoliceRole(HttpServletRequest request, HttpServletResponse response, String personId) {
        List<MDPPersonRoleBean> list = null;
        try {
            list = this.personMDPService.queryMDPAndPoliceRole(personId);
            if (list == null) {
                list = new ArrayList<MDPPersonRoleBean>();
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u7528\u6237\u89d2\u8272\u5931\u8d25", (Throwable)e2);
        }
        String synRstJson = Util.toJsonStr(list);
        Util.writeUtf8Text(response, synRstJson);
    }

    @RequestMapping(value={"/pamstomdpcontrol/checkVerifyState.do"})
    public void checkVerifyState(String userName, String password, String personId, HttpServletResponse response) {
        ReturnResult result = new ReturnResult();
        try {
            if (StringUtils.isBlank((CharSequence)personId) && (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)password))) {
                result.setRtnCode("1");
                result.setRtnMsg("\u53c2\u6570\u9519\u8bef");
            } else {
                QueryParamPoliceAndMDP queryParam = new QueryParamPoliceAndMDP();
                if (StringUtils.isNotBlank((CharSequence)personId)) {
                    queryParam.setPersonId(personId);
                } else {
                    queryParam.setIdentifier(userName);
                    queryParam.setNewPassword(Md5PwdEncoder.getInstance().encodePassword(password));
                }
                queryParam.setIfDelete("0");
                MDPPerson mdpPeople = this.mdpPersonService.queryMdpPerson(queryParam);
                if (mdpPeople == null) {
                    result.setRtnCode("1");
                    result.setRtnMsg("\u672a\u67e5\u5230\u8be5\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u8eab\u4efd\u8bc1\u53f7\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e");
                } else {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    List<ThirdKey> thirdKeys = this.mdpCardService.queryByPersonId(mdpPeople.getId());
                    String cardState = "";
                    if (CollectionUtils.isEmpty(thirdKeys)) {
                        cardState = "2";
                    } else {
                        for (ThirdKey thirdKey : thirdKeys) {
                            if (!"0".equals(thirdKey.getState())) continue;
                            cardState = thirdKey.getState();
                            break;
                        }
                        if (StringUtils.isBlank((CharSequence)cardState)) {
                            cardState = "1";
                        }
                    }
                    result.setRtnCode("0");
                    resultMap.put("cardState", cardState);
                    resultMap.put("personId", mdpPeople.getId());
                    resultMap.put("verifyState", mdpPeople.getVerifyState());
                    result.setData(resultMap);
                }
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7528\u6237\u5ba1\u6838\u72b6\u6001\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            result.setRtnCode("1");
            result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr(result);
        Util.writeUtf8JSON(response, resultJson);
    }
}

