/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synthirdcomm.dao.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.synthirdcomm.bean.ThirdDepartmentBean;
import com.xdja.pams.synthirdcomm.bean.ThirdDeviceBean;
import com.xdja.pams.synthirdcomm.bean.ThirdPersonBean;
import java.sql.DatabaseMetaData;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class JitaDao {
    private static final Logger log = LoggerFactory.getLogger(JitaDao.class);
    @Autowired
    private JdbcTemplate jdbcTemplateJita;
    private static String DATEBASE_TYPE;
    private static final String DB_TYPE_MYSQL = "M";
    private static final String DB_TYPE_SQLSERVER = "SS";
    private static final String DB_TYPE_ORACLE = "O";

    public List<ThirdDepartmentBean> queryDepartment(String lastUpdateTime, int page) {
        long nLastUpdateTime = 0L;
        try {
            nLastUpdateTime = Long.parseLong(lastUpdateTime);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        this.getDBType();
        String startTime = Util.getDate("yyyy-MM-dd HH:mm:ss", new Date(nLastUpdateTime));
        int pageSize = 1000;
        BeanPropertyRowMapper rw = new BeanPropertyRowMapper(ThirdDepartmentBean.class);
        String sql = "";
        String baseSql = "select * from ( select  id as thirdId, name, code,  pcode as parentCode,  pid as thirdParentId, '0' as flag, " + this.getToDateFunction("createtime") + "  as lastUpdateTimeDate " + " from jbase_department " + " union " + " select " + " id as thirdId," + " name, " + " code, " + " '' as parentCode, " + " '' as thirdParentId, " + " '1' as flag, " + this.getToDateFunction("deletetime") + " as lastUpdateTimeDate " + " from jbase_department_delete " + ") t_dep " + "  where lastUpdateTimeDate>" + this.getToDateFunction("'" + startTime + "'");
        sql = this.pageSql(baseSql, page, pageSize, " order by lastUpdateTimeDate,thirdId asc ");
        log.debug("dep -> sql : {}", (Object)sql);
        List list = this.jdbcTemplateJita.query(sql, (RowMapper)rw);
        return list;
    }

    public List<ThirdPersonBean> queryPerson(String lastUpdateTime, int page) {
        long nLastUpdateTime = 0L;
        try {
            nLastUpdateTime = Long.parseLong(lastUpdateTime);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        this.getDBType();
        String startTime = Util.getDate("yyyy-MM-dd HH:mm:ss", new Date(nLastUpdateTime));
        int pageSize = 1000;
        int startNum = page * pageSize;
        BeanPropertyRowMapper rw = new BeanPropertyRowMapper(ThirdPersonBean.class);
        String baseSql = "select * from ( select  a.id as thirdId, a.name, b.col1 as code,  a.IDCARD as identifier,  a.depid, a.policeclass as police, a.position as position, a.telephone as officephone, a.mobile, a.sex, a.sort, '0' as flag, " + this.getToDateFunction("createtime") + " as lastUpdateTimeDate," + " (case when a.modelcode='jingyuan' then '1' when a.modelcode='jy' then '1' else '2'  end  ) as personType," + " (CASE when " + this.getIndexOfFunction("\u79fb\u52a8", "b.col2", null) + " >0 then '1' when " + this.getIndexOfFunction("\u8054\u901a", "b.col2", null) + ">0 then '2' when " + this.getIndexOfFunction("\u7535\u4fe1", "b.col2", null) + ">0 then '3' else '1' end ) as commType " + " from jbase_user a,jbase_userextattr b where a.id=b.userid " + " union " + "  select " + " id as thirdId," + " name," + " loginid as code, " + " IDCARD as identifier, " + " depid," + " policeclass as police," + " position as position," + " telephone as officephone," + " mobile," + " sex," + " sort," + " '1' as flag," + " " + this.getToDateFunction("deletetime") + " as lastUpdateTimeDate," + " (case when modelcode='jingyuan' then '1' when modelcode='jy' then '1' else '2'  end  ) as personType, " + " ''as commType " + " from jbase_user_delete " + ") t_person " + "  where lastUpdateTimeDate>" + this.getToDateFunction("'" + startTime + "'");
        String sql = this.pageSql(baseSql, page, pageSize, " order by lastUpdateTimeDate,thirdId asc");
        log.debug("person -> sql : {}", (Object)sql);
        List list = this.jdbcTemplateJita.query(sql, (RowMapper)rw);
        return list;
    }

    public List<ThirdDeviceBean> queryDevice(String lastUpdateTime, int page) {
        long nLastUpdateTime = 0L;
        try {
            nLastUpdateTime = Long.parseLong(lastUpdateTime);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        this.getDBType();
        String startTime = Util.getDate("yyyy-MM-dd HH:mm:ss", new Date(nLastUpdateTime));
        int pageSize = 1000;
        int startNum = page * pageSize;
        BeanPropertyRowMapper rw = new BeanPropertyRowMapper(ThirdDeviceBean.class);
        String baseSql = " select * from (  select  a.id as thirdId,  a.userid as personId, a.cardid cardNo,  a.RSASIGNCERTSN as snSignCertRSA, a.RSAENCCERTSN as snEncCertRSA, a.RSASIGNCERTENTITY as certentitySignRSA, a.RSAENCCERTENTITY as certentityEncRSA, a.SM2SIGNCERTSN as snSignCertSM2,  a.SM2ENCCERTSN as snEncCertSM2, a.SM2SIGNCERTENTITY as certentitySignSM2, a.SM2ENCCERTENTITY as certentityEncSM2,  (case when a.STATUS=0 then '3' when a.STATUS='1' then '4' else '1'  end  ) as flag, a.CERTTYPE as certType, " + this.getToDateFunction("a.updateTime") + " as lastUpdateTimeDate," + " (CASE when " + this.getIndexOfFunction("\u7b14\u8bb0\u672cTF\u5361", "upper(b.devicedrivename)", null) + " >0 then '5' when " + this.getIndexOfFunction("TF\u5361", "upper(b.devicedrivename)", null) + " >0 then '3'  when " + this.getIndexOfFunction("\u4fe1\u5927\u6377\u5b89", "upper(b.devicedrivename)", null) + " >0 then '3' when " + this.getIndexOfFunction("\u8d34\u819c\u5361", "upper(b.devicedrivename)", null) + " >0 then '3' when " + this.getIndexOfFunction("POS", "upper(b.devicedrivename)", null) + " >0 then '4' when " + this.getIndexOfFunction("USBKEY", "upper(b.devicedrivename)", null) + " >0 then '2' else '2' end ) as cardType " + " from jbase_wireless_certinfo a left join jbase_wireless_deviceinfo b on a.cardid=b.cardid " + " union " + "  select " + " id as thirdId, " + " userid as personId," + " cardid cardNo, " + " RSASIGNCERTSN as snSignCertRSA," + " RSAENCCERTSN as snEncCertRSA," + " RSASIGNCERTENTITY as certentitySignRSA," + " RSAENCCERTENTITY as certentityEncRSA," + " SM2SIGNCERTSN as snSignCertSM2, " + " SM2ENCCERTSN as snEncCertSM2," + " SM2SIGNCERTENTITY as certentitySignSM2," + " SM2ENCCERTENTITY as certentityEncSM2," + " '1' as flag," + " CERTTYPE as certType," + " " + this.getToDateFunction("deleteTime") + " as lastUpdateTimeDate," + " '' as cardType " + " from jbase_yd_certinfo_delete" + ") t_device  " + "  where lastUpdateTimeDate>" + this.getToDateFunction("'" + startTime + "'");
        String sql = this.pageSql(baseSql, page, pageSize, " order by lastUpdateTimeDate,thirdId asc");
        log.debug("device -> sql : {}", (Object)sql);
        List list = this.jdbcTemplateJita.query(sql, (RowMapper)rw);
        return list;
    }

    private String getToDateFunction(String fildeName) {
        String toDate = "";
        if (DB_TYPE_MYSQL.equals(DATEBASE_TYPE)) {
            toDate = " str_to_date(" + fildeName + ",'%Y-%m-%d %H:%i:%s') ";
        } else if (DB_TYPE_SQLSERVER.equals(DATEBASE_TYPE)) {
            toDate = " convert(varchar(19), " + fildeName + ", 20) ";
        } else if (DB_TYPE_ORACLE.equals(DATEBASE_TYPE)) {
            toDate = " to_date(" + fildeName + ",'yyyy-MM-dd HH24:mi:ss') ";
        }
        return toDate;
    }

    private String getIndexOfFunction(String expressionToFind, String expressionToSearch, Integer startLocation) {
        String startIndex;
        String indexOf = "";
        String string = startIndex = startLocation == null ? "" : "," + startLocation;
        if (DB_TYPE_MYSQL.equals(DATEBASE_TYPE)) {
            indexOf = " LOCATE('" + expressionToFind + "'," + expressionToSearch + " " + startIndex + ") ";
        } else if (DB_TYPE_SQLSERVER.equals(DATEBASE_TYPE)) {
            indexOf = " CHARINDEX('" + expressionToFind + "'," + expressionToSearch + " " + startIndex + ") ";
        } else if (DB_TYPE_ORACLE.equals(DATEBASE_TYPE)) {
            indexOf = " instr(" + expressionToSearch + ",'" + expressionToFind + "' " + startIndex + ") ";
        }
        return indexOf;
    }

    private String pageSql(String baseSql, int page, int pageSize, String orderBySql) {
        String pageSql = "";
        if (DB_TYPE_MYSQL.equals(DATEBASE_TYPE)) {
            int startNum = page * pageSize;
            pageSql = baseSql + " " + orderBySql + " LIMIT " + startNum + "," + pageSize;
        } else if (DB_TYPE_SQLSERVER.equals(DATEBASE_TYPE)) {
            int startNum = page * pageSize;
            int endNum = (page + 1) * pageSize;
            pageSql = "select * from (select ROW_NUMBER() OVER( " + orderBySql + " ) AS rowid, a.* from ( " + baseSql + " ) a) b where rowid > " + startNum + " and  rowid <=" + endNum;
        } else if (DB_TYPE_ORACLE.equals(DATEBASE_TYPE)) {
            int startNum = page * pageSize;
            int endNum = (page + 1) * pageSize + 1;
            pageSql = "select * from ( select a.*, a.rownum rn from (" + baseSql + " " + orderBySql + ") a where rownum < " + endNum + ") b where rn > " + startNum;
        }
        return pageSql;
    }

    private void getDBType() {
        if (Util.varCheckEmp(DATEBASE_TYPE)) {
            try {
                DatabaseMetaData md = this.jdbcTemplateJita.getDataSource().getConnection().getMetaData();
                String dbName = md.getDatabaseProductName();
                if (dbName.toUpperCase().contains("MYSQL")) {
                    DATEBASE_TYPE = DB_TYPE_MYSQL;
                }
                if (dbName.toUpperCase().contains("ORACLE")) {
                    DATEBASE_TYPE = DB_TYPE_ORACLE;
                }
                if (dbName.toUpperCase().contains("SQL SERVER")) {
                    DATEBASE_TYPE = DB_TYPE_SQLSERVER;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

