/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synthirdcomm.service.impl;

import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.synthirdcomm.bean.ThirdDepartmentBean;
import com.xdja.pams.synthirdcomm.bean.ThirdDeviceBean;
import com.xdja.pams.synthirdcomm.bean.ThirdPersonBean;
import com.xdja.pams.synthirdcomm.dao.SynDao;
import com.xdja.pams.synthirdcomm.dao.impl.JitaDao;
import com.xdja.pams.synthirdcomm.entity.ThirdDepartmentC;
import com.xdja.pams.synthirdcomm.entity.ThirdDeviceC;
import com.xdja.pams.synthirdcomm.entity.ThirdPersonC;
import com.xdja.pams.synthirdcomm.entity.ThirdSynRecordC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SynServiceImpl
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SynServiceImpl.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Autowired
    SynDao dao;
    @Autowired
    JitaDao jitaDao;
    @Autowired
    DepManageService depManageService;
    @Autowired
    UserManageService userManageService;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    private DevicePbService devicePdService;
    @Autowired
    DepartmentDao depDao;

    public void syn() {
        int depResult = 0;
        try {
            this.synDep();
        }
        catch (Exception e2) {
            log.error("\u5355\u4f4d\u540c\u6b65\u4e2d\u95f4\u8868\u5931\u8d25", (Throwable)e2);
        }
        try {
            this.synPerson();
        }
        catch (Exception e3) {
            log.error("\u4eba\u5458\u540c\u6b65\u4e2d\u95f4\u8868\u5931\u8d25", (Throwable)e3);
        }
        try {
            this.synDevice();
        }
        catch (Exception e4) {
            log.error("\u8bbe\u5907\u540c\u6b65\u4e2d\u95f4\u8868\u5931\u8d25", (Throwable)e4);
        }
        try {
            depResult = this.depRelation();
        }
        catch (Exception e5) {
            log.error("\u5355\u4f4d\u5173\u8054\u5931\u8d25", (Throwable)e5);
        }
        try {
            if (depResult > 0) {
                log.debug("\u672c\u6b21\u66f4\u65b0\u90e8\u95e8\u6570\u91cf:" + depResult + ",\u5f00\u59cb\u8bbe\u7f6e\u90e8\u95e8\u7b49\u7ea7");
                this.setLevels();
            }
        }
        catch (Exception e6) {
            log.error("\u4fee\u6539\u7b49\u7ea7\u5931\u8d25", (Throwable)e6);
        }
        try {
            this.personRelation();
        }
        catch (Exception e7) {
            log.error("\u7528\u6237\u5173\u8054\u5931\u8d25", (Throwable)e7);
        }
        try {
            this.deviceRelation();
        }
        catch (Exception e8) {
            log.error("\u8bbe\u5907\u5173\u8054\u5931\u8d25", (Throwable)e8);
        }
    }

    public void synDep() {
        ThirdSynRecordC lastSynRecord = this.dao.getLastSynRecord("dep");
        String lastUpdateTime = "0";
        String lastUpdateTimeThird = "0";
        if (lastSynRecord != null) {
            lastUpdateTimeThird = lastUpdateTime = lastSynRecord.getLastUpdateTime();
        }
        log.debug("\u5f00\u59cb\u540c\u6b65\u5355\u4f4d\u5230\u4e2d\u95f4\u8868\uff0c\u5206\u9875\u540c\u6b65\uff0c\u6bcf\u98751000\u6761");
        int count = 0;
        int i = 0;
        while (true) {
            List<ThirdDepartmentBean> list;
            if ((list = this.jitaDao.queryDepartment(lastUpdateTime, i)) == null || list.size() < 1) break;
            log.debug("\u5355\u4f4d\u540c\u6b65\uff1a\u7b2c{}\u9875\uff0c\u672c\u9875{}\u6761\uff0c\u5171\u8ba1" + (count += list.size()), (Object)(i + ""), (Object)(list.size() + ""));
            lastUpdateTimeThird = this.synDepDataHandle(list);
            ++i;
        }
        log.debug("\u5355\u4f4d\u540c\u6b65\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e");
        ThirdSynRecordC lastSynRecordNew = new ThirdSynRecordC();
        lastSynRecordNew.setCreateDate(new Date());
        lastSynRecordNew.setType("dep");
        lastSynRecordNew.setLastUpdateTime(lastUpdateTimeThird);
        this.dao.saveThirdSynRecord(lastSynRecordNew);
    }

    public void synPerson() {
        ThirdSynRecordC lastSynRecord = this.dao.getLastSynRecord("person");
        String lastUpdateTime = "0";
        String lastUpdateTimeThird = "0";
        if (lastSynRecord != null) {
            lastUpdateTimeThird = lastUpdateTime = lastSynRecord.getLastUpdateTime();
        }
        int count = 0;
        log.debug("\u5f00\u59cb\u540c\u6b65\u4eba\u5458\u5230\u4e2d\u95f4\u8868\uff0c\u5206\u9875\u540c\u6b65\uff0c\u6bcf\u98751000\u6761");
        int i = 0;
        while (true) {
            List<ThirdPersonBean> list;
            if ((list = this.jitaDao.queryPerson(lastUpdateTime, i)) == null || list.size() < 1) break;
            log.debug("\u4eba\u5458\u540c\u6b65\uff1a\u7b2c{}\u9875\uff0c\u672c\u9875{}\u6761\uff0c\u5171\u8ba1" + (count += list.size()), (Object)(i + ""), (Object)(list.size() + ""));
            lastUpdateTimeThird = this.synPersonHandle(list);
            ++i;
        }
        log.debug("\u4eba\u5458\u540c\u6b65\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e");
        ThirdSynRecordC lastSynRecordNew = new ThirdSynRecordC();
        lastSynRecordNew.setCreateDate(new Date());
        lastSynRecordNew.setType("person");
        lastSynRecordNew.setLastUpdateTime(lastUpdateTimeThird);
        this.dao.saveThirdSynRecord(lastSynRecordNew);
    }

    public void synDevice() {
        ThirdSynRecordC lastSynRecord = this.dao.getLastSynRecord("device");
        String lastUpdateTime = "0";
        String lastUpdateTimeThird = "0";
        if (lastSynRecord != null) {
            lastUpdateTimeThird = lastUpdateTime = lastSynRecord.getLastUpdateTime();
        }
        int count = 0;
        log.debug("\u5f00\u59cb\u540c\u6b65\u8bbe\u5907\u5230\u4e2d\u95f4\u8868\uff0c\u5206\u9875\u540c\u6b65\uff0c\u6bcf\u98751000\u6761");
        int i = 0;
        while (true) {
            List<ThirdDeviceBean> list;
            if ((list = this.jitaDao.queryDevice(lastUpdateTime, i)) == null || list.size() < 1) break;
            log.debug("\u8bbe\u5907\u540c\u6b65\uff1a\u7b2c{}\u9875\uff0c\u672c\u9875{}\u6761\uff0c\u5171\u8ba1" + (count += list.size()), (Object)(i + ""), (Object)(list.size() + ""));
            lastUpdateTimeThird = this.synDeviceHandle(list);
            ++i;
        }
        log.debug("\u8bbe\u5907\u540c\u6b65\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e");
        ThirdSynRecordC lastSynRecordNew = new ThirdSynRecordC();
        lastSynRecordNew.setCreateDate(new Date());
        lastSynRecordNew.setType("device");
        lastSynRecordNew.setLastUpdateTime(lastUpdateTimeThird);
        this.dao.saveThirdSynRecord(lastSynRecordNew);
    }

    private String synPersonHandle(List<ThirdPersonBean> list) {
        String lastUpdateTime = "0";
        for (ThirdPersonBean personBean : list) {
            try {
                if (StringUtils.isBlank((CharSequence)personBean.getThirdId())) continue;
                lastUpdateTime = personBean.getLastUpdateTimeDate() != null ? Long.toString(personBean.getLastUpdateTimeDate().getTime()) : personBean.getLastUpdateTimeStamp();
                ThirdPersonC thirdPerson = this.dao.getThirdPersonByThirdId(personBean.getThirdId());
                if (thirdPerson == null) {
                    thirdPerson = new ThirdPersonC();
                    BeanUtils.copyProperties((Object)personBean, (Object)thirdPerson);
                    thirdPerson.setTimestamp(lastUpdateTime);
                    this.dao.saveThirdPerson(thirdPerson);
                    continue;
                }
                thirdPerson.setIdentifier(personBean.getIdentifier());
                thirdPerson.setSex(personBean.getSex());
                thirdPerson.setPolice(personBean.getPolice());
                thirdPerson.setPosition(personBean.getPosition());
                thirdPerson.setOfficePhone(personBean.getOfficePhone());
                thirdPerson.setSort(personBean.getSort());
                thirdPerson.setCode(personBean.getCode());
                thirdPerson.setMobile(personBean.getMobile());
                thirdPerson.setDepId(personBean.getDepId());
                thirdPerson.setName(personBean.getName());
                thirdPerson.setFlag(personBean.getFlag());
                thirdPerson.setPersonId("");
                thirdPerson.setErrInfo("");
                thirdPerson.setTimestamp(lastUpdateTime);
                thirdPerson.setPersonType(personBean.getPersonType());
                thirdPerson.setCommType(personBean.getCommType());
                this.dao.updateThirdPerson(thirdPerson);
            }
            catch (BeansException e2) {
                log.error("\u540c\u6b65\u4eba\u5458\u3010" + personBean.getThirdId() + "\u3011\u5230\u4e2d\u95f4\u8868\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            }
        }
        return lastUpdateTime;
    }

    public void personRelation() {
        List<ThirdPersonC> unRelationThirdPerson = this.dao.getUnRelationThirdPerson();
        log.debug("\u5171\u6709" + unRelationThirdPerson.size() + "\u6761\u7b2c\u4e09\u65b9\u4eba\u5458\u672a\u5173\u8054\u6570\u636e");
        for (ThirdPersonC thirdPerson : unRelationThirdPerson) {
            try {
                Mobile mobileE;
                List<Mobile> mobiledList;
                Person person = this.userManageService.getUserByIdentifer(thirdPerson.getIdentifier());
                if ("1".equals(thirdPerson.getFlag())) {
                    if (person == null) {
                        thirdPerson.setPersonId("delete");
                        this.dao.updateThirdPerson(thirdPerson);
                        continue;
                    }
                    this.userManageService.delete(person.getId());
                    continue;
                }
                if (person == null) {
                    person = new Person();
                    person.setCommType(thirdPerson.getCommType());
                    person.setPersonType(thirdPerson.getPersonType());
                    person.setIdentifier(thirdPerson.getIdentifier());
                    if (thirdPerson.getCode() == null || thirdPerson.getCode().length() < 1) {
                        person.setCode(thirdPerson.getIdentifier());
                    } else {
                        person.setCode(thirdPerson.getCode());
                    }
                    person.setOfficePhone(thirdPerson.getOfficePhone());
                    person.setDepartment(this.getPeronDep(thirdPerson.getDepId()));
                    person.setName(thirdPerson.getName());
                    if (thirdPerson.getPersonType() != null && thirdPerson.getPersonType().length() <= 2) {
                        person.setPersonType(thirdPerson.getPersonType());
                    } else {
                        person.setPersonType("1");
                    }
                    if (thirdPerson.getCommType() != null && thirdPerson.getCommType().length() <= 1) {
                        person.setCommType(thirdPerson.getCommType());
                    } else {
                        person.setCommType("1");
                    }
                    if (thirdPerson.getPosition() != null && thirdPerson.getPosition().length() <= 4) {
                        person.setPosition(thirdPerson.getPosition());
                    } else {
                        person.setPosition("0");
                    }
                    if (thirdPerson.getPolice() != null && thirdPerson.getPolice().length() <= 4) {
                        person.setPolice(thirdPerson.getPolice());
                    } else {
                        person.setPolice("0");
                    }
                    if (thirdPerson.getSex() != null && thirdPerson.getSex().length() <= 2) {
                        person.setSex(thirdPerson.getSex());
                    } else {
                        person.setSex("0");
                    }
                    String mobile = thirdPerson.getMobile();
                    if (mobile == null || mobile.length() < 1) {
                        mobile = person.getCode() != null && person.getCode().length() <= 11 ? "13000000000".substring(0, 11 - person.getCode().length()) + person.getCode() : "13000000000";
                    }
                    mobiledList = new ArrayList<Mobile>();
                    mobileE = new Mobile();
                    mobileE.setMobile(mobile);
                    mobileE.setPerson(person);
                    mobiledList.add(mobileE);
                    person.setMobile(mobile);
                    person.setMobiledList(mobiledList);
                    person.setCreatorId("0");
                    this.userManageService.addUser(person);
                    thirdPerson.setPersonId(person.getId());
                } else {
                    person.setCommType(thirdPerson.getCommType());
                    person.setPersonType(thirdPerson.getPersonType());
                    person.setIdentifier(thirdPerson.getIdentifier());
                    if (thirdPerson.getCode() == null || thirdPerson.getCode().length() < 1) {
                        person.setCode(thirdPerson.getIdentifier());
                    } else {
                        person.setCode(thirdPerson.getCode());
                    }
                    person.setOfficePhone(thirdPerson.getOfficePhone());
                    person.setDepartment(this.getPeronDep(thirdPerson.getDepId()));
                    person.setName(thirdPerson.getName());
                    if (thirdPerson.getPersonType() != null && thirdPerson.getPersonType().length() <= 2) {
                        person.setPersonType(thirdPerson.getPersonType());
                    } else {
                        person.setPersonType("1");
                    }
                    if (thirdPerson.getCommType() != null && thirdPerson.getCommType().length() <= 1) {
                        person.setCommType(thirdPerson.getCommType());
                    } else {
                        person.setCommType("1");
                    }
                    if (thirdPerson.getPosition() != null && thirdPerson.getPosition().length() <= 4) {
                        person.setPosition(thirdPerson.getPosition());
                    } else {
                        person.setPosition("0");
                    }
                    if (thirdPerson.getPolice() != null && thirdPerson.getPolice().length() <= 4) {
                        person.setPolice(thirdPerson.getPolice());
                    } else {
                        person.setPolice("0");
                    }
                    if (thirdPerson.getSex() != null && thirdPerson.getSex().length() <= 2) {
                        person.setSex(thirdPerson.getSex());
                    } else {
                        person.setSex("0");
                    }
                    String mobileStr = thirdPerson.getMobile();
                    if (mobileStr == null || mobileStr.length() < 1) {
                        mobileStr = person.getCode() != null && person.getCode().length() <= 11 ? "13000000000".substring(0, 11 - person.getCode().length()) + person.getCode() : "13000000000";
                    }
                    if ((mobiledList = person.getMobiledList()) == null) {
                        mobiledList = new ArrayList<Mobile>();
                        person.setMobiledList(mobiledList);
                    }
                    if (mobiledList.isEmpty()) {
                        mobileE = new Mobile();
                        mobileE.setMobile(mobileStr);
                        mobileE.setPerson(person);
                        mobiledList.add(mobileE);
                    } else {
                        Mobile mobile = mobiledList.get(0);
                        mobile.setMobile(mobileStr);
                    }
                    person.setMobile(mobileStr);
                    person.setCreatorId("0");
                    this.userManageService.updateUser(person);
                    thirdPerson.setPersonId(person.getId());
                }
            }
            catch (Exception e2) {
                log.error("\u7b2c\u4e09\u65b9\u7528\u6237\u3010" + thirdPerson.getId() + "\u3011\u5173\u8054\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
                thirdPerson.setPersonId("error");
                thirdPerson.setErrInfo(e2.getMessage());
            }
            this.dao.updateThirdPerson(thirdPerson);
        }
    }

    private Department getPeronDep(String thirdId) {
        ThirdDepartmentC thirdDep = this.dao.getThirdDepByThirdId(thirdId);
        return this.depManageService.queryDepById(thirdDep.getDepId());
    }

    private String synDepDataHandle(List<ThirdDepartmentBean> list) {
        String lastUpdateTime = "0";
        for (ThirdDepartmentBean depBean : list) {
            if (StringUtils.isBlank((CharSequence)depBean.getThirdId())) continue;
            try {
                lastUpdateTime = depBean.getLastUpdateTimeDate() != null ? Long.toString(depBean.getLastUpdateTimeDate().getTime()) : depBean.getLastUpdateTimeStamp();
                ThirdDepartmentC thirdDep = this.dao.getThirdDepByThirdId(depBean.getThirdId());
                if (thirdDep == null) {
                    thirdDep = new ThirdDepartmentC();
                    BeanUtils.copyProperties((Object)depBean, (Object)thirdDep);
                    thirdDep.setTimestamp(lastUpdateTime);
                    this.dao.saveThirdDepartment(thirdDep);
                    continue;
                }
                thirdDep.setCode(depBean.getCode());
                thirdDep.setName(depBean.getName());
                thirdDep.setShortName(depBean.getShortName());
                thirdDep.setParentCode(depBean.getParentCode());
                thirdDep.setThirdParentId(depBean.getThirdParentId());
                thirdDep.setDepId("");
                thirdDep.setErrInfo("");
                thirdDep.setFlag(depBean.getFlag());
                thirdDep.setTimestamp(lastUpdateTime);
                this.dao.updateThirdDepartment(thirdDep);
            }
            catch (BeansException e2) {
                log.error("\u540c\u6b65\u5355\u4f4d\u3010" + depBean.getThirdId() + "\u3011\u5230\u4e2d\u95f4\u8868\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            }
        }
        return lastUpdateTime;
    }

    public int depRelation() {
        int result = 0;
        List<ThirdDepartmentC> unRelationThirdDep = this.dao.getUnRelationThirdDep();
        log.debug("\u5171\u6709" + unRelationThirdDep.size() + "\u6761\u7b2c\u4e09\u65b9\u90e8\u95e8\u672a\u5173\u8054\u6570\u636e");
        for (ThirdDepartmentC thirdDep : unRelationThirdDep) {
            try {
                Department department;
                Department dep = this.depManageService.getDepartmentByCode(thirdDep.getCode());
                if ("1".equals(thirdDep.getFlag())) {
                    if (dep != null && !"8888888888".equals(dep.getId())) {
                        this.depManageService.deleteDepById(dep.getId());
                        ++result;
                        continue;
                    }
                    thirdDep.setDepId("delete");
                    this.dao.updateThirdDepartment(thirdDep);
                    continue;
                }
                if (dep == null) {
                    dep = new Department();
                    dep.setCode(thirdDep.getCode());
                    dep.setName(thirdDep.getName());
                    department = this.getParentDep(thirdDep.getThirdParentId(), thirdDep.getParentCode());
                    dep.setParentDep(department);
                    dep.setLevel(Integer.parseInt(dep.getParentDep().getLevel()) + 1 + "");
                    String depId = this.depManageService.addDept(dep);
                    thirdDep.setDepId(depId);
                } else {
                    dep.setName(thirdDep.getName());
                    dep.setNameAbbr(thirdDep.getShortName());
                    if (!"8888888888".equals(dep.getId())) {
                        department = this.getParentDep(thirdDep.getThirdParentId(), thirdDep.getParentCode());
                        dep.setParentDep(department);
                        dep.setLevel(Integer.parseInt(dep.getParentDep().getLevel()) + 1 + "");
                        this.depManageService.updateSingleDep(dep, false);
                    } else {
                        this.depManageService.updateSingleDep(dep, false);
                    }
                    thirdDep.setDepId(dep.getId());
                }
                ++result;
            }
            catch (Exception e2) {
                thirdDep.setDepId("error");
                thirdDep.setErrInfo(e2.getMessage());
                log.error("\u5173\u8054\u5355\u4f4d\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            }
            this.dao.updateThirdDepartment(thirdDep);
        }
        return result;
    }

    public void setLevels() {
        Department root = this.depManageService.queryDepById("8888888888");
        ArrayList<Department> rootList = new ArrayList<Department>();
        rootList.add(root);
        this.setLevel(rootList);
    }

    private void setLevel(List<Department> list) {
        for (Department department : list) {
            List<Department> childDepList;
            Department parentDep;
            int level = StringUtils.isBlank((CharSequence)department.getParentID()) ? 1 : ((parentDep = this.depManageService.queryDepById(department.getParentID())) == null ? 1 : Integer.parseInt(parentDep.getLevel()) + 1);
            if (StringUtils.isBlank((CharSequence)department.getLevel()) || !department.getLevel().equals(level + "")) {
                department.setLevel(level + "");
                this.depManageService.updateDepLevel(department);
            }
            if (CollectionUtils.isEmpty(childDepList = this.depManageService.queryChildDepListByParentId(department.getId()))) continue;
            this.setLevel(childDepList);
        }
    }

    private Department getParentDep(String parentId, String parentCode) {
        Department dep = null;
        ThirdDepartmentC thirdDep = null;
        if (parentId != null && parentId.length() > 0) {
            thirdDep = this.dao.getThirdDepByThirdId(parentId);
        }
        if (thirdDep == null && parentCode != null && parentCode.length() > 0) {
            thirdDep = this.dao.getThirdDepByThirdCode(parentCode);
        }
        if (thirdDep == null) {
            return this.getNotParentDep();
        }
        if (thirdDep.getId().equals(parentId)) {
            return this.getNotParentDep();
        }
        if ("1".equals(thirdDep.getFlag())) {
            return this.getNotParentDep();
        }
        if (StringUtils.isNotBlank((CharSequence)thirdDep.getDepId())) {
            dep = this.depManageService.queryDepById(thirdDep.getDepId());
            if ("1".equals(dep.getFlag())) {
                return this.getNotParentDep();
            }
            return dep;
        }
        dep = this.depManageService.getDepartmentByCode(thirdDep.getCode());
        if (dep == null) {
            dep = new Department();
            dep.setCode(thirdDep.getCode());
            dep.setName(thirdDep.getName());
            dep.setNameAbbr(thirdDep.getShortName());
            int level = 1;
            if (dep.getParentDep() != null) {
                level = Integer.parseInt(dep.getParentDep().getLevel()) + 1;
            }
            dep.setLevel(level + "");
            if (!"8888888888".equals(dep.getId())) {
                Department department = this.getParentDep(thirdDep.getThirdParentId(), thirdDep.getParentCode());
                dep.setParentDep(department);
            }
            this.depManageService.addDept(dep);
        } else {
            dep.setCode(thirdDep.getCode());
            dep.setName(thirdDep.getName());
            dep.setNameAbbr(thirdDep.getShortName());
            int level = 1;
            if (dep.getParentDep() != null) {
                level = Integer.parseInt(dep.getParentDep().getLevel()) + 1;
            }
            dep.setLevel(level + "");
            if (!"8888888888".equals(dep.getId())) {
                Department department = this.getParentDep(thirdDep.getThirdParentId(), thirdDep.getParentCode());
                dep.setParentDep(department);
                this.depManageService.updateSingleDep(dep, false);
            } else {
                this.depManageService.updateSingleDep(dep, false);
            }
        }
        thirdDep.setDepId(dep.getId());
        this.dao.updateThirdDepartment(thirdDep);
        return dep;
    }

    private Department getNotParentDep() {
        String code = "999999999990";
        Department dep = this.depManageService.getDepartmentByCode(code);
        if (dep == null) {
            dep = new Department();
            dep.setCode(code);
            dep.setName("\u65e0\u4e0a\u7ea7\u5355\u4f4d\u6570\u636e");
            dep.setParentDep(this.depManageService.queryDepById("8888888888"));
            dep.setLevel("2");
            dep.setOrderField(999L);
            this.depManageService.addDep(dep);
        }
        return dep;
    }

    private String synDeviceHandle(List<ThirdDeviceBean> list) {
        String lastUpdateTime = "0";
        for (ThirdDeviceBean deviceBean : list) {
            try {
                if (StringUtils.isBlank((CharSequence)deviceBean.getThirdId())) continue;
                lastUpdateTime = deviceBean.getLastUpdateTimeDate() != null ? Long.toString(deviceBean.getLastUpdateTimeDate().getTime()) : deviceBean.getLastUpdateTimeStamp();
                ThirdDeviceC thirdDevice = this.dao.getThirdDeviceByThirdId(deviceBean.getThirdId());
                if (thirdDevice == null) {
                    thirdDevice = new ThirdDeviceC();
                    BeanUtils.copyProperties((Object)deviceBean, (Object)thirdDevice);
                    thirdDevice.setTimestamp(lastUpdateTime);
                    this.dao.saveThirdDevice(thirdDevice);
                    continue;
                }
                String deviceIdOrg = thirdDevice.getDeviceId();
                thirdDevice.setDeviceIdOrg(deviceIdOrg);
                thirdDevice.setCardNo(deviceBean.getCardNo());
                thirdDevice.setCertentityEncRSA(deviceBean.getCertentityEncRSA());
                thirdDevice.setCertentityEncSM2(deviceBean.getCertentityEncSM2());
                thirdDevice.setCertentitySignRSA(deviceBean.getCertentitySignRSA());
                thirdDevice.setCertentitySignSM2(deviceBean.getCertentitySignSM2());
                thirdDevice.setCertType(deviceBean.getCertType());
                thirdDevice.setDeviceId("");
                thirdDevice.setCardType(deviceBean.getCardType());
                thirdDevice.setErrInfo("");
                thirdDevice.setPersonId(deviceBean.getPersonId());
                thirdDevice.setSnEncCertRSA(deviceBean.getSnEncCertRSA());
                thirdDevice.setSnEncCertSM2(deviceBean.getSnEncCertSM2());
                thirdDevice.setSnSignCertRSA(deviceBean.getSnSignCertRSA());
                thirdDevice.setSnSignCertSM2(deviceBean.getSnSignCertSM2());
                thirdDevice.setFlag(deviceBean.getFlag());
                thirdDevice.setThirdId(deviceBean.getThirdId());
                thirdDevice.setTimestamp(lastUpdateTime);
                this.dao.updateThirdDevice(thirdDevice);
            }
            catch (BeansException e2) {
                log.error("\u540c\u6b65\u8bbe\u5907\u3010" + deviceBean.getThirdId() + "\u3011\u5230\u4e2d\u95f4\u8868\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            }
        }
        return lastUpdateTime;
    }

    public void deviceRelation() {
        List<ThirdDeviceC> unRelationThirdDep = this.dao.getUnRelationThirdDevice();
        for (ThirdDeviceC thirdDevice : unRelationThirdDep) {
            try {
                String certificate;
                String sn;
                List<Mobile> mobiles;
                Person person;
                ThirdPersonC thirdPerson;
                Device device;
                String cardNo = thirdDevice.getCardNo();
                if (StringUtils.isBlank((CharSequence)cardNo)) {
                    String deviceId = thirdDevice.getDeviceIdOrg();
                    if (!StringUtils.isBlank((CharSequence)deviceId) && "1".equals(thirdDevice.getFlag())) {
                        Device deviceHaveRevoked = this.deviceService.get((Serializable)((Object)deviceId));
                        String hardNo = deviceHaveRevoked.getHardNo();
                        deviceHaveRevoked.setIccid("");
                        deviceHaveRevoked.setHardNo("");
                        deviceHaveRevoked.setImei("");
                        deviceHaveRevoked.setImsi("");
                        deviceHaveRevoked.setSn("");
                        deviceHaveRevoked.setCertificate("");
                        deviceHaveRevoked.setMobile(null);
                        deviceHaveRevoked.setState("11");
                        deviceHaveRevoked.setRevokeFlag("1");
                        deviceHaveRevoked.setRevocationDate(new Date());
                        deviceHaveRevoked.setOriginalHardNo(hardNo);
                        this.deviceService.update(deviceHaveRevoked);
                        thirdDevice.setDeviceId(deviceId);
                    } else {
                        thirdDevice.setErrInfo("card no can not be null");
                        thirdDevice.setDeviceId("error-nocardno");
                    }
                    this.dao.updateThirdDevice(thirdDevice);
                    continue;
                }
                if (cardNo.length() < 32 && (cardNo = cardNo.startsWith("1500") ? "AC485010" + cardNo : (cardNo.toUpperCase().startsWith("000A") ? "140C0311" + cardNo : "78646A61" + cardNo)).length() > 32) {
                    cardNo = cardNo.substring(0, 32).toUpperCase();
                }
                if ((device = this.deviceService.getByCardNO(cardNo)) == null) {
                    device = this.deviceService.getByCardNO(thirdDevice.getCardNo());
                }
                if ("1".equals(thirdDevice.getFlag())) {
                    if (device != null) {
                        device.setIccid("");
                        device.setHardNo("");
                        device.setImei("");
                        device.setImsi("");
                        device.setSn("");
                        device.setCertificate("");
                        device.setMobile(null);
                        device.setState("11");
                        device.setRevokeFlag("1");
                        device.setRevocationDate(new Date());
                        this.deviceService.update(device);
                        continue;
                    }
                    thirdDevice.setDeviceId("delete");
                    this.dao.updateThirdDevice(thirdDevice);
                    continue;
                }
                if (device == null) {
                    device = new Device();
                    device.setHardNo(cardNo);
                    device.setIccid(cardNo);
                    device.setState(thirdDevice.getFlag());
                    thirdPerson = this.dao.getThirdPersonByThirdId(thirdDevice.getPersonId());
                    if (thirdPerson == null || thirdPerson.getPersonId() == null || "delete".equals(thirdPerson.getPersonId())) {
                        thirdDevice.setErrInfo("third person is is not exist or deleted");
                        thirdDevice.setDeviceId("error-nothirdperson");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    person = this.userManageService.queryPersonById(thirdPerson.getPersonId());
                    if (person == null) {
                        thirdDevice.setErrInfo("pams person is is not exist or deleted");
                        thirdDevice.setDeviceId("error-nopamsperson");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    device.setPersonId(person.getId());
                    mobiles = person.getMobiledList();
                    if (mobiles == null || mobiles.size() < 1) {
                        thirdDevice.setErrInfo("mobile can not be null");
                        thirdDevice.setDeviceId("error-nomobile");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    device.setMobile(mobiles.get(0));
                    sn = "";
                    certificate = "";
                    if (thirdDevice.getSnEncCertSM2() != null && thirdDevice.getSnEncCertSM2().length() > 0) {
                        sn = thirdDevice.getSnEncCertSM2();
                    } else if (thirdDevice.getSnSignCertSM2() != null && thirdDevice.getSnSignCertSM2().length() > 0) {
                        sn = thirdDevice.getSnSignCertSM2();
                    } else if (thirdDevice.getSnEncCertRSA() != null && thirdDevice.getSnEncCertRSA().length() > 0) {
                        sn = thirdDevice.getSnEncCertRSA();
                    } else if (thirdDevice.getSnSignCertRSA() != null && thirdDevice.getSnSignCertRSA().length() > 0) {
                        sn = thirdDevice.getSnSignCertRSA();
                    }
                    if (thirdDevice.getCertentityEncSM2() != null && thirdDevice.getCertentityEncSM2().length() > 0) {
                        certificate = thirdDevice.getCertentityEncSM2();
                    } else if (thirdDevice.getCertentitySignSM2() != null && thirdDevice.getCertentitySignSM2().length() > 0) {
                        certificate = thirdDevice.getCertentitySignSM2();
                    } else if (thirdDevice.getCertentityEncRSA() != null && thirdDevice.getCertentityEncRSA().length() > 0) {
                        certificate = thirdDevice.getCertentityEncRSA();
                    } else if (thirdDevice.getCertentitySignRSA() != null && thirdDevice.getCertentitySignRSA().length() > 0) {
                        certificate = thirdDevice.getCertentitySignRSA();
                    }
                    device.setType(thirdDevice.getCardType());
                    device.setSn(sn);
                    device.setCertificate(certificate);
                    device.setWriteCardDate(new Date());
                    if ("5".equals(thirdDevice.getCardType())) {
                        device.setType("3");
                    }
                    if ("3".equals(thirdDevice.getCardType()) || "4".equals(thirdDevice.getCardType())) {
                        device.setUseType("0");
                    } else if ("2".equals(thirdDevice.getCardType()) || "5".equals(thirdDevice.getCardType())) {
                        device.setUseType("1");
                    }
                    Terminal terminal = new Terminal();
                    terminal.setTerminalband("0");
                    terminal.setTerminalname("0");
                    terminal.setTerminalos("0");
                    terminal.setTerminaltype("1");
                    device.setTerminal(terminal);
                    this.deviceService.save(device);
                    thirdDevice.setDeviceId(device.getId());
                } else {
                    device.setHardNo(cardNo);
                    device.setIccid(cardNo);
                    device.setState(thirdDevice.getFlag());
                    device.setType(thirdDevice.getCardType());
                    thirdPerson = this.dao.getThirdPersonByThirdId(thirdDevice.getPersonId());
                    if (thirdPerson == null || thirdPerson.getPersonId() == null || "delete".equals(thirdPerson.getPersonId())) {
                        thirdDevice.setErrInfo("third person is is not exist or deleted");
                        thirdDevice.setDeviceId("error-nothirdperson");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    person = this.userManageService.queryPersonById(thirdPerson.getPersonId());
                    if (person == null) {
                        thirdDevice.setErrInfo("pams person is is not exist or deleted");
                        thirdDevice.setDeviceId("error-nopamsperson");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    device.setPersonId(person.getId());
                    mobiles = person.getMobiledList();
                    if (mobiles == null || mobiles.size() < 1) {
                        thirdDevice.setErrInfo("mobile can not be null");
                        thirdDevice.setDeviceId("error-nomobile");
                        this.dao.updateThirdDevice(thirdDevice);
                        continue;
                    }
                    device.setMobile(mobiles.get(0));
                    device.setRevokeFlag("");
                    sn = "";
                    certificate = "";
                    if (thirdDevice.getSnEncCertSM2() != null && thirdDevice.getSnEncCertSM2().length() > 0) {
                        sn = thirdDevice.getSnEncCertSM2();
                    } else if (thirdDevice.getSnSignCertSM2() != null && thirdDevice.getSnSignCertSM2().length() > 0) {
                        sn = thirdDevice.getSnSignCertSM2();
                    } else if (thirdDevice.getSnEncCertRSA() != null && thirdDevice.getSnEncCertRSA().length() > 0) {
                        sn = thirdDevice.getSnEncCertRSA();
                    } else if (thirdDevice.getSnSignCertRSA() != null && thirdDevice.getSnSignCertRSA().length() > 0) {
                        sn = thirdDevice.getSnSignCertRSA();
                    }
                    if (thirdDevice.getCertentityEncSM2() != null && thirdDevice.getCertentityEncSM2().length() > 0) {
                        certificate = thirdDevice.getCertentityEncSM2();
                    } else if (thirdDevice.getCertentitySignSM2() != null && thirdDevice.getCertentitySignSM2().length() > 0) {
                        certificate = thirdDevice.getCertentitySignSM2();
                    } else if (thirdDevice.getCertentityEncRSA() != null && thirdDevice.getCertentityEncRSA().length() > 0) {
                        certificate = thirdDevice.getCertentityEncRSA();
                    } else if (thirdDevice.getCertentitySignRSA() != null && thirdDevice.getCertentitySignRSA().length() > 0) {
                        certificate = thirdDevice.getCertentitySignRSA();
                    }
                    device.setSn(sn);
                    device.setCertificate(certificate);
                    device.setWriteCardDate(new Date());
                    if ("3".equals(thirdDevice.getCardType()) || "4".equals(thirdDevice.getCardType())) {
                        device.setUseType("0");
                    } else if ("2".equals(thirdDevice.getCardType())) {
                        device.setUseType("1");
                    }
                    this.deviceService.update(device);
                    thirdDevice.setDeviceId(device.getId());
                }
            }
            catch (Exception e2) {
                log.error("\u5173\u8054\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
                thirdDevice.setDeviceId("error");
                thirdDevice.setErrInfo(e2.getMessage());
            }
            this.dao.updateThirdDevice(thirdDevice);
        }
    }

    public void destroy() throws Exception {
        this.executorService.shutdownNow();
    }

    public void afterPropertiesSet() throws Exception {
        String startFlag = this.systemConfigService.getValueByCode("SYN_THIRD_START_FLAG");
        if (!"0".equals(startFlag)) {
            return;
        }
        log.debug("\u542f\u52a8\u7b2c\u4e09\u65b9\u6570\u636e\u540c\u6b65============");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    SynServiceImpl.this.syn();
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
    }

    public static void main(String[] args) {
    }
}

