/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.control;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.tims.bean.QueryFeedBackBean;
import com.xdja.pams.tims.entity.FeedBack;
import com.xdja.pams.tims.service.FeedBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class FeedBackController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(FeedBackController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private FeedBackService feedBackService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @RequestMapping(value={"/tims/feedbackcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = "tims/feedback/default/index";
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/tims/feedbackcontroller/query.do"})
    public void query(QueryFeedBackBean queryBean, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        log.info(Util.toJsonStr(queryBean));
        ArrayList listmap = new ArrayList();
        Page page = new Page(pageParam.getPage(), pageParam.getRows());
        try {
            List<QueryFeedBackBean> list = this.feedBackService.query(queryBean, page);
            for (FeedBack feedBack : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", feedBack.getId());
                map.put("yjlx", this.commonCodePbService.getCodeNameByCode(feedBack.getYjlx(), "2051"));
                map.put("gnmk", this.commonCodePbService.getCodeNameByCode(feedBack.getGnmk(), "2050"));
                map.put("title", feedBack.getTitle());
                map.put("content", feedBack.getContent());
                map.put("clbz", feedBack.getClbz());
                String clbzmx = "";
                if ("1".equals(feedBack.getClbz())) {
                    clbzmx = "\u672a\u5904\u7406";
                } else if ("2".equals(feedBack.getClbz())) {
                    clbzmx = "\u5df2\u5904\u7406";
                }
                map.put("clbzmx", clbzmx);
                map.put("jh", feedBack.getJh());
                map.put("mjxm", feedBack.getMjxm());
                map.put("lxdh", feedBack.getLxdh());
                map.put("dwbm", feedBack.getDwbm());
                map.put("dwmc", feedBack.getDwmc());
                map.put("fksj", Util.getDate("yyyy-MM-dd", feedBack.getFksj()));
                map.put("fhnr", feedBack.getFhnr());
                String clsj = "";
                if (feedBack.getClsj() != null) {
                    Util.getDate("yyyy-MM-dd", feedBack.getClsj());
                }
                map.put("clsj", clsj);
                listmap.add(map);
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/tims/feedbackcontroller/toShowDetail.do"})
    public String showDetail(String id, ModelMap map) {
        FeedBack fb = this.feedBackService.getFeedbackDetail((Serializable)((Object)id));
        try {
            map.put((Object)"id", (Object)fb.getId());
            map.put((Object)"yjlx", (Object)this.commonCodePbService.getCodeNameByCode(fb.getYjlx(), "2051"));
            map.put((Object)"gnmk", (Object)this.commonCodePbService.getCodeNameByCode(fb.getGnmk(), "2050"));
            map.put((Object)"title", (Object)fb.getTitle());
            map.put((Object)"content", (Object)fb.getContent());
            map.put((Object)"clbz", (Object)fb.getClbz());
            String clbzmx = "";
            if ("1".equals(fb.getClbz())) {
                clbzmx = "\u672a\u5904\u7406";
            } else if ("2".equals(fb.getClbz())) {
                clbzmx = "\u5df2\u5904\u7406";
            }
            map.put((Object)"jb", (Object)fb.getJb());
            map.put((Object)"clbzmx", (Object)clbzmx);
            map.put((Object)"jh", (Object)fb.getJh());
            map.put((Object)"mjxm", (Object)fb.getMjxm());
            map.put((Object)"lxdh", (Object)fb.getLxdh());
            map.put((Object)"dwbm", (Object)fb.getDwbm());
            map.put((Object)"dwmc", (Object)fb.getDwmc());
            map.put((Object)"fksj", (Object)Util.getDate("yyyy-MM-dd", fb.getFksj()));
            map.put((Object)"fhnr", (Object)fb.getFhnr());
            String clsj = "";
            if (fb.getClsj() != null) {
                Util.getDate("yyyy-MM-dd", fb.getClsj());
            }
            map.put((Object)"clsj", (Object)clsj);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "tims/feedback/default/showDetail";
    }

    @RequestMapping(value={"/tims/feedbackcontroller/getFeedbackDetail.do"})
    public void getFeedbackDetail(String id, HttpServletResponse response) {
        FeedBack fb = this.feedBackService.getFeedbackDetail((Serializable)((Object)id));
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("id", fb.getId());
            map.put("yjlx", this.commonCodePbService.getCodeNameByCode(fb.getYjlx(), "2051"));
            map.put("gnmk", this.commonCodePbService.getCodeNameByCode(fb.getGnmk(), "2050"));
            map.put("title", fb.getTitle());
            map.put("content", fb.getContent());
            String clbz = "";
            if ("1".equals(fb.getClbz())) {
                clbz = "\u672a\u5904\u7406";
            } else if ("2".equals(fb.getClbz())) {
                clbz = "\u5df2\u5904\u7406";
            }
            map.put("jb", fb.getJb());
            map.put("clbz", clbz);
            map.put("jh", fb.getJh());
            map.put("mjxm", fb.getMjxm());
            map.put("lxdh", fb.getLxdh());
            map.put("dwbm", fb.getDwbm());
            map.put("dwmc", fb.getDwmc());
            map.put("fksj", Util.getDate("yyyy-MM-dd", fb.getFksj()));
            map.put("fhnr", fb.getFhnr());
            String clsj = "";
            if (fb.getClsj() != null) {
                Util.getDate("yyyy-MM-dd", fb.getClsj());
            }
            map.put("clsj", clsj);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/tims/feedbackcontroller/replay.do"})
    public void replay(FeedBack feedBack, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = true;
        try {
            String fhnr = feedBack.getFhnr();
            String jb = feedBack.getJb();
            feedBack = this.feedBackService.getFeedbackDetail((Serializable)((Object)feedBack.getId()));
            feedBack.setJb(jb);
            feedBack.setFhnr(fhnr);
            feedBack.setCldwbm(this.person.getDepartment().getCode());
            feedBack.setCldwmc(this.person.getDepName());
            feedBack.setClrjh(this.person.getCode());
            feedBack.setClsj(new Date());
            feedBack.setClbz("2");
            this.feedBackService.update(feedBack);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e2);
            operateResult = false;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, 0, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

