/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.tims.bean.SuggestionBean;
import com.xdja.pams.tims.entity.Suggestion;
import com.xdja.pams.tims.entity.SuggestionFeedBack;
import com.xdja.pams.tims.service.SuggestionService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SuggestionFeedBackController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(SuggestionFeedBackController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SuggestionService suggerstionService;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"/tims/suggestionfeedbackcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = "tims/suggestionfeedback/default/index";
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/tims/suggestionfeedbackcontroller/query.do"})
    public void query(PageParam pageParam, HttpServletResponse response, HttpServletRequest request, SuggestionBean query) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        int operateResult = 1;
        List<Suggestion> list = null;
        try {
            list = this.suggerstionService.query(query, page);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "time.suggestion.controller.query.error"), (Throwable)e2);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("rows", list);
        String json = Util.toJsonStr(map);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/tims/suggestionfeedbackcontroller/querySuggestion.do"})
    public String querySuggestion(HttpServletResponse response, HttpServletRequest request, String id, ModelMap map) {
        Suggestion suggestion = null;
        try {
            suggestion = this.suggerstionService.queryById(id);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "time.suggestion.controller.query.error"), (Throwable)e2);
        }
        map.put((Object)"suggestion", (Object)suggestion);
        String json = Util.toJsonStr(suggestion);
        return "tims/suggestionfeedback/default/showDetail";
    }

    @RequestMapping(value={"/tims/suggestionfeedbackcontroller/addSuggestionFeedBack.do"})
    public void addSuggestionFeedBack(HttpServletResponse response, HttpServletRequest request, SuggestionFeedBack feedBack, ModelMap map) {
        ReturnResult rtnResult = new ReturnResult();
        feedBack.setHfr(this.person);
        feedBack.setHfsj(new Date());
        this.suggerstionService.addSuggestionFeedBack(feedBack);
        rtnResult.setRtnCode("0");
        rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, 0, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

