/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.upms.bean.QuerySysPowerBean;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.SysPowerService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SysPowerController
extends BaseControler {
    @Autowired
    private SysPowerService sysPowerService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(SysPowerController.class);

    @RequestMapping(value={"/upms/sysPowerController/listSysPower.do"})
    public String listSysPower(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/upms/sysPowerController/querySysPower.do"})
    public void querySysPower(HttpServletRequest request, HttpServletResponse response, PageParam page, QuerySysPowerBean querysyspowerbean, String parent_id) {
        int operateResult = 1;
        String json = "";
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<SysPower> sysPowerList = this.sysPowerService.querySysPowerList(querysyspowerbean, p);
            ArrayList codelist = new ArrayList();
            for (SysPower sysPower : sysPowerList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", sysPower.getId());
                map.put("name", sysPower.getName());
                map.put("link_page", sysPower.getLink_page());
                map.put("link_do", sysPower.getLink_do());
                map.put("status", sysPower.getStatus());
                map.put("ordernum", sysPower.getOrdernum());
                codelist.add(map);
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("total", Integer.valueOf(p.getTotal()));
            map.put("rows", codelist);
            json = Util.toJsonStr(map);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
            json = "";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, json);
    }

    @RequestMapping(value={"/upms/sysPowerController/updateStatus.do"})
    public void updateStatus(String id, String status, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        try {
            SysPower sys = this.sysPowerService.queryById(id);
            sys.setStatus(status);
            this.sysPowerService.updateModule(sys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flag", "1");
            Util.writeUtf8JSON(response, Util.toJsonStr(map));
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/sysPowerController/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        try {
            SysPower syspower = this.sysPowerService.queryById(id);
            map.put((Object)"id", (Object)id);
            map.put((Object)"link_do", (Object)syspower.getLink_do());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return "upms/default/updateSysPower";
    }

    @RequestMapping(value={"/upms/sysPowerController/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SysPower syspower = this.sysPowerService.queryById(id);
            map.put("id", syspower.getId());
            map.put("name", syspower.getName());
            map.put("code", syspower.getCode());
            map.put("link_do", syspower.getLink_do());
            map.put("ordernum", syspower.getOrdernum());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/upms/sysPowerController/saveSysPower.do"})
    public void saveSysPower(SysPower sysPower, HttpServletResponse response, HttpServletRequest request) throws IOException {
        HashMap<String, String> rst = new HashMap<String, String>();
        int operateResult = 1;
        try {
            SysPower sys = this.sysPowerService.queryById(sysPower.getId());
            sys.setName(sysPower.getName());
            sys.setOrdernum(sysPower.getOrdernum());
            sys.setLink_do(sysPower.getLink_do());
            this.sysPowerService.updateModule(sys);
            rst.put("flag", "1");
            rst.put("message", "");
        }
        catch (Exception e2) {
            operateResult = 0;
            rst.put("flag", "0");
            rst.put("message", "");
            log.error(e2.getMessage());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rst));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/upms/sysPowerController/getTreeChild.do"})
    public void getTreeChild(String id, HttpServletResponse response) throws IOException {
        SysPower sys = new SysPower();
        String jsonlist = "";
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                sys.setParent_id("-111");
            } else {
                sys.setParent_id(id);
            }
            List<SysPower> list = this.sysPowerService.querySysPowerList(sys, null);
            ArrayList treelist = new ArrayList();
            for (SysPower code : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", code.getId());
                map.put("text", code.getName());
                if (StringUtils.isNotBlank((CharSequence)code.getPower_type())) {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    map.put("state", "closed");
                    attributes.put("selectAble", "true");
                    attributes.put("pid", code.getParent_id());
                    attributes.put("power_type", code.getPower_type());
                    attributes.put("type", code.getType());
                    attributes.put("name", code.getName());
                    map.put("attributes", attributes);
                }
                treelist.add(map);
            }
            jsonlist = Util.toJsonStr(treelist);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }
}

