/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.service.impl;

import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.wfms.service.WorkflowUserSynService;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowUserSynServiceImpl
implements WorkflowUserSynService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUserSynServiceImpl.class);
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    private ResourceBundleMessageSource message;

    @Override
    @Transactional
    public boolean saveUser(User user) {
        boolean rtn = false;
        try {
            if (user != null) {
                this.identityService.saveUser(user);
                rtn = true;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            throw new WorkflowException(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        return rtn;
    }

    @Override
    @Transactional
    public boolean updateUser(User user) {
        boolean rtn = false;
        try {
            if (user != null) {
                this.identityService.deleteUser(user.getId());
                this.identityService.saveUser(user);
                rtn = true;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            throw new WorkflowException(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        return rtn;
    }

    @Override
    @Transactional
    public boolean deleteUser(User user) {
        boolean rtn = false;
        try {
            if (user != null) {
                List userGroupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
                if (userGroupList != null && !userGroupList.isEmpty()) {
                    for (Group group : userGroupList) {
                        this.identityService.deleteMembership(user.getId(), group.getId());
                    }
                }
                this.identityService.deleteUser(user.getId());
                rtn = true;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            throw new WorkflowException(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        return rtn;
    }
}

