/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.addressbook.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.jingxin.addressbook.entity.Rule;
import pams.function.jingxin.addressbook.service.AddressBookSynchronizeService;

@Controller
@Scope(value="session")
public class RuleControl
extends BaseControler {
    @Autowired
    AddressBookSynchronizeService addressBookSynchronizeService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    SystemLogService systemLogService;
    @Autowired
    CommonCodeService commonCodeService;
    private static final Logger log = LoggerFactory.getLogger(RuleControl.class);

    @RequestMapping(value={"/rule/ruleControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        List<CommonCode> ruleList = null;
        List<Rule> getRule = null;
        Rule rule = new Rule();
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            String ruleCode = (String)map.get((Object)"ruleCode");
            if (ruleCode == null || ruleCode.length() == 0) {
                ruleCode = "addressBookRule";
            }
            CommonCode commoncode = this.commonCodeService.getByCode(ruleCode, null);
            ruleList = this.commonCodeService.queryByTypeId(commoncode.getId());
            getRule = this.addressBookSynchronizeService.queryRuleListByCode(ruleCode);
            if (null != getRule && getRule.size() > 0) {
                rule = getRule.get(0);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"ruleList", ruleList);
        map.put((Object)"rule", (Object)rule);
        return sendUrl;
    }

    @RequestMapping(value={"/jxgl/JxGroup/index.do"})
    public String jxGroupRule(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String ruleCode = (String)map.get((Object)"ruleCode");
        if (ruleCode == null || ruleCode.length() == 0) {
            map.put((Object)"ruleCode", (Object)"jxGroupRule");
        }
        return this.index(request, response, map, page);
    }

    @RequestMapping(value={"/addressBookRuleControl/saveRule.do"})
    public void saveRule(ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("\u4fdd\u901a\u8baf\u5f55\u89c4\u5219\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/ruleControl/addRuleWeb.do"})
    public String addRuleWeb(ModelMap map, String id) {
        Rule rule = new Rule();
        rule.setId(id);
        List<CommonCode> ruleList = this.commonCodeService.queryByTypeId("8b8cefb44d795099014d795256a40004");
        if (!Util.varCheckEmp(id)) {
            try {
                rule = this.addressBookSynchronizeService.getRule(id);
            }
            catch (Exception e2) {
                log.error("\u6839\u636e\u697c\u5b87\u7f16\u53f7\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u5f02\u5e38", (Throwable)e2);
            }
        }
        map.put((Object)"ruleList", ruleList);
        map.put((Object)"rule", (Object)rule);
        return "jxgl/addressBookRule/default/addOrEdit";
    }
}

