/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.addressbook.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfree.util.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.jingxin.addressbook.bean.DepBean;
import pams.function.jingxin.addressbook.bean.PersonBean;
import pams.function.jingxin.addressbook.dao.AddressBookDao;
import pams.function.jingxin.addressbook.entity.DepDetail;
import pams.function.jingxin.addressbook.entity.DepDetailSql;
import pams.function.jingxin.addressbook.entity.PersonDetail;

@Repository
public class AddressBookDaoImpl
implements AddressBookDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<DepDetail> getDeps(DepBean depBean, Page page) {
        StringBuffer sb = new StringBuffer("select t.id \"id\", t.name \"name\", t.code \"code\",").append(" decode(t.deptype,'dept','1','org','2') \"type\", t.parent_id \"parentId\", ''||t.order_field \"seq\",").append(" t.flag \"deleteFlag\", t.display_state \"display_flag\",t.dep_abb \"nameAbbr\" from t_department t").append(" where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)depBean.getId())) {
            sb.append(" and t.id = ?");
            list.add(depBean.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getType())) {
            String type = "1".equals(depBean.getType()) ? "dept" : "org";
            sb.append(" and t.deptype = ?");
            list.add(type);
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getStartTime())) {
            sb.append("  and t.n_last_update_time>?");
            list.add(depBean.getStartTime());
            if (depBean.getStartTime().equals("0")) {
                sb.append("  and t.flag='0'");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getEndTime())) {
            sb.append("  and t.n_last_update_time<=?");
            list.add(depBean.getEndTime());
        }
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, DepDetail.class);
    }

    @Override
    public List<DepDetail> getDepsUp(DepBean depBean, Page page) {
        StringBuffer sb = new StringBuffer("select t.id \"id\", t.name \"name\", t.code \"code\",").append(" decode(t.deptype,'dept','1','org','2') \"type\", t.parent_id \"parentId\", ''||t.order_field \"seq\",").append(" t.flag \"deleteFlag\", t.display_state \"display_flag\",t.dep_abb \"nameAbbr\" from t_department t").append(" where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)depBean.getId())) {
            sb.append(" and t.id = ?");
            list.add(depBean.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getType())) {
            String type = "1".equals(depBean.getType()) ? "dept" : "org";
            sb.append(" and t.deptype = ?");
            list.add(type);
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getStartTime())) {
            sb.append("  and t.n_last_update_time>?");
            list.add(depBean.getStartTime());
            if (depBean.getStartTime().equals("0")) {
                sb.append("  and t.flag='0'");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getEndTime())) {
            sb.append("  and t.n_last_update_time<=?");
            list.add(depBean.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getPersonId())) {
            sb.append(" connect by prior t.parent_id=t.id start with id =( select dep_id from t_person where id= ? )");
            list.add(depBean.getPersonId());
        }
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, DepDetail.class);
    }

    @Override
    public List<DepDetailSql> getDepsDown(DepBean depBean, Page page) {
        StringBuffer sb = new StringBuffer("select t.id \"id\", t.name \"name\", t.code \"code\",").append(" decode(t.deptype,'dept','1','org','2') \"type\", t.parent_id \"parentId\", ''||t.order_field \"seq\",").append(" t.flag \"deleteFlag\", t.display_state \"display_flag\",t.dep_abb \"nameAbbr\" from t_department t").append(" where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)depBean.getType())) {
            String type = "1".equals(depBean.getType()) ? "dept" : "org";
            sb.append(" and t.deptype = ?");
            list.add(type);
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getStartTime())) {
            sb.append("  and t.n_last_update_time>?");
            list.add(depBean.getStartTime());
            if (depBean.getStartTime().equals("0")) {
                sb.append("  and t.flag='0'");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getEndTime())) {
            sb.append("  and t.n_last_update_time<=?");
            list.add(depBean.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)depBean.getRule())) {
            if ("1".equals(depBean.getRule())) {
                sb.append(" and id = ? ");
                list.add(depBean.getId());
            } else if ("2".equals(depBean.getRule())) {
                sb.append(" and t.parent_id = ? and t.deptype ='dept'");
                list.add(depBean.getId());
            } else if ("3".equals(depBean.getRule()) || "13".equals(depBean.getRule())) {
                sb.append(" connect by prior t.id=t.parent_id start with t.parent_id = ? ");
                list.add(depBean.getId());
            }
        } else if (StringUtils.isNotBlank((CharSequence)depBean.getId())) {
            sb.append(" and t.id = ?");
            list.add(depBean.getId());
        }
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        BigDecimal total = (BigDecimal)this.baseDao.getObjectBySQL(selectCount.toString(), list.toArray());
        page.setTotal(total.intValue());
        StringBuffer pagingSelect = new StringBuffer("select * from ( select row_.*, rownum rownum_ from ( ");
        pagingSelect.append(sb);
        pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        list.add(page.getPage() * page.getRp() + "");
        list.add((page.getPage() - 1) * page.getRp() + "");
        return this.baseDao.getListBySQL(pagingSelect.toString(), list.toArray(), DepDetailSql.class);
    }

    @Override
    public List<Map<String, String>> getPersonsDepChange(PersonBean personBean, Page page) {
        StringBuffer sb = new StringBuffer().append("select id \"id\",dep_id \"depId\" from (").append(" select a.id,a.dep_id,b.create_time from t_person a").append(" , (").append("   select m.person_id id,m.dep_id,m.n_last_update_time create_time").append("     from t_bims_person_edit m, (select person_id,max(n_last_update_time) edit_date").append("         from t_bims_person_edit").append("         group by person_id) n").append("     where m.person_id = n.person_id").append("     and m.n_last_update_time = n.edit_date").append("  ) b").append(" where a.id = b.id").append(" and a.dep_id <> b.dep_id");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and a.flag='0'");
        }
        sb.append(" union").append(" select a.id,a.dep_id,a.n_last_update_time").append(" from t_person a ").append(" where  not exists (").append("    select person_id ").append("       from t_bims_person_edit").append("       where person_id = a.id").append("       group by person_id").append(" ) ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and a.flag='0'");
        }
        sb.append(") where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime())) {
            sb.append(" and create_time > ? ");
            list.add(personBean.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getEndTime())) {
            sb.append(" and create_time <= ? ");
            list.add(personBean.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and id = ?");
            list.add(personBean.getPersonId());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getDepId())) {
            sb.append(" and dep_id = ?");
            list.add(personBean.getDepId());
        }
        sb.append(" group by id,dep_id");
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Map.class);
    }

    @Override
    public List<Map<String, String>> getPersonsUnitChange(PersonBean personBean, Page page) {
        StringBuffer sb = new StringBuffer().append("select id \"id\",dep_id \"depId\" from (").append(" select a.id,a.dep_id,b.create_time ").append("   from ( select m.id,n.parent_id dep_id").append("       from t_person m, t_department n  ").append("       where m.dep_id = n.id ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and m.flag='0'");
        }
        sb.append(" ) a, (").append("   select m.person_id id,l.parent_id dep_id,m.edit_date create_time").append("     from t_department l, t_bims_person_edit m, (select person_id,max(edit_date) edit_date").append("         from t_bims_person_edit").append("         group by person_id) n").append("     where m.person_id = n.person_id").append("     and m.edit_date = n.edit_date").append("     and l.id=m.dep_id").append("  ) b").append(" where a.id = b.id").append(" and a.dep_id <> b.dep_id").append(" union").append(" select m.id,n.parent_id dep_id,m.create_date").append(" from t_person m , t_department n ").append(" where m.dep_id = n.id");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and m.flag='0'");
        }
        sb.append(" ) where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime())) {
            sb.append("  and create_time> to_date(?,'yyyy-mm-dd hh24:mi:ss')");
            list.add(this.convert2String(personBean.getStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getEndTime())) {
            sb.append("  and create_time<= to_date(?,'yyyy-mm-dd hh24:mi:ss')");
            list.add(this.convert2String(personBean.getEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and id = ?");
            list.add(personBean.getPersonId());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getDepId())) {
            sb.append(" and dep_id = ?");
            list.add(personBean.getDepId());
        }
        sb.append(" group by id,dep_id");
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Map.class);
    }

    @Override
    public List<Map<String, String>> getPersons(DepBean depBean, Page page) {
        StringBuffer sb = new StringBuffer("select id \"id\" from t_person a where a.flag='0'");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)depBean.getRule())) {
            if ("1".equals(depBean.getRule()) || "11".equals(depBean.getRule())) {
                sb.append(" and a.dep_id = ? ");
                list.add(depBean.getId());
            } else if ("2".equals(depBean.getRule())) {
                sb.append(" and a.dep_id in ( select t.id from t_department t where t.parent_id = ? )");
                list.add(depBean.getId());
            } else if ("3".equals(depBean.getRule())) {
                sb.append(" and a.dep_id in ( select t.id from t_department t connect by prior t.id=t.parent_id start with id = ? )");
                list.add(depBean.getId());
            }
        } else if (StringUtils.isNotBlank((CharSequence)depBean.getId())) {
            sb.append(" and a.id = ?");
            list.add(depBean.getId());
        }
        Object[] values = list.toArray(new String[0]);
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), values, page, Map.class);
    }

    @Override
    public List<PersonDetail> getPersons(PersonBean personBean, Page page) {
        String mobileCol = "''";
        if (personBean.getShowMobile()) {
            mobileCol = "mobile";
        }
        StringBuffer sb = new StringBuffer(" select id \"id\", name \"name\", code \"code\", nameBriefSpell \"nameBriefSpell\", ").append(" depId \"depId\", depName \"depName\", station \"station\", officePhone \"officePhone\", ").append(mobileCol).append(" \"mobile\", seq \"seq\", displayFlag \"displayFlag\", deleteFlag \"deleteFlag\", imgSummary \"imgSummary\" ").append(", personType \"personType\",mobilePersonal \"mobilePersonal\"  ").append("  from (").append(" select a.id , a.name , a.code , a.name_brief_spell nameBriefSpell, ").append(" a.dep_id depId, d.name depName, a.police station, a.office_phone officePhone, ").append(" a.mobile mobile, ''||a.order_field seq, a.display_state displayFlag, ").append(" a.flag deleteFlag, c.c_img_summary  imgSummary").append(", a.PERSON_TYPE personType, MOBILE_PERSONAL mobilePersonal").append(" from t_person a, t_person_image c, t_department d ").append(" where a.id = c.person_id(+) and a.dep_id = d.id ");
        ArrayList<String> list = new ArrayList<String>();
        ArrayList nameKeys = new ArrayList();
        if (null != personBean.getIds()) {
            sb.append(" and (a.id in ('");
            int i = 0;
            for (String personId : personBean.getIds()) {
                sb.append(personId);
                if (++i % 1000 == 0) {
                    sb.append("') or a.id in ('");
                    continue;
                }
                sb.append("','");
            }
            sb.append("') )");
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and a.display_state <> '2' and d.id not in (select id from T_DEPARTMENT connect by prior id = parent_id start with id in (select id from T_DEPARTMENT t where display_state='2')) ");
        }
        sb.append(" group by a.id , a.name , a.code , a.name_brief_spell , a.dep_id , d.name , a.police , a.office_phone , a.mobile, a.order_field , a.display_state , a.flag , c.c_img_summary ");
        sb.append(", a.PERSON_TYPE,a.MOBILE_PERSONAL");
        sb.append("  ) where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and deleteFlag ='0' and  id <> '" + personBean.getPersonId() + "'");
            String key = personBean.getSearchContent();
            if (key.matches("[a-zA-Z]+")) {
                sb.append(" and nameBriefSpell like ?");
            } else if (key.matches("[0-9]*")) {
                sb.append(" and ( mobilePersonal like ? or code like ? or officePhone like ? ");
                if (personBean.getShowMobile()) {
                    sb.append(" or mobile like ?");
                    list.add("%" + key + "%");
                }
                sb.append(" )");
                list.add("%" + key + "%");
                list.add("%" + key + "%");
            } else {
                sb.append(" and name like ?");
            }
            list.add("%" + key + "%");
        } else if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and id = ?");
            list.add(personBean.getPersonId());
        }
        sb.append(" order by nameBriefSpell asc");
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, PersonDetail.class);
    }

    @Override
    public List<PersonDetail> getPersons(PersonBean personBean, String matchRule, Page page) {
        String mobileCol = "''";
        if (personBean.getShowMobile()) {
            mobileCol = "mobile";
        }
        StringBuffer sb = new StringBuffer(" select id \"id\", name \"name\", code \"code\", nameBriefSpell \"nameBriefSpell\", ").append(" depId \"depId\", depName \"depName\", station \"station\", officePhone \"officePhone\", ").append(mobileCol).append(" \"mobile\", seq \"seq\", displayFlag \"displayFlag\", deleteFlag \"deleteFlag\", imgSummary \"imgSummary\" ").append(", personType \"personType\",mobilePersonal \"mobilePersonal\"  ").append("  from (").append(" select a.id , a.name , a.code , a.name_brief_spell nameBriefSpell, ").append(" a.dep_id depId, d.name depName, a.police station, a.office_phone officePhone, ").append(" a.mobile mobile, ''||a.order_field seq, a.display_state displayFlag, ").append(" a.flag deleteFlag, c.c_img_summary  imgSummary").append(", a.PERSON_TYPE personType, MOBILE_PERSONAL mobilePersonal").append(" from t_person a, t_person_image c, t_department d ").append(" where a.id = c.person_id(+) and a.dep_id = d.id ");
        ArrayList<String> list = new ArrayList<String>();
        ArrayList nameKeys = new ArrayList();
        if (null != personBean.getIds()) {
            sb.append(" and (a.id in ('");
            int i = 0;
            for (String personId : personBean.getIds()) {
                sb.append(personId);
                if (++i % 1000 == 0) {
                    sb.append("') or a.id in ('");
                    continue;
                }
                sb.append("','");
            }
            sb.append("') )");
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and a.display_state <> '2' and d.id not in (select id from T_DEPARTMENT connect by prior id = parent_id start with id in (select id from T_DEPARTMENT t where display_state='2')) ");
        }
        sb.append(" group by a.id , a.name , a.code , a.name_brief_spell , a.dep_id , d.name , a.police , a.office_phone , a.mobile, a.order_field , a.display_state , a.flag , c.c_img_summary ");
        sb.append(", a.PERSON_TYPE,a.MOBILE_PERSONAL");
        sb.append("  ) where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and deleteFlag ='0' and  id <> '" + personBean.getPersonId() + "'");
            String key = personBean.getSearchContent();
            sb.append(" and name like ?");
            if ("left".equals(matchRule)) {
                list.add(key + "%");
            } else if ("right".equals(matchRule)) {
                list.add("%" + key);
            } else {
                list.add("%" + key + "%");
            }
        } else if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and id = ?");
            list.add(personBean.getPersonId());
        }
        sb.append(" order by nameBriefSpell asc");
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, PersonDetail.class);
    }

    @Override
    public List<PersonDetail> getPersonsForXJ(PersonBean personBean, Page page) {
        String mobileCol = "''";
        if (personBean.getShowMobile()) {
            mobileCol = "mobile";
        }
        StringBuffer sb = new StringBuffer(" select id \"id\", name \"name\", code \"code\", nameBriefSpell \"nameBriefSpell\", ").append(" depId \"depId\", depName \"depName\", station \"station\", officePhone \"officePhone\", ").append(mobileCol).append("  \"mobile\", seq \"seq\", displayFlag \"displayFlag\", deleteFlag \"deleteFlag\", imgSummary \"imgSummary\" ").append(", personType \"personType\",mobilePersonal \"mobilePersonal\"  ").append("  from (").append(" select a.id , a.name , a.code , a.name_brief_spell nameBriefSpell, ").append(" a.dep_id depId, d.name depName, a.police station, a.office_phone officePhone, ").append(" a.mobile mobile, ''||a.order_field seq, a.display_state displayFlag, ").append(" a.flag deleteFlag, c.c_img_summary  imgSummary").append(", a.PERSON_TYPE personType, MOBILE_PERSONAL mobilePersonal").append(" from t_person a, t_person_image c, t_department d ").append(" where a.id = c.person_id(+) and a.dep_id = d.id ");
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> nameKeys = new ArrayList<String>();
        if (null != personBean.getIds()) {
            sb.append("and a.id in ( :ids ) ");
            nameKeys.add("ids");
            list.add(personBean.getIds());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and a.display_state <> '2' and d.id not in (select id from T_DEPARTMENT connect by prior id = parent_id start with id in (select id from T_DEPARTMENT t where display_state='2')) ");
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and ((a.PERSON_TYPE <> '1' and d.id <> (select dep_id from t_person where id= ?)) or  d.id = (select dep_id from t_person where id=?))");
            list.add(personBean.getPersonId());
            list.add(personBean.getPersonId());
        }
        sb.append(" group by a.id , a.name , a.code , a.name_brief_spell , a.dep_id , d.name , a.police , a.office_phone , a.mobile, a.order_field , a.display_state , a.flag , c.c_img_summary ");
        sb.append(", a.PERSON_TYPE,a.MOBILE_PERSONAL");
        sb.append("  ) where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getSearchContent())) {
            sb.append(" and deleteFlag ='0' and  id <> '" + personBean.getPersonId() + "'");
            String key = personBean.getSearchContent();
            if (key.matches("[a-zA-Z]+")) {
                sb.append(" and nameBriefSpell like ?");
            } else if (key.matches("[0-9]*")) {
                sb.append(" and ( mobilePersonal like ? or code like ? or officePhone like ? ");
                if (personBean.getShowMobile()) {
                    sb.append(" or mobile like ?");
                    list.add("%" + key + "%");
                }
                sb.append(" )");
                list.add("%" + key + "%");
                list.add("%" + key + "%");
            } else {
                sb.append(" and name like ?");
            }
            list.add("%" + key + "%");
        } else if (StringUtils.isNotBlank((CharSequence)personBean.getPersonId())) {
            sb.append(" and id = ?");
            list.add(personBean.getPersonId());
        }
        sb.append(" order by nameBriefSpell asc");
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, PersonDetail.class, nameKeys);
    }

    @Override
    public List<Map<String, String>> getPersonsChange(PersonBean personBean, Page page) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ArrayList<String> nameKeys = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("select id \"id\" ");
        sb.append(" from ( select id, max(n_last_update_time) n_last_update_time");
        sb.append("     \tfrom (  select id, greatest(edit_n_last_update_time, n_last_update_time) n_last_update_time");
        sb.append("           \t\tfrom (  select a.id, a.n_last_update_time, nvl(b.n_last_update_time, a.n_last_update_time) edit_n_last_update_time");
        sb.append("     \t\t\t\t\tfrom t_person a, t_bims_person_edit b");
        sb.append("     \t\t\t\t\twhere a.id = b.person_id(+)");
        if (null != personBean.getIds()) {
            sb.append(" and a.id in ( :ids ) ");
            nameKeys.add("ids");
            list.add(personBean.getIds());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and a.flag='0'");
        }
        sb.append("     \t\t\t\t)");
        sb.append("  \t\t\t)");
        sb.append("  \t\tgroup by id");
        sb.append(" \t) where 1=1");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime())) {
            sb.append("  and n_last_update_time>= '" + personBean.getStartTime() + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getEndTime())) {
            sb.append("  and n_last_update_time<= '" + personBean.getEndTime() + "'");
        }
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Map.class, nameKeys);
    }

    @Override
    public List<Map<String, String>> getChangePersonsByPersonid(PersonBean personBean, Page page) {
        ArrayList list = new ArrayList();
        ArrayList<String> nameKeys = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("select id \"id\" ");
        sb.append(" from ( select id, max(n_last_update_time) n_last_update_time");
        sb.append("     \tfrom (  select id, decode(Sign(n_last_update_time - edit_n_last_update_time),1,n_last_update_time,edit_n_last_update_time) n_last_update_time,nvl(depId2,depId1) dep_id");
        sb.append("           \t\t from ( select a.id, nvl(b.n_last_update_time, a.n_last_update_time) as edit_n_last_update_time, a.dep_id depId1, b.dep_id depId2,");
        sb.append("               \t\ta.n_last_update_time ");
        sb.append("     \t\t\t\t\tfrom t_person a, t_bims_person_edit b");
        sb.append("     \t\t\t\t\twhere a.id = b.person_id(+)");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime()) && personBean.getStartTime().equals("0")) {
            sb.append("   and a.flag='0'");
        }
        sb.append("     \t\t\t\t)");
        sb.append("  \t\t\t)");
        sb.append("  \t\tgroup by id");
        sb.append(" \t) where 1=1");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime())) {
            sb.append("  and n_last_update_time>= '" + personBean.getStartTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getEndTime())) {
            sb.append("  and n_last_update_time<= '" + personBean.getEndTime() + "' ");
        }
        Log.info((Object)("tongbu:" + sb.toString()));
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Map.class, nameKeys);
    }

    @Override
    public List<Map<String, String>> getDeletedPersons(PersonBean personBean, Page page) {
        ArrayList list = new ArrayList();
        ArrayList<String> nameKeys = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("select id \"id\" from t_person a where a.flag ='1' ");
        if (StringUtils.isNotBlank((CharSequence)personBean.getStartTime())) {
            sb.append("  and n_last_update_time>= " + personBean.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)personBean.getEndTime())) {
            sb.append("  and n_last_update_time<= " + personBean.getEndTime());
        }
        String selectCount = "select count(1) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Map.class, nameKeys);
    }

    public String convert2String(String time) {
        return this.convert2String(Long.parseLong(time));
    }

    public String convert2String(long time) {
        String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sf = new SimpleDateFormat(TIME_FORMAT);
        Date date = new Date(time);
        return sf.format(date);
    }

    @Override
    public String getLastUpdateTime() {
        StringBuffer sb = new StringBuffer();
        sb.append("select max(n_last_update_time) from (select max(a.n_last_update_time) n_last_update_time from t_person a  where a.id <> '0' union all select max(a.n_last_update_time) n_last_update_time from t_bims_person_edit a  where a.id <> '0' union all select max(b.n_last_update_time) n_last_update_time from t_department b where  b.id <> '9999999999') ");
        return this.baseDao.getSingleValue(sb.toString());
    }
}

