/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.addressbook.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import pams.function.jingxin.addressbook.bean.DepBean;
import pams.function.jingxin.addressbook.bean.PersonBean;
import pams.function.jingxin.addressbook.bean.ReqChangePersonsByIds;
import pams.function.jingxin.addressbook.bean.ReqChangePersonsByPersonid;
import pams.function.jingxin.addressbook.bean.ReqDeletedPersons;
import pams.function.jingxin.addressbook.bean.ReqDepByPersonId;
import pams.function.jingxin.addressbook.bean.ReqDepsByType;
import pams.function.jingxin.addressbook.bean.ReqDepsNewByPersonId;
import pams.function.jingxin.addressbook.bean.ReqPersonsByDepartmentId;
import pams.function.jingxin.addressbook.bean.ReqPersonsByIds;
import pams.function.jingxin.addressbook.bean.ReqPersonsByPersonId;
import pams.function.jingxin.addressbook.bean.ReqPersonsByQueryKey;
import pams.function.jingxin.addressbook.bean.ReqPersonsDepChange;
import pams.function.jingxin.addressbook.dao.AddressBookDao;
import pams.function.jingxin.addressbook.entity.DepDetail;
import pams.function.jingxin.addressbook.entity.DepDetailSql;
import pams.function.jingxin.addressbook.entity.PersonDetail;
import pams.function.jingxin.addressbook.service.AddressBookService;

@Service
public class AddressBookServiceImpl
implements AddressBookService {
    @Autowired
    private AddressBookDao addressBookDao;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    private static Logger log = Logger.getLogger(AddressBookServiceImpl.class);

    @Override
    public List<DepDetail> getDepsByType(ReqDepsByType reqDepsByType) {
        if (StringUtils.isNotBlank((CharSequence)reqDepsByType.getType()) && !"1".equals(reqDepsByType.getType()) && !"2".equals(reqDepsByType.getType())) {
            log.error((Object)"getDepsByType error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        DepBean depBean = new DepBean();
        BeanUtils.copyProperties((Object)reqDepsByType, (Object)depBean);
        List<DepDetail> data = this.addressBookDao.getDeps(depBean, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList<DepDetail>();
        }
        return data;
    }

    @Override
    public DepDetail getDepByPersonId(ReqDepByPersonId reqDepByPersonId) {
        if (StringUtils.isBlank((CharSequence)reqDepByPersonId.getPersonId()) || StringUtils.isBlank((CharSequence)reqDepByPersonId.getType())) {
            log.error((Object)"getDepByPersonId error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!("1".equals(reqDepByPersonId.getType()) || "2".equals(reqDepByPersonId.getType()) || "11".equals(reqDepByPersonId.getType()) || "12".equals(reqDepByPersonId.getType()))) {
            log.error((Object)"getDepByPersonId error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        DepBean depBean = new DepBean();
        depBean.setType(reqDepByPersonId.getType());
        depBean.setPersonId(reqDepByPersonId.getPersonId());
        List<DepDetail> list = this.addressBookDao.getDepsUp(depBean, null);
        DepDetail data = null;
        if (list != null && list.size() > 0) {
            if ("11".equals(reqDepByPersonId.getType())) {
                reqDepByPersonId.setType("1");
            } else if ("12".equals(reqDepByPersonId.getType())) {
                reqDepByPersonId.setType("2");
            }
            for (DepDetail detail : list) {
                if (!reqDepByPersonId.getType().equals(detail.getType())) continue;
                data = detail;
                return data;
            }
        }
        return data;
    }

    @Override
    public void getDepsNewByPersonId(ReqDepsNewByPersonId reqDepsNewByPersonId, List<DepDetail> data, Map<String, String> appendDetail) {
        String type;
        if (StringUtils.isBlank((CharSequence)reqDepsNewByPersonId.getPersonId()) || StringUtils.isBlank((CharSequence)reqDepsNewByPersonId.getRule()) || StringUtils.isBlank((CharSequence)reqDepsNewByPersonId.getStartTime()) || StringUtils.isBlank((CharSequence)reqDepsNewByPersonId.getPageNo()) || StringUtils.isBlank((CharSequence)reqDepsNewByPersonId.getPageSize())) {
            log.error((Object)"getDepsNewByPersonId error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!("1".equals(reqDepsNewByPersonId.getRule()) || "2".equals(reqDepsNewByPersonId.getRule()) || "3".equals(reqDepsNewByPersonId.getRule()) || "13".equals(reqDepsNewByPersonId.getRule()))) {
            log.error((Object)"getDepsNewByPersonId error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        DepBean depBean = new DepBean();
        BeanUtils.copyProperties((Object)reqDepsNewByPersonId, (Object)depBean);
        ReqDepByPersonId reqDepByPersonId = new ReqDepByPersonId();
        reqDepByPersonId.setPersonId(depBean.getPersonId());
        String string = type = reqDepsNewByPersonId.getRule().equals("1") ? "1" : "2";
        if ("13".equals(reqDepsNewByPersonId.getRule())) {
            type = "12";
        }
        reqDepByPersonId.setType(type);
        DepDetail org = this.getDepByPersonId(reqDepByPersonId);
        DepDetail dep = null;
        if ("1".equals(type)) {
            dep = org;
        } else {
            reqDepByPersonId.setType("1");
            dep = this.getDepByPersonId(reqDepByPersonId);
        }
        if (!"0".equals(reqDepsNewByPersonId.getStartTime())) {
            PersonBean personBean = new PersonBean();
            BeanUtils.copyProperties((Object)reqDepsNewByPersonId, (Object)personBean);
            personBean.setDepId(dep.getId());
            List<Map<String, String>> changeDeps = this.addressBookDao.getPersonsDepChange(personBean, null);
            changeDeps = null;
            if (changeDeps != null && changeDeps.size() > 0) {
                data.add(org);
                appendDetail.put("ifDepChange", "1");
                appendDetail.put("totalPage", "1");
                appendDetail.put("currentPage", "1");
                appendDetail.put("totalCount", "1");
                appendDetail.put("lastTime", System.currentTimeMillis() + "");
                return;
            }
        }
        Page page = new Page(reqDepsNewByPersonId.getPageNo(), reqDepsNewByPersonId.getPageSize());
        depBean.setId(org.getId());
        List<DepDetailSql> tmp = this.addressBookDao.getDepsDown(depBean, page);
        DepDetail depDetail = null;
        if (tmp != null && tmp.size() > 0) {
            for (DepDetailSql tmpDetail : tmp) {
                depDetail = new DepDetail();
                BeanUtils.copyProperties((Object)tmpDetail, (Object)depDetail);
                data.add(depDetail);
            }
        }
        appendDetail.put("ifDepChange", "0");
        appendDetail.put("totalPage", "" + page.getPageCount());
        appendDetail.put("currentPage", "" + page.getPage());
        appendDetail.put("totalCount", "" + page.getTotal());
        appendDetail.put("lastTime", System.currentTimeMillis() + "");
    }

    @Override
    public List<Map<String, String>> getPersonsDepChange(ReqPersonsDepChange reqPersonsDepChange) {
        if (StringUtils.isBlank((CharSequence)reqPersonsDepChange.getRule())) {
            log.error((Object)"getPersonsDepChange error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!("1".equals(reqPersonsDepChange.getRule()) || "2".equals(reqPersonsDepChange.getRule()) || "11".equals(reqPersonsDepChange.getRule()))) {
            log.error((Object)"getPersonsDepChange error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqPersonsDepChange, (Object)personBean);
        List<Object> data = new ArrayList();
        data = "1".equals(reqPersonsDepChange.getRule()) || "11".equals(reqPersonsDepChange.getRule()) ? this.addressBookDao.getPersonsDepChange(personBean, null) : this.addressBookDao.getPersonsUnitChange(personBean, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList();
        }
        return data;
    }

    @Override
    public List<String> getPersonsByPersonId(ReqPersonsByPersonId reqPersonsByPersonId) {
        if (StringUtils.isBlank((CharSequence)reqPersonsByPersonId.getPersonId()) || StringUtils.isBlank((CharSequence)reqPersonsByPersonId.getRule())) {
            log.error((Object)"getPersonsByPersonId error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!("1".equals(reqPersonsByPersonId.getRule()) || "2".equals(reqPersonsByPersonId.getRule()) || "3".equals(reqPersonsByPersonId.getRule()))) {
            log.error((Object)"getPersonsByPersonId error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        ReqDepByPersonId reqDepByPersonId = new ReqDepByPersonId();
        BeanUtils.copyProperties((Object)reqPersonsByPersonId, (Object)reqDepByPersonId);
        String type = reqPersonsByPersonId.getRule().equals("1") ? "1" : "2";
        reqDepByPersonId.setType(type);
        DepDetail depDetail = this.getDepByPersonId(reqDepByPersonId);
        if (depDetail == null) {
            log.error((Object)"getPersonsByPersonId error : \u4eba\u5458\u6216\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new RuntimeException("\u4eba\u5458\u6216\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        DepBean depBean = new DepBean();
        depBean.setId(depDetail.getId());
        BeanUtils.copyProperties((Object)reqPersonsByPersonId, (Object)depBean);
        List<Map<String, String>> tmp = this.addressBookDao.getPersons(depBean, null);
        ArrayList<String> data = new ArrayList<String>();
        if (tmp == null || tmp.size() == 0) {
            data = new ArrayList();
        } else {
            for (Map<String, String> map : tmp) {
                data.add(map.get("id"));
            }
        }
        return data;
    }

    @Override
    public List<String> getPersonsByDepartmentId(ReqPersonsByDepartmentId reqPersonsByDepartmentId) {
        if (StringUtils.isBlank((CharSequence)reqPersonsByDepartmentId.getDepId()) || StringUtils.isBlank((CharSequence)reqPersonsByDepartmentId.getRule())) {
            log.error((Object)"getPersonsByDepartmentId error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!("1".equals(reqPersonsByDepartmentId.getRule()) || "2".equals(reqPersonsByDepartmentId.getRule()) || "3".equals(reqPersonsByDepartmentId.getRule()) || "11".equals(reqPersonsByDepartmentId.getRule()))) {
            log.error((Object)"getPersonsByDepartmentId error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        DepBean depBean = new DepBean();
        depBean.setId(reqPersonsByDepartmentId.getDepId());
        BeanUtils.copyProperties((Object)reqPersonsByDepartmentId, (Object)depBean);
        List<Map<String, String>> tmp = this.addressBookDao.getPersons(depBean, null);
        ArrayList<String> data = new ArrayList<String>();
        if (tmp == null || tmp.size() == 0) {
            data = new ArrayList();
        } else {
            for (Map<String, String> map : tmp) {
                data.add(map.get("id"));
            }
        }
        return data;
    }

    @Override
    public List<PersonDetail> getPersonsByIds(ReqPersonsByIds reqPersonsByIds) {
        if (reqPersonsByIds.getList() == null || reqPersonsByIds.getList().size() == 0) {
            log.error((Object)"getPersonsByIds error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqPersonsByIds, (Object)personBean);
        personBean.setIds(reqPersonsByIds.getList());
        List<PersonDetail> data = this.addressBookDao.getPersons(personBean, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList<PersonDetail>();
        }
        return data;
    }

    @Override
    public List<PersonDetail> getPersonsByQueryKey(ReqPersonsByQueryKey reqPersonsByQueryKey) {
        if (StringUtils.isBlank((CharSequence)reqPersonsByQueryKey.getPersonId()) || StringUtils.isBlank((CharSequence)reqPersonsByQueryKey.getSearchContent())) {
            log.error((Object)"getPersonsByQueryKey error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqPersonsByQueryKey, (Object)personBean);
        List<PersonDetail> data = this.addressBookDao.getPersons(personBean, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList<PersonDetail>();
        }
        return data;
    }

    @Override
    public List<PersonDetail> getPersonsByQueryKeyV3(ReqPersonsByQueryKey reqPersonsByQueryKey, String matchRule) {
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqPersonsByQueryKey, (Object)personBean);
        List<PersonDetail> data = this.addressBookDao.getPersons(personBean, matchRule, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList<PersonDetail>();
        }
        return data;
    }

    @Override
    public List<PersonDetail> getPersonsByQueryKeyV2(ReqPersonsByQueryKey reqPersonsByQueryKey) {
        if (StringUtils.isBlank((CharSequence)reqPersonsByQueryKey.getPersonId()) || StringUtils.isBlank((CharSequence)reqPersonsByQueryKey.getSearchContent())) {
            log.error((Object)"getPersonsByQueryKey error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        Person person = this.userManageService.queryPersonById(reqPersonsByQueryKey.getPersonId());
        if (person == null) {
            return new ArrayList<PersonDetail>();
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqPersonsByQueryKey, (Object)personBean);
        List<PersonDetail> data = null;
        data = "1".equals(person.getPersonType()) ? this.addressBookDao.getPersons(personBean, null) : this.addressBookDao.getPersonsForXJ(personBean, null);
        if (data == null || data.size() == 0) {
            data = new ArrayList<PersonDetail>();
        }
        return data;
    }

    @Override
    public List<String> getChangePersonsByIds(ReqChangePersonsByIds reqChangePersonsByIds) {
        if (reqChangePersonsByIds.getList() == null || reqChangePersonsByIds.getList().size() == 0) {
            log.error((Object)"getChangePersonsByIds error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqChangePersonsByIds, (Object)personBean);
        personBean.setIds(reqChangePersonsByIds.getList());
        List<Map<String, String>> tmp = this.addressBookDao.getPersonsChange(personBean, null);
        ArrayList<String> data = new ArrayList<String>();
        if (tmp == null || tmp.size() == 0) {
            data = new ArrayList();
        } else {
            for (Map<String, String> map : tmp) {
                data.add(map.get("id"));
            }
        }
        return data;
    }

    @Override
    public List<String> getChangePersonsByPersonid(ReqChangePersonsByPersonid reqChangePersonsByPersonid) {
        if (StringUtils.isBlank((CharSequence)reqChangePersonsByPersonid.getPersonId()) || StringUtils.isBlank((CharSequence)reqChangePersonsByPersonid.getRule())) {
            log.error((Object)"getChangePersonsByPersonid error : \u7f3a\u5c11\u53c2\u6570");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        if (!"13".equals(reqChangePersonsByPersonid.getRule())) {
            log.error((Object)"getChangePersonsByPersonid error : \u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "addressBook.service.parameter.error"));
        }
        ReqDepByPersonId reqDepByPersonId = new ReqDepByPersonId();
        reqDepByPersonId.setPersonId(reqChangePersonsByPersonid.getPersonId());
        reqDepByPersonId.setType("12");
        DepDetail dept = this.getDepByPersonId(reqDepByPersonId);
        if (dept == null) {
            throw new RuntimeException("\u4eba\u5458\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqChangePersonsByPersonid, (Object)personBean);
        personBean.setDepId(dept.getId());
        List<Map<String, String>> tmp = this.addressBookDao.getChangePersonsByPersonid(personBean, null);
        ArrayList<String> data = new ArrayList<String>();
        if (tmp == null || tmp.size() == 0) {
            data = new ArrayList();
        } else {
            for (Map<String, String> map : tmp) {
                data.add(map.get("id"));
            }
        }
        return data;
    }

    @Override
    public List<String> getDeletedPersons(ReqDeletedPersons reqDeletedPersons) {
        PersonBean personBean = new PersonBean();
        BeanUtils.copyProperties((Object)reqDeletedPersons, (Object)personBean);
        List<Map<String, String>> tmp = this.addressBookDao.getDeletedPersons(personBean, null);
        ArrayList<String> data = new ArrayList<String>();
        if (tmp == null || tmp.size() == 0) {
            data = new ArrayList();
        } else {
            for (Map<String, String> map : tmp) {
                data.add(map.get("id"));
            }
        }
        return data;
    }

    @Override
    public String getLastUpdateTime() {
        return this.addressBookDao.getLastUpdateTime();
    }
}

