/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.addressbook.service.impl;

import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonUpdated;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.PinYin4j;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.bean.SynDepartment;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.jingxin.addressbook.bean.AddressBookCheckBean;
import pams.function.jingxin.addressbook.bean.SynPersonBean;
import pams.function.jingxin.addressbook.bean.SynQueryParamBean;
import pams.function.jingxin.addressbook.bean.SyncDepBean;
import pams.function.jingxin.addressbook.bean.SyncPersonBean;
import pams.function.jingxin.addressbook.bean.UpdatePersonalMobileParam;
import pams.function.jingxin.addressbook.dao.AddressBookSynchronizeDao;
import pams.function.jingxin.addressbook.entity.PersonImage;
import pams.function.jingxin.addressbook.entity.Rule;
import pams.function.jingxin.addressbook.service.AddressBookSynchronizeService;

@Service
public class AddressBookSynchronizeServiceImpl
implements AddressBookSynchronizeService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    AddressBookSynchronizeDao addressBookSynchronizeDao;
    @Autowired
    PersonDao personDao;
    private static Logger log = Logger.getLogger(AddressBookSynchronizeServiceImpl.class);

    @Override
    public SynRst<?> basicInfoSyn(SynQueryParamBean synQueryParamBean, String type) throws Exception {
        List<BigDecimal> maxUpdateTime;
        SynRst<Object> synRst = new SynRst<Object>();
        if (synQueryParamBean == null) {
            log.error((Object)"\u4eba\u5458\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror"));
            return synRst;
        }
        String startTime = synQueryParamBean.getStartTime();
        String endTime = synQueryParamBean.getEndTime();
        String pageNo = synQueryParamBean.getPageNo();
        String pageSize = synQueryParamBean.getPageSize();
        if (!StringUtils.isNotBlank((CharSequence)synQueryParamBean.getId()) && !StringUtils.isNotBlank((CharSequence)synQueryParamBean.getCode()) && null != (maxUpdateTime = this.addressBookSynchronizeDao.getPersonMaxUpdateTime(synQueryParamBean)) && maxUpdateTime.size() > 0 && null != maxUpdateTime.get(0)) {
            synRst.setTime(maxUpdateTime.toArray()[0].toString());
        }
        int i_pageNo = 0;
        int i_pageSize = 0;
        try {
            i_pageNo = Integer.parseInt(pageNo);
        }
        catch (NumberFormatException e2) {
            log.error((Object)"\u540c\u6b65\u5931\u8d25\uff0c\u9875\u7801\u6709\u8bef\uff0c\u6700\u5c0f\u4e3a1", (Throwable)e2);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pageno") + ":" + pageNo);
            return synRst;
        }
        if (i_pageNo < 1) {
            i_pageNo = 1;
        }
        try {
            i_pageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException e3) {
            log.error((Object)e3.getMessage(), (Throwable)e3);
        }
        int i_configPageSize = 0;
        String configPageSize = this.systemConfigService.getValueByCode("syninfo_pagesize");
        try {
            i_configPageSize = Integer.parseInt(configPageSize);
        }
        catch (NumberFormatException e4) {
            log.error((Object)e4.getMessage(), (Throwable)e4);
        }
        if (i_pageSize > i_configPageSize) {
            i_pageSize = i_configPageSize;
        }
        if (i_pageSize < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pagesize"));
            log.error((Object)"\u540c\u6b65\u5931\u8d25\uff0c\u6bcf\u9875\u6570\u91cf\u914d\u7f6e\u6709\u8bef");
            return synRst;
        }
        Page page = new Page();
        page.setPage(i_pageNo);
        page.setRp(i_pageSize);
        try {
            if (StringUtils.isNotBlank((CharSequence)synQueryParamBean.getStartTime())) {
                Long.parseLong(startTime);
            }
            if (StringUtils.isNotBlank((CharSequence)synQueryParamBean.getEndTime())) {
                Long.parseLong(endTime);
            }
        }
        catch (NumberFormatException e5) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.updatetime") + ":" + "startTime:" + startTime + "endTime:" + endTime);
            log.error((Object)("\u540c\u6b65\u5931\u8d25\uff0c\u66f4\u65b0\u65f6\u95f4\u6233\u975e\u6570\u5b57\u683c\u5f0f\uff1astartTime:" + startTime + "endTime:" + endTime), (Throwable)e5);
            return synRst;
        }
        if ("0".equals(type)) {
            if ("0".equals(synQueryParamBean.getInterfaceType())) {
                synRst.setList(this.querySynPerson(synQueryParamBean, page));
                synRst.setCount(page.getTotal());
            } else {
                synRst.setList(this.queryPersonList(synQueryParamBean, page));
                synRst.setCount(page.getTotal());
            }
        } else if ("1".equals(type)) {
            if ("0".equals(synQueryParamBean.getInterfaceType())) {
                synRst.setList(this.querySynDep(synQueryParamBean, page));
                synRst.setCount(page.getTotal());
            } else {
                synRst.setList(this.queryDepList(synQueryParamBean, page));
                synRst.setCount(page.getTotal());
            }
        } else {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.datatype"));
        }
        synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        return synRst;
    }

    private List<SyncDepBean> queryDepList(SynQueryParamBean synQueryParamBean, Page page) throws Exception {
        List<Department> depList = this.addressBookSynchronizeDao.getListByDep(synQueryParamBean, page);
        ArrayList<SyncDepBean> synList = new ArrayList<SyncDepBean>();
        for (Department dep : depList) {
            SyncDepBean synDep = new SyncDepBean();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synDep.setDisplay_flag(dep.getDisplayState());
            synDep.setDepType(dep.getDepType());
            synList.add(synDep);
        }
        return synList;
    }

    private List queryPersonList(SynQueryParamBean synQueryParamBean, Page page) throws Exception {
        List<SyncPersonBean> list = this.addressBookSynchronizeDao.syncPersonList(synQueryParamBean, page);
        for (SyncPersonBean syncPersonBean : list) {
            String nbs = syncPersonBean.getName_brief_spell();
            if (StringUtils.isBlank((CharSequence)nbs)) {
                nbs = PinYin4j.getNameSimplicityWithPolyphone(syncPersonBean.getName());
            }
            syncPersonBean.setName_brief_spell(nbs);
            syncPersonBean.setN_last_update_time(String.valueOf(syncPersonBean.getUpdateTime()));
            if (null == syncPersonBean.getOrderField()) continue;
            syncPersonBean.setSeq(String.valueOf(syncPersonBean.getOrderField()));
        }
        return list;
    }

    private List<SynPersonBean> querySynPerson(SynQueryParamBean synQueryParamBean, Page page) throws Exception {
        List<SynPersonBean> list = this.addressBookSynchronizeDao.getListByPerson(synQueryParamBean, page);
        for (SynPersonBean synPersonBean : list) {
            String nbs = synPersonBean.getName_brief_spell();
            if (StringUtils.isBlank((CharSequence)nbs)) {
                nbs = PinYin4j.getNameSimplicityWithPolyphone(synPersonBean.getName());
            }
            synPersonBean.setName_brief_spell(nbs);
            synPersonBean.setN_last_update_time(String.valueOf(synPersonBean.getUpdateTime()));
            if (null == synPersonBean.getOrderField()) continue;
            synPersonBean.setSeq(String.valueOf(synPersonBean.getOrderField()));
        }
        return list;
    }

    public List<SynDepartment> querySynDep(SynQueryParamBean synQueryParamBean, Page page) throws Exception {
        List<Department> list = this.addressBookSynchronizeDao.getListByDep(synQueryParamBean, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synDep.setDisplay_flag(dep.getDisplayState());
            synlist.add(synDep);
        }
        return synlist;
    }

    public SynRst getAddressBookCheck(SynQueryParamBean param) throws Exception {
        SynRst synRst = new SynRst();
        ArrayList<AddressBookCheckBean> AddressBookCheckBeanList = new ArrayList<AddressBookCheckBean>();
        AddressBookCheckBean addressBookCheckBean = new AddressBookCheckBean();
        List<String> addressBook = this.addressBookSynchronizeDao.getAddressBookCheck(param);
        if (null != addressBook && addressBook.size() > 0) {
            addressBookCheckBean.setPersonCount(addressBook.toArray()[0].toString());
            addressBookCheckBean.setDepCount(addressBook.toArray()[1].toString());
            if (null != addressBook.toArray()[2]) {
                addressBookCheckBean.setMaxUpdateTime(addressBook.toArray()[2].toString());
            } else {
                addressBookCheckBean.setMaxUpdateTime(param.getStartTime());
            }
            AddressBookCheckBeanList.add(addressBookCheckBean);
        }
        synRst.setList(AddressBookCheckBeanList);
        synRst.setCount(AddressBookCheckBeanList.size());
        synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        return synRst;
    }

    public SynRst updatePersonTime(SynQueryParamBean param) throws Exception {
        SynRst synRst = new SynRst();
        if (StringUtils.isNotBlank((CharSequence)param.getId())) {
            this.addressBookSynchronizeDao.updatePersonTime(param);
            synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        }
        return synRst;
    }

    @Override
    public Rule getRule(String id) throws Exception {
        return this.addressBookSynchronizeDao.getRule(id);
    }

    @Override
    public void addAndUpdateRule(Rule rule) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)rule.getId())) {
            this.addressBookSynchronizeDao.updateRule(rule);
        } else {
            this.addressBookSynchronizeDao.addRule(rule);
        }
    }

    @Override
    public List<Rule> queryRuleListBySql() throws Exception {
        return this.addressBookSynchronizeDao.queryRuleListBySql("from Rule");
    }

    @Override
    public List<Rule> queryRuleListByCode(String code) throws Exception {
        String[] values = new String[]{code};
        return this.addressBookSynchronizeDao.queryRuleListBySql("from Rule where code = ?", values);
    }

    @Override
    public List<Department> getHLDep(String depId) throws Exception {
        return this.depManageService.getHLDep(depId);
    }

    @Override
    @Transactional
    public void saveOrUpdatePersonImage(PersonImage personImage) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)personImage.getPersonId())) {
            List<PersonImage> list = this.addressBookSynchronizeDao.getPersonImage(personImage.getPersonId());
            if (null != list && list.size() > 0) {
                PersonImage getPersonImage = list.get(0);
                getPersonImage.setTimestamp(System.currentTimeMillis());
                getPersonImage.setOldImgSummary(getPersonImage.getImgSummary());
                getPersonImage.setImgSummary(personImage.getImgSummary());
                this.addressBookSynchronizeDao.updatePersonImage(getPersonImage);
            } else {
                this.addressBookSynchronizeDao.addPersonImage(personImage);
            }
            Person oldInfo = this.personDao.queryPersonById(personImage.getPersonId());
            PersonUpdated personUpdated = new PersonUpdated();
            personUpdated.setCode(oldInfo.getCode());
            personUpdated.setName(oldInfo.getName());
            personUpdated.setIdentifier(oldInfo.getIdentifier());
            personUpdated.setDepName(oldInfo.getDepartment().getName());
            personUpdated.setDepCode(oldInfo.getDepartment().getCode());
            personUpdated.setDepartmnetId(oldInfo.getDepartment().getId());
            personUpdated.setEditorId(personImage.getPersonId());
            personUpdated.setMobile(oldInfo.getMobile());
            personUpdated.setOrderField(oldInfo.getOrderField());
            personUpdated.setPersonId(oldInfo.getId());
            personUpdated.setPosition(oldInfo.getPosition());
            personUpdated.setSex(oldInfo.getSex());
            personUpdated.setPositionInput(oldInfo.getPositionInput());
            oldInfo.getPersonUpdatedList().add(personUpdated);
            oldInfo.setTimestamp(System.currentTimeMillis());
            this.personDao.updatePerson(oldInfo);
        }
    }

    @Override
    @Transactional
    public int updatePersonLastTimeForFirstLogin(String personId) {
        Person person = this.personDao.queryPersonById(personId);
        if (person == null) {
            log.error((Object)("updatePersonLastTimeForFirstLogin\u65b9\u6cd5\u672a\u52a0\u8f7d\u5230\u4eba\u5458,personId\u4e3a\uff1a" + personId));
            return 0;
        }
        PersonUpdated personUpdated = new PersonUpdated();
        personUpdated.setCode(person.getCode());
        personUpdated.setName(person.getName());
        personUpdated.setIdentifier(person.getIdentifier());
        personUpdated.setDepName(person.getDepartment().getName());
        personUpdated.setDepCode(person.getDepartment().getCode());
        personUpdated.setDepartmnetId(person.getDepartment().getId());
        personUpdated.setEditorId(personId);
        personUpdated.setMobile(person.getMobile());
        personUpdated.setOrderField(person.getOrderField());
        personUpdated.setPersonId(person.getId());
        personUpdated.setPosition(person.getPosition());
        personUpdated.setSex(person.getSex());
        personUpdated.setPositionInput(person.getPositionInput());
        person.getPersonUpdatedList().add(personUpdated);
        person.setTimestamp(System.currentTimeMillis());
        this.personDao.updatePerson(person);
        return 1;
    }

    @Override
    @Transactional
    public Result updatePersonOfficePhone(UpdatePersonalMobileParam param) {
        Person oldInfo = this.userManageService.queryPersonById(param.getPersonId());
        if (oldInfo == null) {
            return new Result("1", "\u7528\u6237ID[" + param.getPersonId() + "]\u4e0d\u5b58\u5728");
        }
        PersonUpdated personUpdated = new PersonUpdated();
        personUpdated.setCode(oldInfo.getCode());
        personUpdated.setName(oldInfo.getName());
        personUpdated.setIdentifier(oldInfo.getIdentifier());
        personUpdated.setDepName(oldInfo.getDepartment().getName());
        personUpdated.setDepCode(oldInfo.getDepartment().getCode());
        personUpdated.setDepartmnetId(oldInfo.getDepartment().getId());
        personUpdated.setEditorId(oldInfo.getId());
        personUpdated.setMobile(oldInfo.getMobile());
        personUpdated.setOrderField(oldInfo.getOrderField());
        personUpdated.setPersonId(oldInfo.getId());
        personUpdated.setPosition(oldInfo.getPosition());
        personUpdated.setSex(oldInfo.getSex());
        personUpdated.setPersonType(oldInfo.getPersonType());
        personUpdated.setMobileMultimediaMessage(oldInfo.getMobileMultimediaMessage());
        personUpdated.setMobilePersonal(oldInfo.getMobilePersonal());
        oldInfo.getPersonUpdatedList().add(personUpdated);
        oldInfo.setOfficePhone(param.getNewMobile());
        this.userManageService.updateUser(oldInfo);
        return new Result("0", MessageManager.getProMessage(this.message, "common.message.operate.success"));
    }
}

