/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.jingxin.jxgl.bean.ColumnBean;
import pams.function.jingxin.jxgl.bean.ColumnGrabConfigBean;
import pams.function.jingxin.jxgl.bean.ColumnListBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.service.JxColumnService;
import pams.function.jingxin.jxgl.service.impl.JxFileUploadServiceImpl;

@Controller
@Scope(value="session")
public class JxColumnControl
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private JxColumnService jxColumnService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(JxColumnControl.class);

    @RequestMapping(value={"/jxgl/JxColumnControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String url = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            String rssUrl = this.scps.getValueByCode("RSS_SERVER_URL");
            url = rssUrl + "/uploadImg.do";
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"uploadImage", (Object)url);
        map.put((Object)"person", (Object)this.person);
        return sendUrl;
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/queryList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, ColumnListBean columnListBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        String returnStr = "";
        columnListBean.setPersonId(this.person.getId());
        try {
            resBean = this.jxColumnService.queryList(columnListBean, page);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
                returnStr = resBean.getResult().getResultStatus().equals("0") || returnJson.toString().indexOf("total=0") > 0 ? "{\"rows\":[],\"total\":\"0\"}" : Util.toJsonStr(returnJson);
            }
        }
        catch (Exception e2) {
            returnStr = "{\"rows\":[],\"total\":\"0\"}";
            operateResult = 0;
            log.error("\u83b7\u53d6\u8b66\u4fe1\u5206\u7c7b\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, returnStr);
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/addColumn.do"})
    public String addColumn(String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response, String id, String personId) {
        map.put((Object)"personId", (Object)personId);
        return "jxgl/jxColumn/default/addCoulumn";
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/saveColumn.do"})
    public void saveColumn(ColumnBean columnBean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            String strChannelId = columnBean.getChannelId();
            strChannelId = strChannelId.substring(0, strChannelId.length() - 1);
            columnBean.setChannelId(strChannelId);
            columnBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxColumnService.saveColumn(columnBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    private ReturnResult checkColumnImg(MultipartFile img, ColumnBean columnBean) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        if (img == null || columnBean == null || columnBean.getImgUUID() == null || columnBean.getImgUUID().length() == 0) {
            return rtnResult;
        }
        long fileSize = img.getSize() / 1024L;
        BufferedImage sourceImg = ImageIO.read(img.getInputStream());
        int width = sourceImg.getWidth();
        int height = sourceImg.getHeight();
        if (fileSize > 300L) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u56fe\u7247\u5927\u5c0f\u4e3a" + fileSize + "kb\uff0c\u8d85\u8fc7\u7cfb\u7edf\u6700\u5927\u503c\u9650\u5236");
        } else if (width > 240 || width < 200 || height > 240 || height < 200) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u8bf7\u9009\u62e9\u957f\u3001\u5bbd\u50cf\u7d20\u9650\u5236\u5728200\u5230240\u4e4b\u95f4\u7684\u56fe\u7247");
        }
        return rtnResult;
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/getColumnDetail.do"})
    public String getColumnDetail(String columnId, String type, ModelMap map, HttpServletResponse response, HttpServletRequest request) {
        ColumnBean columnBean = new ColumnBean();
        columnBean.setId(columnId);
        columnBean.setPersonId(this.person.getId());
        ColumnBean columnBeanResult = new ColumnBean();
        try {
            columnBeanResult = this.jxColumnService.getColumnDetail(columnBean);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        map.put((Object)"columnBean", (Object)columnBeanResult);
        map.put((Object)"personId", (Object)this.person.getId());
        if (type.equals("detail")) {
            return "jxgl/jxColumn/default/detailCoulumn";
        }
        return "jxgl/jxColumn/default/editCoulumn";
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/getColumnConfigInfoById.do"})
    public String getColumnConfigInfo(ModelMap map, HttpServletRequest request, HttpServletResponse response, String id) {
        ColumnGrabConfigBean cgcBean = new ColumnGrabConfigBean();
        if (!Util.varCheckEmp(id)) {
            try {
                ColumnGrabConfigBean cgcb = new ColumnGrabConfigBean();
                cgcb.setColumnId(Long.parseLong(id));
                cgcb.setPersonId(this.person.getId());
                cgcBean = this.jxColumnService.getColumnGrabConfigById(cgcb);
            }
            catch (Exception e2) {
                log.error("\u6839\u636eID\u83b7\u53d6\u680f\u76ee\u6293\u53d6\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e2);
            }
        }
        map.put((Object)"cgcBean", (Object)cgcBean);
        return "jxgl/jxColumn/default/grabConfig";
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/updateColumnConfigInfo.do"})
    public void updateColumnConfigInfo(ColumnGrabConfigBean cgcBean, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        cgcBean.setPersonId(this.person.getId());
        try {
            ResBean resBean = this.jxColumnService.updateColumnGrabConfig(cgcBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/updateColumn.do"})
    public void updateColumn(@RequestParam(value="img", required=false) MultipartFile img, ColumnBean columnBean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            columnBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxColumnService.updateColumn(columnBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/queryColumnListForSelect.do"})
    public void queryColumnListForSelect(HttpServletRequest request, HttpServletResponse response, ColumnListBean columnListBean, PageParam page, Integer newsSourceType) {
        if (columnListBean == null) {
            columnListBean = new ColumnListBean();
            columnListBean.setChannelId("0");
        }
        if (newsSourceType == null) {
            newsSourceType = 0;
        }
        columnListBean.setStatus("1");
        String jsonlist = "";
        List<Object> listmap = new ArrayList();
        try {
            listmap = this.jxColumnService.queryColumnListForSelect(columnListBean, page, newsSourceType);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + this.person.getId() + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        jsonlist = Util.toJsonStr(listmap);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/startColumn.do"})
    public void startColumn(ModelMap map, HttpServletRequest request, HttpServletResponse response, ColumnBean columnBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            columnBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxColumnService.startColumn(columnBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u542f\u7528\u8b66\u4fe1\u680f\u76ee\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/stopColumn.do"})
    public void stopColumn(ModelMap map, HttpServletRequest request, HttpServletResponse response, ColumnBean columnBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            columnBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxColumnService.stopColumn(columnBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u505c\u7528\u8b66\u4fe1\u680f\u76ee\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxColumnControl/uploadImg.do"})
    public void uploadImg(@RequestParam MultipartFile img, ColumnBean columnBean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 1;
        String ret = "";
        try {
            ReturnResult rtnResult = this.checkColumnImg(img, columnBean);
            if (rtnResult.getRtnMsg() == null || rtnResult.getRtnMsg().length() == 0) {
                String url = this.scps.getValueByCode("RSS_SERVER_URL") + "/uploadImg.do";
                log.info("\u8ba2\u9605\u4e2d\u5fc3\u680f\u76ee\u56fe\u7247\u4e0a\u4f20\u5730\u5740\u4e3a\uff1a" + url);
                JxFileUploadServiceImpl jxFileUploadServiceImpl = new JxFileUploadServiceImpl(url);
                jxFileUploadServiceImpl.addFileParameter("img", img);
                jxFileUploadServiceImpl.addTextParameter("type", "2");
                jxFileUploadServiceImpl.addTextParameter("username", this.person.getId());
                jxFileUploadServiceImpl.addTextParameter("secret", "111111");
                ret = jxFileUploadServiceImpl.send();
            } else {
                ret = "{\"imgUrl\" : \"\",\"message\" : \"" + rtnResult.getRtnMsg() + "\", \"imgUUID\" : \"\" , \"success\" : false}";
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            ret = "{\"imgUrl\" : \"\",\"message\" : " + e2.getMessage() + ", \"imgUUID\" : \"\" , \"success\" : false}";
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text1(response, ret);
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }
}

