/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.jingxin.jxgl.bean.InformationBean;
import pams.function.jingxin.jxgl.bean.InformationListBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.bean.ResponseInformationBean;
import pams.function.jingxin.jxgl.service.JxInformationService;

@Controller
@Scope(value="session")
public class JxInformationControl
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private JxInformationService jxInformationService;
    private static final Logger log = LoggerFactory.getLogger(JxInformationControl.class);

    @RequestMapping(value={"/jxgl/JxInformation/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person", (Object)this.person);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/jxgl/JxInformation/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, InformationListBean informationListBean, String startDate, String endDate) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            if (informationListBean == null) {
                informationListBean = new InformationListBean();
            }
            if (informationListBean.getChannelId() == null) {
                informationListBean.setChannelId(0L);
            }
            if (informationListBean.getColumnId() == null) {
                informationListBean.setColumnId(0L);
            }
            if (informationListBean.getStatus() == null) {
                informationListBean.setStatus(0);
            }
            if (StringUtils.isNotBlank((CharSequence)startDate)) {
                informationListBean.setPublishTimeStart(Util.parseDate(startDate).getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                informationListBean.setPublishTimeEnd(Util.relationDate(Util.parseDate(endDate), 1).getTime());
            }
            informationListBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.queryList(informationListBean, page);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            HashMap<String, Serializable> rst = new HashMap<String, Serializable>();
            rst.put("total", Integer.valueOf(0));
            rst.put("rows", new ArrayList());
            returnJson = rst;
            operateResult = 0;
            log.error("\u83b7\u53d6\u8b66\u4fe1\u5206\u7c7b\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(returnJson));
    }

    @RequestMapping(value={"/jxgl/JxInformation/toEditOrAddInformation.do"})
    public String toEditOrAddEdifice(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        if (id == null || id.length() == 0) {
            id = "0";
        }
        map.put((Object)"informationId", (Object)id);
        map.put((Object)"person", (Object)this.person);
        return "jxgl/jxInformation/default/addOrEdit";
    }

    @RequestMapping(value={"/jxgl/JxInformation/addInformation.do"})
    public void addInformation(HttpServletRequest request, HttpServletResponse response, InformationBean informationBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            informationBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.addInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u589e\u52a0\u8b66\u4fe1\u8d44\u8baf\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(returnJson));
    }

    @RequestMapping(value={"/jxgl/JxInformation/viewInformation.do"})
    public void viewInformation(HttpServletRequest request, HttpServletResponse response, InformationBean informationBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            informationBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.viewInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u8b66\u4fe1\u8d44\u8baf\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        if (returnJson == null) {
            returnJson = "";
        }
        Util.writeUtf8Text(response, returnJson.toString());
    }

    @RequestMapping(value={"/jxgl/JxInformation/editInformation.do"})
    public void editInformation(HttpServletRequest request, HttpServletResponse response, InformationBean informationBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            informationBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.editInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u4fee\u6539\u8b66\u4fe1\u8d44\u8baf\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(returnJson));
    }

    @RequestMapping(value={"/jxgl/JxInformation/delInformation.do"})
    public void delInformation(HttpServletRequest request, HttpServletResponse response, InformationBean informationBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            informationBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.delInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u5220\u9664\u8b66\u4fe1\u8d44\u8baf\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(returnJson));
    }

    @RequestMapping(value={"/jxgl/JxInformation/publishInformation.do"})
    public void publishInformation(HttpServletRequest request, HttpServletResponse response, InformationBean informationBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        try {
            informationBean.setPersonId(this.person.getId());
            resBean = this.jxInformationService.publishInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u53d1\u5e03\u8b66\u4fe1\u8d44\u8baf\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(returnJson));
    }

    @RequestMapping(value={"/jxgl/JxInformation/getPreView.do"})
    public String getPreview(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 1;
        InformationBean informationBean = new InformationBean();
        informationBean.setId(Long.parseLong(id));
        informationBean.setPersonId(this.person.getId());
        ResBean resBean = null;
        Object returnJson = null;
        try {
            resBean = this.jxInformationService.viewInformation(informationBean);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
            }
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error("\u8b66\u4fe1\u8d44\u8baf\u9884\u89c8\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        if (returnJson == null) {
            map.put((Object)"title", (Object)"");
            map.put((Object)"publishTime", (Object)"");
            map.put((Object)"author", (Object)"");
            map.put((Object)"content", (Object)"");
        } else {
            String resStr = returnJson.toString();
            ResponseInformationBean rib = Util.readValue(resStr, ResponseInformationBean.class);
            map.put((Object)"title", (Object)rib.getResult().getTitle());
            map.put((Object)"publishTime", (Object)Util.getStrDate(rib.getResult().getCreateTime()));
            map.put((Object)"author", (Object)rib.getResult().getAuthor());
            map.put((Object)"content", (Object)rib.getResult().getContent());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        return "jxgl/jxInformation/default/preView";
    }
}

