/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.FileAgentUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.jingxin.jxgl.bean.JxServiceNoBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoListBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoReportListBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoReqBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoRspBean;
import pams.function.jingxin.jxgl.service.JxServiceNoService;

@Controller
@Scope(value="session")
public class JxServiceNoController
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private JxServiceNoService jxServiceNoService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private UserManageService userManageService;
    private static final Logger log = LoggerFactory.getLogger(JxServiceNoController.class);

    @RequestMapping(value={"/jxgl/JxServiceNoController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.operator = (Operator)request.getSession().getAttribute("operator");
            map.put((Object)"personId", (Object)this.operator.getPerson().getId());
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String rows, JxServiceNoReqBean reqBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            reqBean.setCount(rows);
            JxServiceNoListBean listBean = this.jxServiceNoService.queryJxServiceNoList(reqBean);
            result.put("total", listBean.getRecordCount());
            result.put("rows", listBean.getData());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/queryReport.do"})
    public void queryReport(HttpServletRequest request, HttpServletResponse response, ModelMap map, String rows, JxServiceNoReqBean reqBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            reqBean.setCount(rows);
            JxServiceNoReportListBean listBean = this.jxServiceNoService.queryJxServiceNoReportList(reqBean);
            result.put("total", listBean.getRecordCount());
            result.put("rows", listBean.getData());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/expReport.do"})
    public void expReport(HttpServletRequest request, HttpServletResponse response, ModelMap map, String rows, JxServiceNoReqBean reqBean) {
        HashMap result = new HashMap();
        try {
            reqBean.setCount(rows);
            InputStream in = this.jxServiceNoService.expJxServiceNoReport(reqBean);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=report.xls");
            ServletOutputStream os = response.getOutputStream();
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = in.read(b)) > 0) {
                os.write(b, 0, i);
            }
            os.flush();
            os.close();
            in.close();
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/toDetail.do"})
    public String toDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, String serviceId) {
        try {
            JxServiceNoBean serviceNo = this.jxServiceNoService.queryJxServiceNoById(serviceId);
            map.put((Object)"serviceNo", (Object)serviceNo);
            String jxspUrl = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
            map.put((Object)"jxspUrl", (Object)jxspUrl);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "jxgl/serviceNO/default/detail";
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/toEdit.do"})
    public String toEdit(HttpServletRequest request, HttpServletResponse response, ModelMap map, String serviceId) {
        try {
            JxServiceNoBean serviceNo = this.jxServiceNoService.queryJxServiceNoById(serviceId);
            map.put((Object)"serviceNo", (Object)serviceNo);
            String fileId = FileAgentUtils.generateFileId();
            map.put((Object)"fileId", (Object)fileId);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "jxgl/serviceNO/default/edit";
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/toAdd.do"})
    public String toAdd(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        try {
            String fileId = FileAgentUtils.generateFileId();
            map.put((Object)"fileId", (Object)fileId);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "jxgl/serviceNO/default/add";
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/checkProviderName.do"})
    public String checkProviderName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String providerName) {
        try {
            this.jxServiceNoService.checkJxServiceNoName(providerName);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "jxgl/serviceNO/default/add";
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/add.do"})
    public void add(HttpServletRequest request, HttpServletResponse response, ModelMap map, JxServiceNoReqBean reqBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            reqBean.setThumbnailId(reqBean.getAvatarId());
            boolean hasName = this.jxServiceNoService.checkJxServiceNoName(reqBean.getName());
            if (hasName) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u670d\u52a1\u53f7\u540d\u79f0\u5df2\u5b58\u5728");
            } else {
                JxServiceNoRspBean rsp = this.jxServiceNoService.createJxServiceNo(reqBean);
                if ("0".equals(rsp.getStatus())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + rsp.getMessage());
                } else {
                    rtnResult.setRtnCode("0");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/edit.do"})
    public void edit(HttpServletRequest request, HttpServletResponse response, ModelMap map, JxServiceNoReqBean reqBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            boolean hasName = this.jxServiceNoService.checkJxServiceNoName(reqBean.getName(), reqBean.getServiceId());
            if (hasName) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + "\u670d\u52a1\u53f7\u540d\u79f0\u5df2\u5b58\u5728");
            } else {
                JxServiceNoRspBean rsp = this.jxServiceNoService.updateJxServiceNo(reqBean);
                if ("0".equals(rsp.getStatus())) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + rsp.getMessage());
                } else {
                    rtnResult.setRtnCode("0");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/updateStatus.do"})
    public void updateStatus(HttpServletRequest request, HttpServletResponse response, ModelMap map, JxServiceNoReqBean reqBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            JxServiceNoRspBean rst = this.jxServiceNoService.updateJxServiceNoState(reqBean.getServiceId(), reqBean.getStatus());
            if ("1".equals(rst.getStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/uploadAvatar.do"})
    public void uploadAvatar(@RequestParam MultipartFile file, String fileId, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String pubUrl = this.systemConfigService.getValueByCode("FILE_AGENT_URL");
            long size = file.getSize();
            if (size > 0x100000L) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u4e0a\u4f20\u56fe\u7247\u8fc7\u5927\uff0c\u4e0d\u80fd\u8d85\u8fc71MB");
                Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
                return;
            }
            ByteArrayOutputStream outIS = new ByteArrayOutputStream();
            boolean b = JxServiceNoController.compressCutPic(file, outIS, 0, 0, 216, 216);
            if (!b) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u4e0a\u4f20\u56fe\u7247\u526a\u88c1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(outIS.toByteArray());
            FileAgentUtils fileAgentUtils = new FileAgentUtils();
            fileAgentUtils.uploadToFileAgent(is, file.getOriginalFilename(), fileId, pubUrl);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressCutPic(MultipartFile file, ByteArrayOutputStream outIS, int x, int y, int width, int height) {
        InputStream is = null;
        ImageInputStream iis = null;
        try {
            double rate2;
            String srcFile = file.getOriginalFilename();
            String ext = srcFile.substring(srcFile.lastIndexOf(".") + 1);
            BufferedImage img = ImageIO.read(file.getInputStream());
            if (((Image)img).getWidth(null) == -1) {
                boolean bl = false;
                return bl;
            }
            double rate1 = (double)((Image)img).getWidth(null) / (double)width + 0.1;
            double rate = rate1 > (rate2 = (double)((Image)img).getHeight(null) / (double)height + 0.1) ? rate2 : rate1;
            int newWidth = (int)((double)((Image)img).getWidth(null) / rate);
            int newHeight = (int)((double)((Image)img).getHeight(null) / rate);
            BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
            tag.getGraphics().drawImage(img.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)tag, ext, out);
            is = new ByteArrayInputStream(out.toByteArray());
            out.close();
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(ext);
            ImageReader reader = it.next();
            iis = ImageIO.createImageInputStream(is);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, ext, outIS);
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (iis != null) {
                    iis.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
                return false;
            }
        }
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/downloadAvatar.do"})
    public void downloadAvatar(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response, String fileId) {
        HashMap result = new HashMap();
        try {
            String pubUrl = this.systemConfigService.getValueByCode("FILE_AGENT_URL");
            FileAgentUtils fileAgentUtils = new FileAgentUtils();
            byte[] imgByteArr = fileAgentUtils.downloadFromFileAgent(fileId, pubUrl);
            ServletOutputStream os = response.getOutputStream();
            os.write(imgByteArr);
            os.flush();
            os.close();
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/forwardPersonSelectPage.do"})
    public void forwardPersonRolePage(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember1.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
    }

    @RequestMapping(value={"/jxgl/JxServiceNoController/forwardManagerSelectPage.do"})
    public void forwardManagerSelectPage(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response, String personId) {
        try {
            ArrayList<Person> personlist = new ArrayList<Person>();
            if (StringUtils.isNotBlank((CharSequence)personId)) {
                Person person = this.userManageService.queryPersonById(personId);
                personlist.add(person);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMemberDepPerson.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
        }
    }
}

