/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.jingxin.jxgl.bean.ChannelDetailAndSubRelationBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.bean.TypeBean;
import pams.function.jingxin.jxgl.service.JxTypeService;

@Controller
@Scope(value="session")
public class JxTypeControl
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private JxTypeService jxTypeService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(JxTypeControl.class);

    @RequestMapping(value={"/jxgl/JxTypeControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.operator = (Operator)request.getSession().getAttribute("operator");
            map.put((Object)"personId", (Object)this.operator.getPerson().getId());
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/queryList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, TypeBean typeBean) {
        int operateResult = 1;
        ResBean resBean = null;
        Object returnJson = null;
        typeBean.setPersonId(this.person.getId());
        typeBean.setStatus("0");
        String returnStr = "";
        try {
            resBean = this.jxTypeService.queryList(typeBean, page);
            if (null != resBean) {
                returnJson = resBean.getResult().getInfo();
                returnStr = resBean.getResult().getResultStatus().equals("0") ? "{\"rows\":[],\"total\":\"0\"}" : Util.toJsonStr(returnJson);
            }
        }
        catch (Exception e2) {
            returnStr = "{\"rows\":[],\"total\":\"0\"}";
            operateResult = 0;
            log.error("\u83b7\u53d6\u8b66\u4fe1\u5206\u7c7b\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, returnStr);
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/addAndEditWeb.do"})
    public String addAndEditWeb(String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response, String id) {
        TypeBean typeBean = new TypeBean();
        typeBean.setPersonId(this.person.getId());
        ChannelDetailAndSubRelationBean channelDetailAndSubRelationBean = new ChannelDetailAndSubRelationBean();
        typeBean.setId(id);
        String depIds = "";
        if (!Util.varCheckEmp(id)) {
            try {
                channelDetailAndSubRelationBean = this.jxTypeService.getTypeDetail(typeBean);
                List<String> depIdList = channelDetailAndSubRelationBean.getSubscribers();
                typeBean = channelDetailAndSubRelationBean.getChannelBean();
                if (null != depIdList) {
                    for (String depId : depIdList) {
                        depIds = depIds + depId + ",";
                    }
                    if (depIds.length() > 0) {
                        depIds = depIds.substring(0, depIds.length() - 1);
                    }
                }
            }
            catch (Exception e2) {
                log.error("\u6dfb\u52a0\u4fee\u6539\u8b66\u4fe1\u5206\u7c7b\u9875\u9762\u5f02\u5e38", (Throwable)e2);
            }
        }
        map.put((Object)"typeBean", (Object)typeBean);
        map.put((Object)"depIds", (Object)depIds);
        return "jxgl/jxType/default/addAndEditWeb";
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/saveAddJxType.do"})
    public void saveAddJxType(ModelMap map, HttpServletRequest request, HttpServletResponse response, TypeBean typeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            typeBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxTypeService.addType(typeBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u8b66\u4fe1\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/startJxType.do"})
    public void startJxType(ModelMap map, HttpServletRequest request, HttpServletResponse response, TypeBean typeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            typeBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxTypeService.startType(typeBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u542f\u7528\u8b66\u4fe1\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/stopJxType.do"})
    public void stopJxType(ModelMap map, HttpServletRequest request, HttpServletResponse response, TypeBean typeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            typeBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxTypeService.stopType(typeBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u505c\u7528\u8b66\u4fe1\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/updateJxType.do"})
    public void updateJxType(ModelMap map, HttpServletRequest request, HttpServletResponse response, TypeBean typeBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            typeBean.setPersonId(this.person.getId());
            ResBean resBean = this.jxTypeService.updateType(typeBean);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u8b66\u4fe1\u5206\u7c7b\u5f02\u5e38", (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/queryTypeListForSelect.do"})
    public void queryTypeListForSelect(HttpServletRequest request, HttpServletResponse response, String personId, PageParam page) {
        TypeBean typeBean = new TypeBean();
        typeBean.setPersonId(personId);
        typeBean.setStatus("1");
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.jxTypeService.queryTypeListForSelect(typeBean);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + this.person.getId() + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/toSelectPersonPage.do"})
    public void toSelectPersonPage(HttpServletRequest request, HttpServletResponse response, String typeId) {
        try {
            List<Person> list = this.jxTypeService.queryTypeManagerPersonList(typeId, this.person.getId());
            request.setAttribute("personList", list);
            request.setAttribute("filterPersonIds", (Object)this.person.getId());
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5206\u7c7b\u7ba1\u7406\u5458\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
        }
    }

    @RequestMapping(value={"/jxgl/JxTypeControl/saveTypeManaget.do"})
    public void saveTypeManaget(HttpServletRequest request, HttpServletResponse response, String typeId, String managerIds) {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = false;
        try {
            ResBean resBean = this.jxTypeService.saveTypeManager(typeId, this.person.getId(), managerIds);
            if ("1".equals(resBean.getResult().getResultStatus())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = true;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(resBean.getResult().getInfo().toString());
            }
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58\u5206\u7c7b\u7ba1\u7406\u5458\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u4fdd\u5b58\u5206\u7c7b\u7ba1\u7406\u5458\u5931\u8d25!");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }
}

