/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.service.impl;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pams.function.jingxin.jxgl.bean.ColumnBean;
import pams.function.jingxin.jxgl.bean.ColumnGrabConfigBean;
import pams.function.jingxin.jxgl.bean.ColumnListBean;
import pams.function.jingxin.jxgl.bean.PageList;
import pams.function.jingxin.jxgl.bean.ReqBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.service.JxColumnService;

@Service
public class JxColumnServiceImpl
implements JxColumnService {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    SystemConfigService systemConfigService;

    @Override
    public ResBean queryList(ColumnListBean columnListBean, PageParam page) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "QueryColumnList";
        ReqBean reqBean = new ReqBean();
        columnListBean.setCurPageNo(page.getPage());
        columnListBean.setPageSize(page.getRows());
        reqBean.setMethod(method);
        reqBean.setParams(columnListBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean saveColumn(ColumnBean columnBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod("addColumn");
        reqBean.setParams(columnBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ColumnBean getColumnDetail(ColumnBean columnBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod("queryColumnDetail");
        reqBean.setParams(columnBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        String resStr = Util.toJsonStr(returnJson);
        ColumnBean returnColumnBean = Util.readValue(resStr, ColumnBean.class);
        return returnColumnBean;
    }

    @Override
    public ColumnGrabConfigBean getColumnGrabConfigById(ColumnGrabConfigBean cgcb) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "GetColumnGrabConfigById";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(cgcb);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = httpRequestUtil.postJson(url, param);
        ResBean resBean = Util.readValue(result, ResBean.class);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        String resStr = Util.toJsonStr(returnJson);
        ColumnGrabConfigBean cgcBean = Util.readValue(resStr, ColumnGrabConfigBean.class);
        return cgcBean;
    }

    @Override
    public ResBean updateColumnGrabConfig(ColumnGrabConfigBean cgcBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "UpdateColumnGrabConfig";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(cgcBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean updateColumn(ColumnBean columnBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "UpdateColumn";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(columnBean);
        String params = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, params), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public List<Map<String, Object>> queryColumnListForSelect(ColumnListBean columnListBean, PageParam page, int newsSourceType) throws Exception {
        String resStr;
        PageList pageList;
        List columnBeanList;
        if (page == null) {
            page = new PageParam();
            page.setPage("1");
            page.setRows("50");
        }
        columnListBean.setPersonId(columnListBean.getPersonId());
        ResBean resBean = this.queryList(columnListBean, page);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("code", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        if (Long.parseLong(columnListBean.getChannelId()) > 0L && !CollectionUtils.isEmpty(columnBeanList = (pageList = (PageList)Util.readValue(resStr = Util.toJsonStr(returnJson), PageList.class, ColumnListBean.class)).getRows())) {
            for (ColumnListBean columnBeanSelect : columnBeanList) {
                if (newsSourceType != 0 && Integer.parseInt(columnBeanSelect.getNewsSourceType()) != newsSourceType) continue;
                HashMap<String, String> typMap = new HashMap<String, String>();
                typMap.put("code", columnBeanSelect.getId());
                typMap.put("name", columnBeanSelect.getName());
                listmap.add(typMap);
            }
        }
        return listmap;
    }

    @Override
    public ResBean startColumn(ColumnBean columnBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "StartColumn";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(columnBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean stopColumn(ColumnBean columnBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "StopColumn";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(columnBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }
}

