/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class JxFileUploadServiceImpl {
    URL url;
    HttpURLConnection conn;
    String boundary = "--------httppost123";
    Map<String, String> textParams = new HashMap<String, String>();
    Map<String, MultipartFile> fileparams = new HashMap<String, MultipartFile>();
    DataOutputStream ds;
    private static final Logger log = LoggerFactory.getLogger(JxFileUploadServiceImpl.class);

    public JxFileUploadServiceImpl(String url) throws Exception {
        this.url = new URL(url);
    }

    public void setUrl(String url) throws Exception {
        this.url = new URL(url);
    }

    public void addTextParameter(String name, String value) {
        this.textParams.put(name, value);
    }

    public void addFileParameter(String name, MultipartFile value) {
        this.fileparams.put(name, value);
    }

    public void clearAllParameters() {
        this.textParams.clear();
        this.fileparams.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send() throws Exception {
        this.initConnection();
        try {
            this.conn.connect();
        }
        catch (SocketTimeoutException e2) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u8fde\u63a5\u5931\u8d25");
            throw new RuntimeException();
        }
        String ret = null;
        try {
            int b;
            this.ds = new DataOutputStream(this.conn.getOutputStream());
            this.writeFileParams();
            this.writeStringParams();
            this.paramsEnd();
            InputStream in = this.conn.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            ret = new String(out.toByteArray());
        }
        catch (Exception e3) {
            ret = "{\"imgUrl\" : \"\",\"message\" : \"" + e3.getMessage() + "\", \"imgUUID\" : \"\" , \"success\" : false}";
            log.error("\u4e0a\u4f20 \u5931\u8d25");
        }
        finally {
            this.conn.disconnect();
        }
        return ret;
    }

    private void initConnection() throws Exception {
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setConnectTimeout(10000);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    private void writeStringParams() throws Exception {
        Set<String> keySet = this.textParams.keySet();
        for (String name : keySet) {
            String value = this.textParams.get(name);
            this.ds.writeBytes("--" + this.boundary + "\r\n");
            this.ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
            this.ds.writeBytes("\r\n");
            this.ds.writeBytes(this.encode(value) + "\r\n");
        }
    }

    private void writeFileParams() throws Exception {
        Set<String> keySet = this.fileparams.keySet();
        for (String name : keySet) {
            MultipartFile value = this.fileparams.get(name);
            String fileName = value.getOriginalFilename();
            String suffixName = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            this.ds.writeBytes("--" + this.boundary + "\r\n");
            this.ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + this.encode(fileName) + "\"\r\n");
            this.ds.writeBytes("Content-Type: image/" + suffixName + "\r\n");
            this.ds.writeBytes("\r\n");
            this.ds.write(value.getBytes());
            this.ds.writeBytes("\r\n");
        }
    }

    private void paramsEnd() throws Exception {
        this.ds.writeBytes("--" + this.boundary + "--" + "\r\n");
        this.ds.writeBytes("\r\n");
    }

    private String encode(String value) throws Exception {
        return URLEncoder.encode(value, "UTF-8");
    }
}

