/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.service.impl;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxgl.bean.InformationBean;
import pams.function.jingxin.jxgl.bean.InformationListBean;
import pams.function.jingxin.jxgl.bean.ReqBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.service.JxInformationService;

@Service
public class JxInformationServiceImpl
implements JxInformationService {
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public ResBean queryList(InformationListBean informationListBean, PageParam page) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "QueryInformationList";
        ReqBean reqBean = new ReqBean();
        informationListBean.setCurPageNo(page.getPage());
        informationListBean.setPageSize(page.getRows());
        reqBean.setMethod(method);
        reqBean.setParams(informationListBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean addInformation(InformationBean informationBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "AddInformation";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(informationBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean viewInformation(InformationBean informationBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "ViewInformation";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("articleId", informationBean.getId());
        params.put("personId", informationBean.getPersonId());
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String jxResult = httpRequestUtil.postJson(url, param);
        jxResult = jxResult.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
        String result = URLDecoder.decode(jxResult, "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean editInformation(InformationBean informationBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "EditInformation";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(informationBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean delInformation(InformationBean informationBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "DelInformation";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("articleId", informationBean.getId());
        params.put("personId", informationBean.getPersonId());
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean publishInformation(InformationBean informationBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "PublishInformation";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("articleId", informationBean.getId());
        params.put("personId", informationBean.getPersonId());
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }
}

