/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxgl.bean.JxServiceNoBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoListBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoReportListBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoReqBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoRspBean;
import pams.function.jingxin.jxgl.service.JxServiceNoService;

@Service
public class JxServiceNoServiceImpl
implements JxServiceNoService {
    private static final Logger log = LoggerFactory.getLogger(JxServiceNoServiceImpl.class);
    @Autowired
    SystemConfigService systemConfigService;

    public static void main(String[] args) {
        JxServiceNoServiceImpl service = new JxServiceNoServiceImpl();
        System.out.println(Util.toJsonStr(service.queryJxServiceNoById("")));
        System.out.println(Util.toJsonStr(service.queryJxServiceNoReportList(null)));
    }

    @Override
    public JxServiceNoListBean queryJxServiceNoList(JxServiceNoReqBean reqBean) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers";
        String param = "page=" + reqBean.getPage() + "&count=" + reqBean.getCount();
        if (StringUtils.isNotBlank((CharSequence)reqBean.getProviderName())) {
            try {
                param = param + "&providerName=" + URLEncoder.encode(reqBean.getProviderName(), "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getUnitID())) {
            param = param + "&unitID=" + reqBean.getUnitID();
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getStatus())) {
            param = param + "&status=" + reqBean.getStatus();
        }
        url = url + "?" + param;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean pageBean = null;
        try {
            String result = httpRequestUtil.req(url, null, "GET");
            pageBean = (JxServiceNoRspBean)Util.readValue(result, JxServiceNoRspBean.class, JxServiceNoListBean.class);
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), (Throwable)e3);
        }
        return (JxServiceNoListBean)pageBean.getData();
    }

    @Override
    public JxServiceNoBean queryJxServiceNoById(String serviceId) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers/{serviceId}".replace("{serviceId}", serviceId);
        String param = "";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean pageBean = null;
        try {
            String result = httpRequestUtil.req(url, null, "GET");
            pageBean = (JxServiceNoRspBean)Util.readValue(result, JxServiceNoRspBean.class, JxServiceNoBean.class);
        }
        catch (Exception e2) {
            // empty catch block
        }
        return (JxServiceNoBean)pageBean.getData();
    }

    @Override
    public JxServiceNoRspBean updateJxServiceNoState(String serviceId, String state) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers/{serviceId}/status".replace("{serviceId}", serviceId);
        String param = "{\"status\":" + state + "}";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean rspBean = null;
        try {
            String result = httpRequestUtil.req(url, param, "PUT");
            rspBean = Util.readValue(result, JxServiceNoRspBean.class);
        }
        catch (UnsupportedEncodingException e2) {
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), (Throwable)e3);
        }
        return rspBean;
    }

    @Override
    public JxServiceNoRspBean updateJxServiceNo(JxServiceNoReqBean reqBean) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers/{serviceId}".replace("{serviceId}", reqBean.getServiceId());
        String param = reqBean != null ? Util.toJsonStr(reqBean) : "{}";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean rspBean = null;
        try {
            String result = httpRequestUtil.req(url, param, "PUT");
            rspBean = Util.readValue(result, JxServiceNoRspBean.class);
        }
        catch (UnsupportedEncodingException e2) {
        }
        catch (Exception e3) {
            // empty catch block
        }
        return rspBean;
    }

    @Override
    public JxServiceNoReportListBean queryJxServiceNoReportList(JxServiceNoReqBean reqBean) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers/stats";
        String param = "page=" + reqBean.getPage() + "&count=" + reqBean.getCount();
        if (StringUtils.isNotBlank((CharSequence)reqBean.getProviderName())) {
            try {
                param = param + "&providerName=" + URLEncoder.encode(reqBean.getProviderName(), "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getUnitName())) {
            try {
                param = param + "&unitName=" + URLEncoder.encode(reqBean.getUnitName(), "utf-8");
            }
            catch (UnsupportedEncodingException e3) {
                log.error(e3.getMessage(), (Throwable)e3);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getUnitID())) {
            param = param + "&unitID=" + reqBean.getUnitID();
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getStatus())) {
            param = param + "&status=" + reqBean.getStatus();
        }
        url = url + "?" + param;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean rspBean = null;
        try {
            String result = httpRequestUtil.req(url, null, "GET");
            rspBean = (JxServiceNoRspBean)Util.readValue(result, JxServiceNoRspBean.class, JxServiceNoReportListBean.class);
        }
        catch (Exception e4) {
            // empty catch block
        }
        return (JxServiceNoReportListBean)rspBean.getData();
    }

    @Override
    public InputStream expJxServiceNoReport(JxServiceNoReqBean reqBean) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers/stats/excel";
        String param = "page=" + reqBean.getPage() + "&count=" + reqBean.getCount();
        if (StringUtils.isNotBlank((CharSequence)reqBean.getProviderName())) {
            try {
                param = param + "&providerName=" + URLEncoder.encode(reqBean.getProviderName(), "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getUnitName())) {
            try {
                param = param + "&unitName=" + URLEncoder.encode(reqBean.getUnitName(), "utf-8");
            }
            catch (UnsupportedEncodingException e3) {
                log.error(e3.getMessage(), (Throwable)e3);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getUnitID())) {
            param = param + "&unitID=" + reqBean.getUnitID();
        }
        if (StringUtils.isNotBlank((CharSequence)reqBean.getStatus())) {
            param = param + "&status=" + reqBean.getStatus();
        }
        url = url + "?" + param;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        Object rspBean = null;
        try {
            return httpRequestUtil.reqIO(url, null, "GET");
        }
        catch (Exception e4) {
            return null;
        }
    }

    @Override
    public boolean checkJxServiceNoName(String providerName) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        try {
            url = url + "/providers/checkName/{providerName}".replace("{providerName}", URLEncoder.encode(providerName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean resultBean = null;
        try {
            String result = httpRequestUtil.req(url, null, "GET");
            resultBean = Util.readValue(result, JxServiceNoRspBean.class);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        if (resultBean != null) {
            return (Boolean)resultBean.getData();
        }
        return true;
    }

    @Override
    public boolean checkJxServiceNoName(String providerName, String serviceId) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        try {
            url = url + "/providers/{serviceId}/checkName/{providerName}".replace("{providerName}", URLEncoder.encode(providerName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        url = url.replace("{serviceId}", serviceId);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean rspBean = null;
        try {
            String result = httpRequestUtil.req(url, null, "GET");
            rspBean = Util.readValue(result, JxServiceNoRspBean.class);
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (rspBean != null) {
            return (Boolean)rspBean.getData();
        }
        return true;
    }

    @Override
    public JxServiceNoRspBean createJxServiceNo(JxServiceNoReqBean reqBean) {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVICE_NO_URL");
        url = url + "/providers";
        String param = reqBean != null ? Util.toJsonStr(reqBean) : "{}";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        JxServiceNoRspBean resultBean = null;
        try {
            String result = httpRequestUtil.req(url, param, "POST");
            resultBean = Util.readValue(result, JxServiceNoRspBean.class);
        }
        catch (Exception e2) {
            // empty catch block
        }
        return resultBean;
    }
}

