/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxgl.service.impl;

import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxgl.bean.ChannelDetailAndSubRelationBean;
import pams.function.jingxin.jxgl.bean.PageList;
import pams.function.jingxin.jxgl.bean.ReqBean;
import pams.function.jingxin.jxgl.bean.ResBean;
import pams.function.jingxin.jxgl.bean.TypeBean;
import pams.function.jingxin.jxgl.dao.JxTypeDao;
import pams.function.jingxin.jxgl.service.JxTypeService;

@Service
public class JxTypeServiceImpl
implements JxTypeService {
    @Autowired
    JxTypeDao jxTypeDao;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private PersonDao personDao;

    @Override
    public ResBean queryList(TypeBean typeBean, PageParam page) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "QueryTypeList";
        ReqBean reqBean = new ReqBean();
        typeBean.setCurPageNo(page.getPage());
        typeBean.setPageSize(page.getRows());
        typeBean.setStatus(typeBean.getStatus());
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean addType(TypeBean typeBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "AddJxType";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean startType(TypeBean typeBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "StartJxType";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean stopType(TypeBean typeBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "StopJxType";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public List<Map<String, Object>> queryTypeListForSelect(TypeBean typeBean) throws Exception {
        PageParam page = new PageParam();
        page.setPage("1");
        page.setRows("50");
        typeBean.setPersonId(typeBean.getPersonId());
        ResBean resBean = this.queryList(typeBean, page);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("code", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        String resStr = Util.toJsonStr(returnJson);
        PageList pageList = (PageList)Util.readValue(resStr, PageList.class, TypeBean.class);
        List TypeBeanList = pageList.getRows();
        if (TypeBeanList != null) {
            for (TypeBean typeBeanSelect : TypeBeanList) {
                HashMap<String, String> typMap = new HashMap<String, String>();
                typMap.put("code", typeBeanSelect.getId());
                typMap.put("name", typeBeanSelect.getName());
                listmap.add(typMap);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> queryTypeListForSelect(TypeBean typeBean, PageParam page) throws Exception {
        if (page == null) {
            return this.queryTypeListForSelect(typeBean);
        }
        typeBean.setPersonId(typeBean.getPersonId());
        ResBean resBean = this.queryList(typeBean, page);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("code", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        String resStr = Util.toJsonStr(returnJson);
        PageList pageList = (PageList)Util.readValue(resStr, PageList.class, TypeBean.class);
        List TypeBeanList = pageList.getRows();
        for (TypeBean typeBeanSelect : TypeBeanList) {
            HashMap<String, String> typMap = new HashMap<String, String>();
            typMap.put("code", typeBeanSelect.getId());
            typMap.put("name", typeBeanSelect.getName());
            listmap.add(typMap);
        }
        return listmap;
    }

    @Override
    public ChannelDetailAndSubRelationBean getTypeDetail(TypeBean typeBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "QueryTypeDetail";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        Object returnJson = null;
        if (null != resBean) {
            returnJson = resBean.getResult().getInfo();
        }
        String resStr = Util.toJsonStr(returnJson);
        ChannelDetailAndSubRelationBean channelDetailAndSubRelationBean = Util.readValue(resStr, ChannelDetailAndSubRelationBean.class);
        return channelDetailAndSubRelationBean;
    }

    @Override
    public ResBean updateType(TypeBean typeBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "UpdateJxType";
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(typeBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public List<Person> queryTypeManagerPersonList(String typeId, String personId) throws Exception {
        ResBean rst = this.queryTypeManager(typeId, personId);
        if ("0".equals(rst.getResult().getResultStatus())) {
            throw new RuntimeException("\u8c03\u7528\u5206\u7c7b\u4ee3\u7ba1\u4eba\u5458\u63a5\u53e3\u5f02\u5e38");
        }
        String idsStr = (String)rst.getResult().getInfo();
        if (idsStr != null) {
            String[] ids = idsStr.split(",");
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : ids) {
                idList.add(id);
            }
            List<Person> persons = this.personDao.queryPersonListByIds(idList);
            return persons;
        }
        return null;
    }

    public ResBean queryTypeManager(String typeId, String personId) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "QueryChannelProxyPersons";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", "1.0");
        params.put("personId", personId);
        params.put("channelId", typeId);
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }

    @Override
    public ResBean saveTypeManager(String typeId, String personId, String proxyPersonIds) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = "SetChannelProxy";
        if (proxyPersonIds.startsWith(",")) {
            proxyPersonIds = proxyPersonIds.substring(1, proxyPersonIds.length());
        }
        if (proxyPersonIds.endsWith(",")) {
            proxyPersonIds = proxyPersonIds.substring(0, proxyPersonIds.length() - 1);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", "1.0");
        params.put("personId", personId);
        params.put("channelId", typeId);
        params.put("proxyPersonIds", proxyPersonIds);
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        ResBean resBean = Util.readValue(result, ResBean.class);
        return resBean;
    }
}

