/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxmsapi.control;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.jingxin.jxgl.bean.JxServiceNoBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoDepBean;
import pams.function.jingxin.jxgl.bean.JxServiceNoPersonBean;
import pams.function.jingxin.jxgl.service.JxServiceNoService;
import pams.function.jingxin.jxmsapi.bean.JxQueryBean;
import pams.function.jingxin.jxmsapi.entity.JxDepartment;
import pams.function.jingxin.jxmsapi.entity.JxPerson;
import pams.function.jingxin.jxmsapi.service.JxmsApiService;

@Controller
public class JxmsApiController {
    private static final Logger log = LoggerFactory.getLogger(JxmsApiController.class);
    @Autowired
    JxmsApiService service;
    @Autowired
    UserManageService userManageService;
    @Autowired
    JxServiceNoService jxServiceNoService;

    @RequestMapping(value={"/jxmsapi/JxmsApiController/queryperson.do"})
    public void queryPerson(HttpServletResponse response, String page, String count, JxQueryBean queryBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page pg = new Page(page, count);
            List<JxPerson> queryPerson = this.service.queryPerson(queryBean, pg);
            result.put("flag", "1");
            result.put("total", pg.getTotal());
            result.put("data", queryPerson);
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/queryperson2.do"})
    public void queryPerson2(HttpServletResponse response, JxQueryBean queryBean) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<JxPerson> queryPerson = null;
        try {
            queryPerson = this.service.queryPerson(queryBean, null);
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(queryPerson));
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/queryPersonByCodeOrIdentifier.do"})
    public void queryPersonByCodeOrIdentifier(HttpServletResponse response, String codeOrIdentifier) {
        HashMap<String, String> result = new HashMap<String, String>();
        JxPerson jxPerson = null;
        String rst = "";
        try {
            jxPerson = this.service.queryPersonByCodeOrIdentifier(codeOrIdentifier);
            if (jxPerson != null) {
                rst = Util.toJsonStr(jxPerson);
            }
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, rst);
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/queryPersonById.do"})
    public void queryPerson2(HttpServletResponse response, String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        JxPerson jxPerson = null;
        String rst = "";
        try {
            jxPerson = this.service.queryPersonById(id);
            if (jxPerson != null) {
                rst = Util.toJsonStr(jxPerson);
            }
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, rst);
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/querydep.do"})
    public void queryDep(HttpServletResponse response, String page, String count, JxQueryBean queryBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<JxDepartment> queryDepartment = this.service.queryDepartment(queryBean, null);
            result.put("flag", "1");
            result.put("total", queryDepartment.size());
            result.put("data", queryDepartment);
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/queryPersonParentDepId.do"})
    public void queryPersonParentDepId(HttpServletResponse response, String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ArrayList<String> depIds = new ArrayList<String>();
            Person person = this.userManageService.queryPersonById(id);
            Department dep = person.getDepartment();
            depIds.add(dep.getId());
            while ((dep = dep.getParentDep()) != null) {
                depIds.add(dep.getId());
            }
            result.put("flag", "1");
            result.put("data", depIds);
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/getJxServicePersonJsonZT.do"})
    public void getJxServicePersonJsonZT(HttpServletResponse response, String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        String rst = "[]";
        try {
            JxServiceNoBean jxs = this.jxServiceNoService.queryJxServiceNoById(id);
            if (jxs != null) {
                List<JxServiceNoDepBean> pamsDeptQueryRetList = jxs.getPamsDeptQueryRetList();
                List<JxServiceNoPersonBean> pamsUserBeanList = jxs.getPamsUserBeanList();
                String personIds = "";
                String depIds = "";
                if (pamsDeptQueryRetList != null) {
                    for (JxServiceNoDepBean dep : pamsDeptQueryRetList) {
                        depIds = depIds + dep.getId() + ",";
                    }
                    if (depIds.endsWith(",")) {
                        depIds = depIds.substring(0, depIds.length() - 1);
                    }
                }
                if (pamsUserBeanList != null) {
                    for (JxServiceNoPersonBean person : pamsUserBeanList) {
                        personIds = personIds + person.getId() + ",";
                    }
                    if (personIds.endsWith(",")) {
                        personIds = personIds.substring(0, personIds.length() - 1);
                    }
                }
                if ("2".equals(jxs.getOrderType())) {
                    depIds = "";
                } else if ("1".equals(jxs.getOrderType()) && "1".equals(jxs.getOrderPermission())) {
                    depIds = "8888888888";
                    personIds = "";
                }
                Collection<Map<String, Object>> jxServiceNoDepPersonJson = this.service.getJXServiceNoDepPersonJson(personIds, depIds);
                rst = Util.toJsonStr(jxServiceNoDepPersonJson);
            }
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, rst);
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/getJxServiceNOPersonId.do"})
    public void getJxServiceNOPersonId(HttpServletResponse response, String id, String sDepIds, String sPersonIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String rst = "[]";
        try {
            JxServiceNoBean jxs = this.jxServiceNoService.queryJxServiceNoById(id);
            if (jxs != null) {
                List<JxServiceNoDepBean> pamsDeptQueryRetList = jxs.getPamsDeptQueryRetList();
                List<JxServiceNoPersonBean> pamsUserBeanList = jxs.getPamsUserBeanList();
                String personIds = "";
                String depIds = "";
                if (pamsDeptQueryRetList != null) {
                    for (JxServiceNoDepBean dep : pamsDeptQueryRetList) {
                        depIds = depIds + dep.getId() + ",";
                    }
                    if (depIds.endsWith(",")) {
                        depIds = depIds.substring(0, depIds.length() - 1);
                    }
                }
                if (pamsUserBeanList != null) {
                    for (JxServiceNoPersonBean person : pamsUserBeanList) {
                        personIds = personIds + person.getId() + ",";
                    }
                    if (personIds.endsWith(",")) {
                        personIds = personIds.substring(0, personIds.length() - 1);
                    }
                }
                if ("2".equals(jxs.getOrderType())) {
                    depIds = "";
                } else if ("1".equals(jxs.getOrderType()) && "1".equals(jxs.getOrderPermission())) {
                    depIds = "8888888888";
                    personIds = "";
                }
                List<String> jxServiceNOPersonId = this.service.getJxServiceNOPersonId(depIds, personIds, sDepIds, sPersonIds);
                result.put("flag", "1");
                result.put("data", jxServiceNOPersonId);
            }
        }
        catch (Exception e2) {
            log.error("\u8b66\u4fe1\u67e5\u8be2\u4eba\u5458\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/jxmsapi/JxmsApiController/setJxUser.do"})
    public void setJxUser(HttpServletResponse response, String personId, String status) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Person pamsUser = this.userManageService.queryPersonById(personId);
            if (pamsUser != null) {
                pamsUser.setJxFlag(status);
                this.userManageService.updateUserNotUpdateLastupdatetime(pamsUser);
                result.put("flag", "1");
            } else {
                result.put("flag", "0");
                result.put("msg", "\u7528\u6237\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u8f85\u8b66\u72b6\u6001\u5931\u8d25", (Throwable)e2);
            result.put("flag", "0");
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }
}

