/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.jxmsapi.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxmsapi.bean.JxQueryBean;
import pams.function.jingxin.jxmsapi.dao.JxmsApiDao;
import pams.function.jingxin.jxmsapi.entity.JxDepartment;
import pams.function.jingxin.jxmsapi.entity.JxPerson;
import pams.function.jingxin.jxmsapi.service.JxmsApiService;

@Service
public class JxmsApiServiceImpl
implements JxmsApiService {
    @Autowired
    private JxmsApiDao jxmsApiDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;

    @Override
    public List<JxPerson> queryPerson(JxQueryBean queryBean, Page page) {
        return this.jxmsApiDao.queryPerson(queryBean, page);
    }

    @Override
    public List<JxDepartment> queryDepartment(JxQueryBean queryBean, Page page) {
        return this.jxmsApiDao.queryDepartment(queryBean, page);
    }

    @Override
    public JxPerson queryPersonByCodeOrIdentifier(String codeOrIdentifier) {
        List<JxPerson> list = this.jxmsApiDao.queryPersonByCodeOrIdentifier(codeOrIdentifier);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public JxPerson queryPersonById(String id) {
        JxQueryBean queryBean = new JxQueryBean();
        queryBean.setId(id);
        List<JxPerson> list = this.jxmsApiDao.queryPerson(queryBean, null);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Collection<Map<String, Object>> getJXServiceNoDepPersonJson(String personIds, String depIds) {
        HashMap<String, String> map;
        ArrayList items = new ArrayList();
        LinkedHashMap mapdep = new LinkedHashMap();
        List<Department> parentDep = this.jxmsApiDao.getParentDep(personIds, depIds);
        List<Department> depList = this.jxmsApiDao.getDepByIds(depIds);
        List<Person> personList = this.jxmsApiDao.getPersonByIds(personIds, depIds);
        for (Department dep : parentDep) {
            map = new HashMap<String, String>();
            map.put("id", dep.getId());
            map.put("name", dep.getName());
            map.put("pId", dep.getParentID());
            map.put("type", "dep");
            map.put("code", dep.getCode());
            mapdep.put(dep.getId(), map);
        }
        for (Department dep : depList) {
            map = new HashMap();
            map.put("id", dep.getId());
            map.put("name", dep.getName());
            map.put("pId", dep.getParentID());
            map.put("type", "dep");
            map.put("code", dep.getCode());
            mapdep.put(dep.getId(), map);
        }
        for (Person person : personList) {
            map = new HashMap();
            map.put("id", person.getId());
            map.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
            map.put("pId", person.getDepId());
            map.put("type", "person");
            map.put("iconSkin", "icon-person");
            map.put("code", person.getCode());
            mapdep.put(person.getId(), map);
        }
        return mapdep.values();
    }

    @Override
    public List<String> getJxServiceNOPersonId(String depIds, String personIds, String sDepIDs, String sPersonIds) {
        return this.jxmsApiDao.getJxServiceNOPersonId(depIds, personIds, sDepIDs, sPersonIds);
    }
}

