/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.moments.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.jingxin.moments.bean.CommentBean;
import pams.function.jingxin.moments.bean.DownloadFileBean;
import pams.function.jingxin.moments.bean.OpenImageBean;
import pams.function.jingxin.moments.bean.ParamBean;
import pams.function.jingxin.moments.bean.SearchNodeBean;
import pams.function.jingxin.moments.bean.TopicBean;
import pams.function.jingxin.moments.bean.result.PageBean;
import pams.function.jingxin.moments.bean.result.ResponseBean;
import pams.function.jingxin.moments.service.CommentService;
import pams.function.jingxin.moments.service.TopicService;
import pams.function.jingxin.moments.util.FileUtil;

@Controller
@Scope(value="session")
public class MomentControl
extends BaseControler {
    @Autowired
    private TopicService topicService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private SystemConfigService systemConfigService;
    private static final Logger log = LoggerFactory.getLogger(MomentControl.class);

    @RequestMapping(value={"/moment/momentControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error("\u5de5\u4f5c\u5708\u9519\u8bef{}", (Throwable)e2);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/moment/momentControl/getPamsTopicList.do"})
    public void getPamsTopicList(HttpServletRequest request, HttpServletResponse response, ModelMap map, ParamBean paramBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ResponseBean<TopicBean> responseBean = null;
        try {
            responseBean = this.topicService.getPamsTopicList(paramBean);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868{}", (Throwable)e2);
        }
        if (responseBean.getResult().getResultStatus().equals("1")) {
            PageBean pageBean = responseBean.getResult().getInfo();
            result.put("total", pageBean.getTotal());
            this.commentService.setUserBeanList(pageBean.getItems());
            result.put("rows", pageBean.getItems());
        } else {
            log.error("\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868\u5931\u8d25\uff1a" + responseBean.getResult().getInfo());
            result.put("total", 0);
            result.put("rows", new ArrayList());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/moment/momentControl/commentList.do"})
    public String commentList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, String topicId) {
        map.put((Object)"topicId", (Object)topicId);
        return "jxgl/moment/default/commentList";
    }

    @RequestMapping(value={"/moment/momentControl/getPamsCommentList.do"})
    public void getPamsCommentList(HttpServletRequest request, HttpServletResponse response, ModelMap map, ParamBean paramBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ResponseBean<CommentBean> responseBean = null;
        try {
            responseBean = this.commentService.getPamsCommentList(paramBean);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8bdd\u9898\u8bc4\u8bba\u5217\u8868\u5931\u8d25topicId:" + paramBean.getTopicId() + ", {}", (Throwable)e2);
        }
        if (responseBean.getResult().getResultStatus().equals("1")) {
            PageBean pageBean = responseBean.getResult().getInfo();
            result.put("total", pageBean.getTotal());
            this.commentService.setUserBeanList(pageBean.getItems());
            result.put("rows", pageBean.getItems());
        } else {
            log.error("\u83b7\u53d6\u5de5\u4f5c\u5708\u8bc4\u8bba\u5217\u8868\u5931\u8d25\uff0ctopicId:" + paramBean.getTopicId() + "\uff0c" + responseBean.getResult().getInfo());
            result.put("total", 0);
            result.put("rows", new ArrayList());
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/moment/momentControl/deleteTopic.do"})
    public void deleteTopic(HttpServletRequest request, HttpServletResponse response, ModelMap map, String topicId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ResponseBean<String> responseBean = null;
        try {
            responseBean = this.topicService.deleteTopic(topicId);
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u8bdd\u9898\u5931\u8d25{}", (Throwable)e2);
            result.put("flag", 0);
        }
        if (responseBean.getResult().getResultStatus().equals("1")) {
            result.put("flag", 1);
        } else {
            log.error("\u5220\u9664\u5de5\u4f5c\u5708\u8bdd\u9898\u5931\u8d25\uff0ctopicId:" + topicId + "\uff0c" + responseBean.getResult().getInfo());
            result.put("flag", 0);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/moment/momentControl/deleteComment.do"})
    public void deleteComment(HttpServletRequest request, HttpServletResponse response, ModelMap map, String commentId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ResponseBean<String> responseBean = null;
        try {
            responseBean = this.commentService.deleteComment(commentId);
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u8bdd\u9898\u5931\u8d25{}", (Throwable)e2);
            result.put("flag", 0);
        }
        if (responseBean.getResult().getResultStatus().equals("1")) {
            result.put("flag", 1);
        } else {
            log.error("\u5220\u9664\u5de5\u4f5c\u5708\u8bdd\u9898\u8bc4\u8bba\u5931\u8d25\uff0ccommentId:" + commentId + "\uff0c" + responseBean.getResult().getInfo());
            result.put("flag", 0);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/moment/momentControl/downloadPicture.do"})
    public void downloadPicture(HttpServletRequest request, HttpServletResponse response, ModelMap map, String fileId) {
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            log.error("\u6587\u4ef6\u552f\u4e00\u6807\u793a\u4e3a\u7a7a");
            return;
        }
        String downloadUrl = this.systemConfigService.getValueByCode("FA_SERVER_URL") + this.systemConfigService.getValueByCode("FA_DOWNLOAD");
        try {
            ServletOutputStream os = response.getOutputStream();
            byte[] downloadByte = FileUtil.download(fileId, downloadUrl);
            os.write(downloadByte);
            os.flush();
        }
        catch (IOException e2) {
            log.error("\u8fd4\u56de\u56fe\u7247\u4e8c\u8fdb\u5236\u6d41\u51fa\u9519\uff0c{}", (Throwable)e2);
        }
    }

    @RequestMapping(value={"/moment/momentControl/downloadFile.do"})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, ModelMap map, DownloadFileBean downloadFileBean) {
        if (StringUtils.isEmpty((CharSequence)downloadFileBean.getFileId())) {
            log.error("\u6587\u4ef6\u552f\u4e00\u6807\u793a\u4e3a\u7a7a");
            return;
        }
        String downloadUrl = this.systemConfigService.getValueByCode("FA_SERVER_URL") + this.systemConfigService.getValueByCode("FA_DOWNLOAD");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(downloadFileBean.getFileName(), "UTF-8"));
            ServletOutputStream os = response.getOutputStream();
            byte[] downloadByte = FileUtil.download(downloadFileBean.getFileId(), downloadUrl);
            os.write(downloadByte);
            os.flush();
        }
        catch (IOException e2) {
            log.error("\u8fd4\u56de\u56fe\u7247\u4e8c\u8fdb\u5236\u6d41\u51fa\u9519\uff0c{}", (Throwable)e2);
        }
    }

    @RequestMapping(value={"/moment/momentControl/openImage.do"})
    public String openImage(HttpServletRequest request, HttpServletResponse response, ModelMap map, OpenImageBean openImageBean) {
        map.put((Object)"openImageBean", (Object)openImageBean);
        return "jxgl/moment/default/openImage";
    }

    @RequestMapping(value={"/moment/momentControl/searchPersonName.do"})
    public void searchPersonName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        if (q == null) {
            q = "";
        }
        String name = q;
        try {
            name = URLDecoder.decode(name, "Utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            log.error("\u8f6c\u7801\u9519\u8bef,{}", (Throwable)e2);
            return;
        }
        name = name.trim();
        if (StringUtils.isEmpty((CharSequence)q)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)limit)) {
            limit = "10";
        }
        List<SearchNodeBean> searchNodeBeanList = this.topicService.searchPersonName(name, Integer.parseInt(limit));
        Util.writeUtf8Text(response, Util.toJsonStr(searchNodeBeanList));
    }
}

