/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.moments.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxgl.bean.ReqBean;
import pams.function.jingxin.moments.bean.CommentBean;
import pams.function.jingxin.moments.bean.ParamBean;
import pams.function.jingxin.moments.bean.PersonDepBean;
import pams.function.jingxin.moments.bean.UserBean;
import pams.function.jingxin.moments.bean.result.ResponseBean;
import pams.function.jingxin.moments.dao.MomentDao;
import pams.function.jingxin.moments.service.CommentService;

@Service
public class CommentServiceImpl
implements CommentService {
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private MomentDao momentDao;

    @Override
    public ResponseBean<CommentBean> getPamsCommentList(ParamBean paramBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = this.systemConfigService.getValueByCode("JXMS_MOMENT_COMMENT_LIST");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(paramBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String response = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        return (ResponseBean)Util.readValue(response, ResponseBean.class, CommentBean.class);
    }

    @Override
    public void setUserBeanList(List<UserBean> userBeanList) {
        if (userBeanList == null || userBeanList.size() == 0) {
            return;
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (UserBean userBean : userBeanList) {
            userIdList.add(userBean.getUserId());
        }
        List<PersonDepBean> personDepBeanList = this.momentDao.queryPersonDepBeanList(userIdList);
        for (UserBean userBean : userBeanList) {
            PersonDepBean personDepBean = this.findPersonDepBean(userBean.getUserId(), personDepBeanList);
            if (personDepBean == null) continue;
            userBean.setUserName(personDepBean.getUserName());
            userBean.setDepName(personDepBean.getDepName());
        }
    }

    private PersonDepBean findPersonDepBean(String userId, List<PersonDepBean> personDepBeanList) {
        if (StringUtils.isEmpty((CharSequence)userId) || personDepBeanList == null || personDepBeanList.size() == 0) {
            return null;
        }
        for (PersonDepBean personDepBean : personDepBeanList) {
            if (!userId.equals(personDepBean.getUserId())) continue;
            return personDepBean;
        }
        return null;
    }

    @Override
    public ResponseBean<String> deleteComment(String commentId) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = this.systemConfigService.getValueByCode("JXMS_MOMENT_COMMENT_DELETE");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionId", "0");
        params.put("ignoreCheckSession", true);
        params.put("commentId", commentId);
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String response = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        return (ResponseBean)Util.readValue(response, ResponseBean.class, String.class);
    }
}

