/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.moments.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.jingxin.jxgl.bean.ReqBean;
import pams.function.jingxin.moments.bean.ParamBean;
import pams.function.jingxin.moments.bean.PersonDepBean;
import pams.function.jingxin.moments.bean.SearchNodeBean;
import pams.function.jingxin.moments.bean.TopicBean;
import pams.function.jingxin.moments.bean.result.ResponseBean;
import pams.function.jingxin.moments.dao.MomentDao;
import pams.function.jingxin.moments.service.TopicService;

@Service
public class TopicServiceImpl
implements TopicService {
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private MomentDao momentDao;

    @Override
    public ResponseBean<TopicBean> getPamsTopicList(ParamBean paramBean) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = this.systemConfigService.getValueByCode("JXMS_MOMENT_TOPIC_LIST");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        reqBean.setParams(paramBean);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String response = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        return (ResponseBean)Util.readValue(response, ResponseBean.class, TopicBean.class);
    }

    @Override
    public ResponseBean<String> deleteTopic(String topicId) throws Exception {
        String url = this.systemConfigService.getValueByCode("JXMS_SERVER_URL");
        String method = this.systemConfigService.getValueByCode("JXMS_MOMENT_TOPIC_DELETE");
        ReqBean reqBean = new ReqBean();
        reqBean.setMethod(method);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionId", "0");
        params.put("ignoreCheckSession", true);
        params.put("topicId", topicId);
        reqBean.setParams(params);
        String param = Util.toJsonStr(reqBean);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String response = URLDecoder.decode(httpRequestUtil.postJson(url, param), "utf-8");
        return (ResponseBean)Util.readValue(response, ResponseBean.class, String.class);
    }

    @Override
    public List<SearchNodeBean> searchPersonName(String name, int limit) {
        ArrayList<SearchNodeBean> searchNodeBeanList = new ArrayList<SearchNodeBean>();
        List<PersonDepBean> personDepBeanList = this.momentDao.queryPersonDepBeanList(name, limit);
        if (personDepBeanList == null || personDepBeanList.size() == 0) {
            return searchNodeBeanList;
        }
        for (PersonDepBean personDepBean : personDepBeanList) {
            SearchNodeBean searchNodeBean = new SearchNodeBean();
            searchNodeBean.setNodeId(personDepBean.getUserId());
            searchNodeBean.setText(personDepBean.getUserName() + "_" + personDepBean.getDepName());
            searchNodeBean.setName(personDepBean.getUserName());
            searchNodeBeanList.add(searchNodeBean);
        }
        return searchNodeBeanList;
    }
}

