/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.moments.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.jingxin.moments.util.ResponseWrap;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private HttpRequestBase request;
    private EntityBuilder builder;
    private URIBuilder uriBuilder;
    private LayeredConnectionSocketFactory socketFactory;
    private HttpClientBuilder clientBuilder;
    private CloseableHttpClient httpClient;
    private CookieStore cookieStore;
    private RequestConfig.Builder config;
    private boolean isHttps;
    private int type;
    public static final ObjectMapper mapper = new ObjectMapper();

    private HttpUtils(HttpRequestBase request) {
        this.request = request;
        this.clientBuilder = HttpClientBuilder.create();
        this.isHttps = request.getURI().getScheme().equalsIgnoreCase("https");
        this.config = RequestConfig.custom().setCookieSpec("compatibility");
        this.cookieStore = new BasicCookieStore();
        if (request instanceof HttpPost) {
            this.type = 1;
            this.builder = EntityBuilder.create().setParameters(new ArrayList());
        } else if (request instanceof HttpGet) {
            this.type = 2;
            this.uriBuilder = new URIBuilder();
        } else if (request instanceof HttpPut) {
            this.type = 3;
            this.builder = EntityBuilder.create().setParameters(new ArrayList());
        } else if (request instanceof HttpDelete) {
            this.type = 4;
            this.uriBuilder = new URIBuilder();
        }
    }

    private HttpUtils(HttpRequestBase request, HttpUtils clientUtils) {
        this(request);
        this.httpClient = clientUtils.httpClient;
        this.config = clientUtils.config;
        this.setHeaders(clientUtils.getAllHeaders());
        this.SetCookieStore(clientUtils.cookieStore);
    }

    private static HttpUtils create(HttpRequestBase request) {
        return new HttpUtils(request);
    }

    private static HttpUtils create(HttpRequestBase request, HttpUtils clientUtils) {
        return new HttpUtils(request, clientUtils);
    }

    public static HttpUtils post(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(url));
    }

    public static HttpUtils get(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(url));
    }

    public static HttpUtils put(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(url));
    }

    public static HttpUtils delete(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(url));
    }

    public static HttpUtils post(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(uri));
    }

    public static HttpUtils get(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(uri));
    }

    public static HttpUtils put(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(uri));
    }

    public static HttpUtils delete(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(uri));
    }

    public static HttpUtils post(String url, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(url), clientUtils);
    }

    public static HttpUtils get(String url, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(url), clientUtils);
    }

    public static HttpUtils put(String url, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(url), clientUtils);
    }

    public static HttpUtils delete(String url, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(url), clientUtils);
    }

    public static HttpUtils post(URI uri, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(uri), clientUtils);
    }

    public static HttpUtils get(URI uri, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(uri), clientUtils);
    }

    public static HttpUtils put(URI uri, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(uri), clientUtils);
    }

    public static HttpUtils delete(URI uri, HttpUtils clientUtils) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(uri), clientUtils);
    }

    public HttpUtils setParameters(NameValuePair ... parameters) {
        if (this.builder != null) {
            this.builder.setParameters(parameters);
        } else {
            this.uriBuilder.setParameters(Arrays.asList(parameters));
        }
        return this;
    }

    public HttpUtils addParameter(String name, String value) {
        if (this.builder != null) {
            this.builder.getParameters().add(new BasicNameValuePair(name, value));
        } else {
            this.uriBuilder.addParameter(name, value);
        }
        return this;
    }

    public HttpUtils addParameters(NameValuePair ... parameters) {
        if (this.builder != null) {
            this.builder.getParameters().addAll(Arrays.asList(parameters));
        } else {
            this.uriBuilder.addParameters(Arrays.asList(parameters));
        }
        return this;
    }

    public HttpUtils setParameters(Map<String, String> parameters) {
        NameValuePair[] values = new NameValuePair[parameters.size()];
        int i = 0;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            values[i++] = new BasicNameValuePair(parameter.getKey(), parameter.getValue());
        }
        this.setParameters(values);
        return this;
    }

    public HttpUtils setParameter(File file) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setFile(file);
        return this;
    }

    public HttpUtils setParameter(byte[] binary) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setBinary(binary);
        return this;
    }

    public HttpUtils setParameter(Serializable serializable) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setSerializable(serializable);
        return this;
    }

    public HttpUtils setParameterJson(Object parameter) {
        if (this.builder != null) {
            try {
                this.builder.setBinary(mapper.writeValueAsBytes(parameter));
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            catch (IOException e3) {
                throw new RuntimeException(e3.getMessage(), e3);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    public HttpUtils setParameter(InputStream stream) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setStream(stream);
        return this;
    }

    public HttpUtils setParameter(String text) {
        if (this.builder != null) {
            this.builder.setText(text);
        } else {
            this.uriBuilder.setParameters(URLEncodedUtils.parse((String)text, (Charset)Consts.UTF_8));
        }
        return this;
    }

    public FormEntity newForm() {
        return new FormEntity(this);
    }

    public HttpUtils setContentEncoding(String encoding) {
        if (this.builder != null) {
            this.builder.setContentEncoding(encoding);
        }
        return this;
    }

    public HttpUtils setContentType(ContentType contentType) {
        if (this.builder != null) {
            this.builder.setContentType(contentType);
        }
        return this;
    }

    public HttpUtils setContentType(String mimeType, Charset charset) {
        if (this.builder != null) {
            this.builder.setContentType(ContentType.create((String)mimeType, (Charset)charset));
        }
        return this;
    }

    public HttpUtils addParameters(Map<String, String> parameters) {
        ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>(parameters.size());
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            values.add(new BasicNameValuePair(parameter.getKey(), parameter.getValue()));
        }
        if (this.builder != null) {
            this.builder.getParameters().addAll(values);
        } else {
            this.uriBuilder.addParameters(values);
        }
        return this;
    }

    public HttpUtils addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public HttpUtils addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.request.addHeader(header.getKey(), header.getValue());
        }
        return this;
    }

    public HttpUtils setHeaders(Map<String, String> headers) {
        Header[] headerArray = new Header[headers.size()];
        int i = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            headerArray[i++] = new BasicHeader(header.getKey(), header.getValue());
        }
        this.request.setHeaders(headerArray);
        return this;
    }

    public HttpUtils setHeaders(Header[] headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public HttpUtils setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public HttpUtils setHeader(String key, String name) {
        this.request.setHeader((Header)new BasicHeader(key, name));
        return this;
    }

    public Header[] getAllHeaders() {
        return this.request.getAllHeaders();
    }

    public HttpUtils removeHeaders(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public HttpUtils removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public HttpUtils removeHeader(String name, String value) {
        this.request.removeHeader((Header)new BasicHeader(name, value));
        return this;
    }

    public boolean containsHeader(String name) {
        return this.request.containsHeader(name);
    }

    public HeaderIterator headerIterator() {
        return this.request.headerIterator();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public HttpUtils setURI(URI uri) {
        this.request.setURI(uri);
        return this;
    }

    public HttpUtils setURI(String uri) {
        return this.setURI(URI.create(uri));
    }

    public HttpUtils SetCookieStore(CookieStore cookieStore) {
        if (cookieStore == null) {
            return this;
        }
        this.cookieStore = cookieStore;
        return this;
    }

    public HttpUtils addCookie(Cookie ... cookies) {
        if (cookies == null) {
            return this;
        }
        for (int i = 0; i < cookies.length; ++i) {
            this.cookieStore.addCookie(cookies[i]);
        }
        return this;
    }

    public HttpUtils setProxy(String hostname, int port) {
        HttpHost proxy = new HttpHost(hostname, port);
        return this.setProxy(proxy);
    }

    public HttpUtils setProxy(String hostname, int port, String schema) {
        HttpHost proxy = new HttpHost(hostname, port, schema);
        return this.setProxy(proxy);
    }

    public HttpUtils setProxy(InetAddress address) {
        HttpHost proxy = new HttpHost(address);
        return this.setProxy(proxy);
    }

    public HttpUtils setProxy(HttpHost host) {
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(host);
        this.clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        return this;
    }

    public HttpUtils setJKS(String jksFilePath, String password) {
        return this.setJKS(new File(jksFilePath), password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpUtils setJKS(File jksFile, String password) {
        try (FileInputStream instream = new FileInputStream(jksFile);){
            HttpUtils httpUtils = this.setJKS(instream, password);
            return httpUtils;
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public HttpUtils setJKS(InputStream instream, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(instream, password.toCharArray());
            return this.setJKS(keyStore, password);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public HttpUtils setJKS(KeyStore keyStore, String password) {
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().loadKeyMaterial(keyStore, password.toCharArray()).loadTrustMaterial(keyStore).build();
            this.socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
        return this;
    }

    public HttpUtils setSocketTimeout(int socketTimeout) {
        this.config.setSocketTimeout(socketTimeout);
        return this;
    }

    public HttpUtils setConnectTimeout(int connectTimeout) {
        this.config.setConnectTimeout(connectTimeout);
        return this;
    }

    public HttpUtils setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.config.setConnectionRequestTimeout(connectionRequestTimeout);
        return this;
    }

    public HttpUtils setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
        this.config.setCircularRedirectsAllowed(circularRedirectsAllowed);
        return this;
    }

    public HttpUtils setRedirectsEnabled(boolean redirectsEnabled) {
        this.config.setRedirectsEnabled(redirectsEnabled);
        return this;
    }

    public HttpUtils maxRedirects(int maxRedirects) {
        this.config.setMaxRedirects(maxRedirects);
        return this;
    }

    public ResponseWrap execute() {
        return this.execute(0, null);
    }

    public <T> T execute(ResponseHandler<? extends T> responseHandler) {
        return this.execute(responseHandler, null);
    }

    private ResponseWrap execute(int flag, MultipartEntityBuilder multiBuilder) {
        this.settingRequest(multiBuilder);
        if (this.httpClient == null) {
            this.httpClient = this.clientBuilder.build();
        }
        try {
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.request, (HttpContext)context);
            return new ResponseWrap(this.httpClient, this.request, response, context, mapper);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    private <T> T execute(ResponseHandler<? extends T> responseHandler, MultipartEntityBuilder multiBuilder) {
        this.settingRequest(multiBuilder);
        if (this.httpClient == null) {
            this.httpClient = this.clientBuilder.build();
        }
        try {
            return (T)this.httpClient.execute((HttpUriRequest)this.request, responseHandler);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private LayeredConnectionSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return sslsf;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    private void settingRequest(MultipartEntityBuilder multiBuilder) {
        URI uri = null;
        if (this.uriBuilder != null && this.uriBuilder.getQueryParams().size() != 0) {
            try {
                uri = this.uriBuilder.setPath(this.request.getURI().toString()).build();
            }
            catch (URISyntaxException e2) {
                logger.warn(e2.getMessage(), (Throwable)e2);
            }
        }
        HttpEntity httpEntity = null;
        switch (this.type) {
            case 1: {
                httpEntity = this.getEntityBuilder(multiBuilder);
                if (httpEntity.getContentLength() <= 0L) break;
                ((HttpPost)this.request).setEntity(httpEntity);
                break;
            }
            case 2: {
                HttpGet get = (HttpGet)this.request;
                if (uri == null) break;
                get.setURI(uri);
                break;
            }
            case 3: {
                httpEntity = this.getEntityBuilder(multiBuilder);
                if (httpEntity.getContentLength() <= 0L) break;
                ((HttpPut)this.request).setEntity(httpEntity);
                break;
            }
            case 4: {
                HttpDelete delete = (HttpDelete)this.request;
                if (uri == null) break;
                delete.setURI(uri);
            }
        }
        if (this.isHttps && this.socketFactory != null) {
            this.clientBuilder.setSSLSocketFactory(this.socketFactory);
        } else if (this.isHttps) {
            this.clientBuilder.setSSLSocketFactory(this.getSSLSocketFactory());
        }
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.request.setConfig(this.config.build());
    }

    private HttpEntity getEntityBuilder(MultipartEntityBuilder multiBuilder) {
        HttpEntity httpEntity = multiBuilder != null ? multiBuilder.build() : this.builder.build();
        return httpEntity;
    }

    public static void main(String[] args) throws IOException {
        Map s = HttpUtils.post("http://10.10.12.62:80/upload/").newForm().addParameter("file", new File("c:/page.png")).execute().getJson(Map.class);
        HttpUtils.get("http://10.10.12.62:80/download/" + s.get("fileid")).execute().transferTo("c:/getImag.png");
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.getFactory().enable(JsonParser.Feature.ALLOW_COMMENTS);
        mapper.getFactory().enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    }

    public class FormEntity {
        private MultipartEntityBuilder partBuilder = MultipartEntityBuilder.create();
        private HttpUtils httpUtils;

        public FormEntity(HttpUtils httpUtils2) {
            this.httpUtils = httpUtils2;
            this.partBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        }

        public FormEntity addParameter(String name, String value) {
            this.partBuilder.addTextBody(name, value, ContentType.TEXT_PLAIN.withCharset("UTF-8"));
            return this;
        }

        public FormEntity addParameter(NameValuePair ... parameters) {
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.partBuilder.addTextBody(parameters[i].getName(), parameters[i].getValue(), ContentType.TEXT_PLAIN.withCharset("UTF-8"));
                }
            }
            return this;
        }

        public FormEntity addParameter(String name, File file) {
            this.partBuilder.addPart(name, (ContentBody)new FileBody(file));
            return this;
        }

        public FormEntity addParameter(String name, byte[] bytes) {
            this.partBuilder.addBinaryBody(name, bytes);
            return this;
        }

        public FormEntity addParameter(String name, InputStream stream, ContentType contentType, String filename) {
            this.partBuilder.addBinaryBody(name, stream, contentType, filename);
            return this;
        }

        public FormEntity addParameter(String name, byte[] bytes, ContentType contentType, String filename) {
            this.partBuilder.addBinaryBody(name, bytes, contentType, filename);
            return this;
        }

        public FormEntity addParameter(String name, InputStream stream) {
            this.partBuilder.addBinaryBody(name, stream);
            return this;
        }

        public FormEntity setBoundary(String boundary) {
            this.partBuilder.setBoundary(boundary);
            return this;
        }

        public ResponseWrap execute() {
            return this.httpUtils.execute(0, this.partBuilder);
        }

        public <T> T execute(ResponseHandler<? extends T> responseHandler) {
            return (T)this.httpUtils.execute(responseHandler, this.partBuilder);
        }
    }
}

