/*
 * Decompiled with CFR 0.152.
 */
package pams.function.jingxin.moments.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrap {
    private Logger logger = LoggerFactory.getLogger(ResponseWrap.class);
    private CloseableHttpResponse response;
    private CloseableHttpClient httpClient;
    private HttpEntity entity;
    private HttpRequestBase request;
    private HttpClientContext context;
    private static ObjectMapper mapper;

    public ResponseWrap(CloseableHttpClient httpClient, HttpRequestBase request, CloseableHttpResponse response, HttpClientContext context, ObjectMapper _mapper) {
        this.response = response;
        this.httpClient = httpClient;
        this.request = request;
        this.context = context;
        mapper = _mapper;
        try {
            HttpEntity entity = response.getEntity();
            this.entity = entity != null ? new BufferedHttpEntity(entity) : new BasicHttpEntity();
            EntityUtils.consumeQuietly((HttpEntity)entity);
            this.response.close();
        }
        catch (IOException e2) {
            this.logger.warn(e2.getMessage());
        }
    }

    public void abort() {
        this.request.abort();
    }

    public List<URI> getRedirectLocations() {
        return this.context.getRedirectLocations();
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public String getString() {
        return this.getString(Consts.UTF_8);
    }

    public String getString(Charset defaultCharset) {
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (Charset)defaultCharset);
        }
        catch (IOException | ParseException e2) {
            this.logger.error(e2.getMessage(), e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Charset getCharset() {
        ContentType contentType = ContentType.get((HttpEntity)this.entity);
        if (contentType == null) {
            return null;
        }
        return contentType.getCharset();
    }

    public byte[] getByteArray() {
        try {
            return EntityUtils.toByteArray((HttpEntity)this.entity);
        }
        catch (IOException | ParseException e2) {
            this.logger.error(e2.getMessage(), e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public Header[] getAllHeaders() {
        return this.response.getAllHeaders();
    }

    public Header[] getHeaders(String name) {
        return this.response.getHeaders(name);
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public void removeHeaders(String name) {
        this.response.removeHeaders(name);
    }

    public void removeHeader(Header header) {
        this.response.removeHeader(header);
    }

    public void removeHeader(String name, String value) {
        this.response.removeHeader((Header)new BasicHeader(name, value));
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public HeaderIterator headerIterator() {
        return this.response.headerIterator();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public CookieStore getCookieStore() {
        return this.context.getCookieStore();
    }

    public List<Cookie> getCookies() {
        return this.getCookieStore().getCookies();
    }

    public InputStream getInputStream() {
        try {
            return this.entity.getContent();
        }
        catch (IOException | IllegalStateException e2) {
            this.logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public BufferedReader getBufferedReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharset()));
    }

    public void transferTo(String filePth) {
        this.transferTo(new File(filePth));
    }

    public void transferTo(File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.transferTo(fileOutputStream);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public void transferTo(OutputStream outputStream) {
        try {
            this.entity.writeTo(outputStream);
        }
        catch (Exception e2) {
            this.logger.warn(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public <T> T getJson(Class<T> clazz) {
        try {
            return (T)mapper.readValue(this.getByteArray(), clazz);
        }
        catch (IOException e2) {
            this.logger.warn(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public <T> List<T> getJsonList(Class<?> clazz) {
        try {
            return (List)mapper.readValue(this.getByteArray(), new TypeReference<List<T>>(){});
        }
        catch (IOException e2) {
            this.logger.warn(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }
}

