/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.accredit.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.accredit.service.AccreditService;

@Controller
@Scope(value="session")
public class PersonAccreditControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    AccreditService accreditService;
    private static final Logger log = LoggerFactory.getLogger(PersonAccreditControler.class);

    @RequestMapping(value={"/accredit/PersonAccreditControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/accredit/PersonAccreditControler/getAppTreeChild.do"})
    public void getAppTreeChild(String personId, HttpServletResponse response, HttpServletRequest request, ModelMap map) {
        String jsonlist = null;
        try {
            jsonlist = this.accreditService.getAppTreeChildJson();
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/accredit/PersonAccreditControler/forwardappTreePage.do"})
    public String forwardappTreePage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId) {
        String unEditLimits = "";
        String limits = "";
        try {
            unEditLimits = this.accreditService.getPersonUnEditLimits(personId);
            limits = this.accreditService.getPersonLimits(personId);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"unEditLimits", (Object)unEditLimits);
        map.put((Object)"checkLimits", (Object)limits);
        return "accredit/default/appList";
    }
}

