/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.control;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.mdp.app.bean.AppFeedBackQueryBean;
import pams.function.mdp.app.bean.AppFeedBackReplyBean;
import pams.function.mdp.app.bean.AppFeedBackReplyQueryBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.service.FeedBackManagerService;

@Controller
@Scope(value="session")
public class AppFeedBackManagerController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(AppFeedBackManagerController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private FeedBackManagerService feedBackManagerService;

    @RequestMapping(value={"/app/AppFeedBackManagerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/getList.do"})
    public void getFeedBackList(HttpServletResponse response, AppFeedBackQueryBean queryBean) {
        try {
            String ret = this.feedBackManagerService.getListFeedBack(queryBean);
            Util.writeUtf8Text(response, ret);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/getDetail.do"})
    public String getFeedBackDetailById(@RequestParam(value="feedbackId") String feedBackId, ModelMap modelMap) {
        String retPath = "error/error";
        try {
            String feedBackJsonRet = this.feedBackManagerService.getFeedBackDetailById(feedBackId);
            JSONObject feedbackBean = JSONObject.parseObject((String)feedBackJsonRet);
            modelMap.put((Object)"feedbackBean", (Object)feedbackBean);
            retPath = "app/feedbackManager/default/feedbackDetail";
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
        return retPath;
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/getReplyList.do"})
    public void getListReply(AppFeedBackReplyQueryBean queryBean, HttpServletResponse response) {
        try {
            String ret = this.feedBackManagerService.getlistReplyByFeedBackId(queryBean);
            Util.writeUtf8Text(response, ret);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/addReply.do"}, method={RequestMethod.POST})
    public void addReply(AppFeedBackReplyBean appFeedBackReplyBean, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            appFeedBackReplyBean.setReplySourceType("4");
            appFeedBackReplyBean.setReplyUserId(this.operator.getPerson().getId());
            appFeedBackReplyBean.setReplyUserName(this.operator.getPerson().getName());
            PageBean pageBean = this.feedBackManagerService.addReply(appFeedBackReplyBean);
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u56de\u590d\u6210\u529f";
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
            retMessage = "\u56de\u590d\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/deleteFeedBack.do"}, method={RequestMethod.POST})
    public void deleteFeedBackById(@RequestParam(value="feedBackId") String feedBackId, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            PageBean pageBean = this.feedBackManagerService.removeFeedBackByID(feedBackId, this.operator.getPerson().getId());
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u5220\u9664\u6210\u529f";
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
            retMessage = "\u5220\u9664\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }

    @RequestMapping(value={"/app/AppFeedBackManagerController/deleteReply.do"}, method={RequestMethod.POST})
    public void deleteFeedBackReply(@RequestParam(value="replyId") String replyId, HttpServletRequest request, HttpServletResponse response) {
        String retMessage;
        try {
            PageBean pageBean = this.feedBackManagerService.removeFeedbackReply(replyId, this.person.getId());
            retMessage = "0".equals(pageBean.getState()) ? pageBean.getData().toString() : "\u5220\u9664\u56de\u590d\u6210\u529f";
        }
        catch (Exception e2) {
            logger.info("\u5220\u9664\u56de\u590d\u5931\u8d25" + e2.getMessage());
            retMessage = "\u5220\u9664\u56de\u590d\u5931\u8d25";
        }
        Util.writeUtf8Text(response, retMessage);
    }
}

