/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.feedback.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.feedback.bean.ExceptionBean;
import pams.function.mdp.feedback.bean.QueryExceptionBean;
import pams.function.mdp.feedback.service.FeedbackService;

@Service
public class FeedbackServiceImpl
implements FeedbackService {
    @Autowired
    SystemConfigService systemConfigService;
    private static final Log logger = LogFactory.getLog(FeedbackServiceImpl.class);

    @Override
    public String listException(QueryExceptionBean queryExceptionBean) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = mdpUrl + "/exceptionReportMdpControl/listException.do";
        StringBuilder params = new StringBuilder("");
        if (StringUtils.hasText((String)queryExceptionBean.getAppName())) {
            params.append("&appName=" + queryExceptionBean.getAppName());
        }
        if (StringUtils.hasText((String)queryExceptionBean.getDateStart())) {
            params.append("&dateStart=" + queryExceptionBean.getDateStart());
        }
        if (StringUtils.hasText((String)queryExceptionBean.getDateEnd())) {
            params.append("&dateEnd=" + queryExceptionBean.getDateEnd());
        }
        params.append("&page=" + queryExceptionBean.getPage()).append("&rows=" + queryExceptionBean.getRows());
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.post(url, params.toString()), "utf-8");
        logger.debug((Object)("listException mdp response " + result));
        result = result.replace("data", "rows");
        return result;
    }

    @Override
    public ExceptionBean getExceptionById(String exceptionId) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = mdpUrl + "/exceptionReportMdpControl/getException.do";
        String params = "&exceptionId=" + exceptionId + "&type=json";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.post(url, params.toString()), "utf-8");
        logger.debug((Object)("getExceptionById mdp response " + result));
        PageBean pageBean = (PageBean)Util.readValue(result, PageBean.class, ExceptionBean.class);
        if (pageBean != null && pageBean.getData() != null) {
            return (ExceptionBean)pageBean.getData();
        }
        logger.error((Object)("getExceptionById error " + result));
        throw new Exception("\u67e5\u8be2\u4e0a\u62a5\u8be6\u60c5\u4fe1\u606f\u5f02\u5e38");
    }
}

