/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.mdpcard.service.impl;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.CertValidity;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonDClient;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.mdp.mdpcard.bean.Rt;
import pams.function.mdp.mdpcard.dao.MdpCardDao;
import pams.function.mdp.mdpcard.entity.ThirdCert;
import pams.function.mdp.mdpcard.entity.ThirdKey;
import pams.function.mdp.mdpcard.service.MdpCardService;

@Service
public class MdpCardServiceImpl
implements MdpCardService {
    @Autowired
    private MdpCardDao mdpCardDao;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public List<ThirdKey> listKey(String personId) {
        if (Util.varCheckEmp(personId)) {
            return null;
        }
        try {
            return this.mdpCardDao.listKeyByPersonId(personId);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public ThirdKey keyDetail(String cardId, String personId) {
        try {
            return this.mdpCardDao.keyDetail(personId, cardId);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public ThirdKey keyDetail(String id) {
        try {
            return this.mdpCardDao.keyDetail(id);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public List<ThirdCert> listCert(String cardId) {
        if (Util.varCheckEmp(cardId)) {
            return null;
        }
        try {
            return this.mdpCardDao.listCertByCardId(cardId);
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    @Transactional
    public Rt downloadCert(String personId, String cardId, String pubKey, String keyId, String operatorId) {
        DInfo dInfo;
        String strKey;
        ThirdCert tc2;
        ThirdKey tk = null;
        if (Strings.isNotEmpty(keyId)) {
            tk = this.mdpCardDao.keyDetail(keyId);
        }
        Date now = new Date();
        if (tk != null) {
            String cardIdOld = tk.getCardId();
            if (!cardId.equalsIgnoreCase(cardIdOld)) {
                return Rt.fail("\u5361\u53f7\u4e0d\u4e00\u81f4, \u4e0d\u53ef\u4e0b\u8f7d\u8bc1\u4e66");
            }
            List<ThirdCert> tcs = this.mdpCardDao.listCertByCardId(cardId);
            if (tcs != null && tcs.size() > 0) {
                for (ThirdCert tc2 : tcs) {
                    if (!"0".equals(tc2.getFlag())) continue;
                    return Rt.fail("\u8fd8\u6709\u53ef\u7528\u8bc1\u4e66, \u4e0d\u53ef\u518d\u6b21\u4e0b\u8f7d");
                }
            }
        }
        if ((strKey = CommonDClient.certIssue((dInfo = this.systemConfigService.getDInfoThird()).getUrl(), "2.0", "4", cardId, pubKey, "admin", dInfo.getDevCardNo(), dInfo.getDevPassword())).length() < 10) {
            return Rt.fail(DInfo.getCertIssueErr(strKey));
        }
        if (tk == null) {
            tk = new ThirdKey();
            tk.setPersonId(personId);
            tk.setCardId(cardId);
            tk.setCreateTime(now);
            tk.setFlag("0");
            tk.setOperatorId(operatorId);
            tk.setState("0");
            this.mdpCardDao.addKey(tk);
        }
        keyId = tk.getId();
        String sn = DInfo.getSN(strKey);
        tc2 = new ThirdCert();
        tc2.setAlg("1");
        tc2.setCardId(cardId);
        strKey = strKey.replaceAll("\n", "");
        String cert = strKey.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        tc2.setCert(cert);
        tc2.setCreateTime(now);
        tc2.setFlag("0");
        tc2.setSn(sn);
        CertValidity certValidity = DInfo.getCertValidity(cert);
        if (certValidity != null) {
            tc2.setValidityStart(certValidity.getStart());
            tc2.setValidityEtart(certValidity.getEnd());
        }
        this.mdpCardDao.addCert(tc2);
        tk.setCurrentCertSN(sn);
        tk.setOperatorId(operatorId);
        tk.setUpdateTime(now);
        tk.setState("0");
        this.mdpCardDao.updateKey(tk);
        return Rt.all(strKey.replaceAll("\n", ""), keyId, "\u6210\u529f");
    }

    @Override
    @Transactional
    public Rt revokeCert(String personId, String keyId, String operatorId) {
        ThirdKey tk = null;
        if (Strings.isNotEmpty(keyId)) {
            tk = this.mdpCardDao.keyDetail(keyId);
        }
        if (tk == null) {
            return Rt.fail("\u83b7\u53d6\u5361\u4fe1\u606f\u5f02\u5e38");
        }
        if (!personId.equals(tk.getPersonId())) {
            return Rt.fail("\u4eba\u5361\u4e0d\u5bf9\u5e94");
        }
        List<ThirdCert> tcs = this.mdpCardDao.listCertByCardId(tk.getCardId());
        if (tcs == null || tcs.size() == 0) {
            return Rt.fail("\u5361\u4e2d\u6ca1\u6709\u8bc1\u4e66\u9700\u8981\u64a4\u9500");
        }
        DInfo dInfo = this.systemConfigService.getDInfoThird();
        for (ThirdCert tc : tcs) {
            if (!"0".equals(tc.getFlag())) continue;
            String rst = CommonDClient.certRevoke(dInfo.getUrl(), "2.0", "4", tk.getCardId(), "admin", dInfo.getDevCardNo(), dInfo.getDevPassword());
            if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
                tc.setFlag("1");
                tc.setUpdateTime(new Date());
                this.mdpCardDao.updateCert(tc);
                tk.setUpdateTime(new Date());
                tk.setState("1");
                tk.setOperatorId(operatorId);
                this.mdpCardDao.updateKey(tk);
                return Rt.success("\u6210\u529f\u64a4\u9500");
            }
            return Rt.fail("\u64a4\u9500\u5931\u8d25");
        }
        return Rt.fail("\u6ca1\u6709\u8bc1\u4e66\u9700\u8981\u64a4\u9500");
    }

    @Override
    public Rt checkKey(String personId, String cardId, String keyId) {
        List<ThirdCert> tcs;
        if (Strings.isEmpty(keyId)) {
            List<ThirdKey> listByCard;
            List<ThirdKey> listByPerson = this.mdpCardDao.listKeyExt(personId, null);
            if (listByPerson != null && listByPerson.size() > 0) {
                for (ThirdKey tk : listByPerson) {
                    if (!cardId.equals(tk.getCardId())) continue;
                    return Rt.fail("\u8be5\u7528\u6237\u5df2\u7ecf\u6dfb\u52a0\u8fc7\u6b64\u5361");
                }
            }
            if ((listByCard = this.mdpCardDao.listKeyExt(null, cardId)) != null && listByCard.size() > 0) {
                for (ThirdKey tk : listByCard) {
                    if (personId.equals(tk.getPersonId())) continue;
                    return Rt.fail("\u6b64\u5361\u4e0d\u5c5e\u4e8e\u8be5\u7528\u6237");
                }
            }
        } else {
            ThirdKey tk = this.mdpCardDao.keyDetail(keyId);
            if (tk == null) {
                return Rt.fail("\u5361\u4fe1\u606f\u5f02\u5e38");
            }
            if (!personId.equals(tk.getPersonId())) {
                return Rt.fail("\u8be5\u5361\u7684\u7528\u6237\u4fe1\u606f\u4e0e\u8be5\u7528\u6237\u4e0d\u5bf9\u5e94");
            }
            if (!cardId.equals(tk.getCardId())) {
                return Rt.fail("\u8be5\u5361\u7684\u5361\u53f7\u4fe1\u606f\u4e0e\u5361\u4e0d\u5bf9\u5e94");
            }
        }
        if ((tcs = this.mdpCardDao.listCertByCardId(cardId)) != null && tcs.size() > 0) {
            for (ThirdCert tc : tcs) {
                if (!"0".equals(tc.getFlag())) continue;
                Rt.fail("\u8be5\u5361\u5df2\u6709\u8bc1\u4e66\u5728\u7528");
            }
        }
        return Rt.success("\u6821\u9a8c\u901a\u8fc7");
    }

    @Override
    @Transactional
    public Rt deleteKey(String keyId, String opratorId) {
        ThirdKey tk = this.mdpCardDao.keyDetail(keyId);
        if (!"0".equals(tk.getFlag())) {
            return Rt.fail("\u6b64key\u5df2\u7ecf\u4e0d\u53ef\u7528");
        }
        if ("0".equals(tk.getState())) {
            return Rt.fail("\u6b64key\u6b63\u5728\u7528, \u4e0d\u53ef\u5220\u9664");
        }
        Date now = new Date();
        List<ThirdCert> certList = this.mdpCardDao.listCertByCardId(tk.getCardId());
        if (certList != null && certList.size() > 0) {
            for (ThirdCert tc : certList) {
                tc.setFlag("1");
                tc.setUpdateTime(now);
                this.mdpCardDao.updateCert(tc);
            }
        }
        tk.setState("1");
        tk.setFlag("1");
        tk.setOperatorId(opratorId);
        tk.setUpdateTime(now);
        this.mdpCardDao.updateKey(tk);
        return Rt.success("\u6210\u529f");
    }

    @Override
    public List<ThirdKey> queryByPersonId(String personId) {
        return this.mdpCardDao.listKeyExt(personId, null);
    }
}

