/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.syms.service.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.bean.MdpJsonRst;
import com.xdja.pams.syms.bean.MdpSysConfigType;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.mdp.syms.service.MdpSystemConfigService;

@Service
public class MdpSystemConfigServiceImpl
implements MdpSystemConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdpSystemConfigServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigService;

    @Override
    public List<MdpSysConfigType> getByType(String type) {
        String paramReq = "type=json";
        if (StringUtils.hasText((String)type)) {
            paramReq = paramReq + "&configType=" + type;
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/getType.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        if ("0".equals(rqr.getState())) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + rqr.getData());
            throw new RuntimeException(rqr.getData() + "");
        }
        List rst = (List)rqr.getData();
        if (rst != null && !rst.isEmpty()) {
            ArrayList rtn = Lists.newArrayList();
            for (Map one : rst) {
                MdpSysConfigType tmp = new MdpSysConfigType();
                tmp.setId(one.get("id").toString());
                tmp.setName(one.get("name") == null ? "" : one.get("name").toString());
                rtn.add(tmp);
            }
            return rtn;
        }
        return Collections.emptyList();
    }

    @Override
    public void update(SystemConfig systemConfig) {
        String paramReq = "type=json";
        if (systemConfig != null) {
            if (StringUtils.hasText((String)systemConfig.getId())) {
                paramReq = paramReq + "&config_id=" + systemConfig.getId();
            }
            if (StringUtils.hasText((String)systemConfig.getCode())) {
                paramReq = paramReq + "&code=" + systemConfig.getCode();
            }
            if (StringUtils.hasText((String)systemConfig.getName())) {
                paramReq = paramReq + "&config_name=" + systemConfig.getName();
            }
            if (StringUtils.hasText((String)systemConfig.getValue())) {
                paramReq = paramReq + "&value=" + systemConfig.getValue();
            }
            if (StringUtils.hasText((String)systemConfig.getNote())) {
                paramReq = paramReq + "&note=" + systemConfig.getNote();
            }
            if (systemConfig.getpSystemConfig() != null) {
                paramReq = paramReq + "&pSystemConfig.config_id=" + systemConfig.getpSystemConfig().getId();
            }
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/update.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        if ("0".equals(rqr.getState())) {
            log.error("\u66f4\u65b0\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + rqr.getData());
            throw new RuntimeException(rqr.getData() + "");
        }
    }

    @Override
    public void update(String id, String value) {
        String paramReq = "type=json";
        if (StringUtils.hasText((String)id)) {
            paramReq = paramReq + "&id=" + id;
        }
        if (StringUtils.hasText((String)value)) {
            paramReq = paramReq + "&value=" + value;
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/updateValue.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        if ("0".equals(rqr.getState())) {
            log.error("\u66f4\u65b0\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + rqr.getData());
            throw new RuntimeException(rqr.getData() + "");
        }
    }

    @Override
    public void save(SystemConfig systemConfig) {
        String paramReq = "type=json";
        if (systemConfig != null) {
            if (StringUtils.hasText((String)systemConfig.getId())) {
                paramReq = paramReq + "&config_id=" + systemConfig.getId();
            }
            if (StringUtils.hasText((String)systemConfig.getCode())) {
                paramReq = paramReq + "&code=" + systemConfig.getCode();
            }
            if (StringUtils.hasText((String)systemConfig.getName())) {
                paramReq = paramReq + "&config_name=" + systemConfig.getName();
            }
            if (StringUtils.hasText((String)systemConfig.getValue())) {
                paramReq = paramReq + "&value=" + systemConfig.getValue();
            }
            if (StringUtils.hasText((String)systemConfig.getNote())) {
                paramReq = paramReq + "&note=" + systemConfig.getNote();
            }
            if (systemConfig.getpSystemConfig() != null) {
                paramReq = paramReq + "&pSystemConfig.config_id=" + systemConfig.getpSystemConfig().getId();
            }
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/save.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u65b0\u589e\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        if ("0".equals(rqr.getState())) {
            log.error("\u65b0\u589e\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + rqr.getData());
            throw new RuntimeException(rqr.getData() + "");
        }
    }

    @Override
    public MdpJsonRst getByName(String name) {
        String paramReq = "type=json";
        if (StringUtils.hasText((String)name)) {
            paramReq = paramReq + "&name=" + name;
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/query.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public SystemConfig getByCode(String code) {
        String paramReq = "type=json";
        if (StringUtils.hasText((String)code)) {
            paramReq = paramReq + "&code=" + code;
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/getByCode.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        Map data = (Map)rqr.getData();
        if (data != null && data.get("config_id") != null && StringUtils.hasText((String)data.get("config_id").toString())) {
            SystemConfig config = new SystemConfig();
            config.setId(data.get("config_id").toString());
            config.setName(data.get("config_name").toString());
            config.setCode(data.get("code").toString());
            config.setNote(data.get("note") != null ? data.get("note").toString() : null);
            config.setValue(data.get("value").toString());
            return config;
        }
        return null;
    }

    @Override
    public SystemConfig getById(String id) {
        String paramReq = "type=json";
        if (StringUtils.hasText((String)id)) {
            paramReq = paramReq + "&id=" + id;
        }
        MdpJsonRst rqr = null;
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/syms/sysconfig/getById.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = Util.readValue(rst, MdpJsonRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        Map data = (Map)rqr.getData();
        Object config_id = data.get("config_id");
        if (data != null && config_id != null && StringUtils.hasText((String)config_id.toString())) {
            SystemConfig config = new SystemConfig();
            config.setId(config_id.toString());
            if (data.get("config_name") != null) {
                config.setName(data.get("config_name").toString());
            }
            if (data.get("code") != null) {
                config.setCode(data.get("code").toString());
            }
            if (data.get("note") != null) {
                config.setNote(data.get("note").toString());
            }
            if (data.get("value") != null) {
                config.setValue(data.get("value").toString());
            }
            return config;
        }
        return null;
    }
}

