/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.auxiliaryPolicer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.auxiliaryPolicer.bean.AuxiliaryPolicerRequestParam;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class AuxiUtil {
    public static boolean isMobileNum(String num) {
        if (Util.varCheckEmp(num)) {
            return false;
        }
        return num.matches("^1[35789]\\d{9}$");
    }

    public static boolean isMultiMobileNum(String num) {
        String[] nums;
        if (Util.varCheckEmp(num)) {
            return false;
        }
        for (String n : nums = num.split(",")) {
            if (AuxiUtil.isMobileNum(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalSex(String sex) {
        return AuxiUtil.isLegalStr(sex);
    }

    public static boolean isLegalLockStat(String lockStat) {
        return AuxiUtil.isLegalStr(lockStat);
    }

    private static boolean isLegalStr(String str) {
        return "1".equals(str) || "0".equals(str);
    }

    public static boolean isLegalIdentify(String identify) {
        return identify != null && (identify.length() == 15 || identify.length() == 18);
    }

    public static String isParamLegal(AuxiliaryPolicerRequestParam param) {
        if (param == null) {
            return "\u4fee\u6539\u6570\u636e\u4e3a\u7a7a";
        }
        String police = param.getPolice();
        String position = param.getPosition();
        String commType = param.getCommType();
        SystemConfigService systemConfigService = (SystemConfigService)BeanUtils.getBean(SystemConfigService.class);
        CommonCodePbService commonCodePbService = (CommonCodePbService)BeanUtils.getBean(CommonCodePbService.class);
        String codeSize = systemConfigService.getValueByCode("codeSize");
        int codeAllowMaxLength = Integer.parseInt(codeSize);
        String msg = Util.varCheckEmp(param.getName()) || param.getName().length() > 6 ? "\u59d3\u540d\u4e0d\u6b63\u786e" : (Util.varCheckEmp(param.getCode()) || param.getCode().length() > codeAllowMaxLength ? "\u8b66\u53f7\u4e0d\u6b63\u786e" : (!AuxiUtil.isLegalSex(param.getSex()) ? "\u6027\u522b\u4e0d\u6b63\u786e" : (!AuxiUtil.isLegalIdentify(param.getIdentifier()) ? "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u6b63\u786e" : (!AuxiUtil.isMultiMobileNum(param.getMobile()) ? "\u624b\u673a\u53f7\u4e0d\u6b63\u786e" : (Util.varCheckEmp(param.getDepId()) ? "\u5355\u4f4d\u4e0d\u6b63\u786e" : (!AuxiUtil.isLegalLockStat(param.getLockState()) ? "\u9501\u5b9a\u72b6\u6001\u4e0d\u6b63\u786e" : (!Util.varCheckEmp(police) && !AuxiUtil.isPoliceLegal(police, commonCodePbService) ? "\u8b66\u79cd\u4e0d\u5408\u6cd5" : (!Util.varCheckEmp(position) && !AuxiUtil.isPositionLegal(position, commonCodePbService) ? "\u804c\u52a1\u4e0d\u5408\u6cd5" : (!Util.varCheckEmp(commType) && !AuxiUtil.iscommTypeLegal(commType, commonCodePbService) ? "\u8fd0\u8425\u5546\u4e0d\u5408\u6cd5" : null)))))))));
        return msg;
    }

    private static boolean isPoliceLegal(String police, CommonCodePbService commonCodePbService) {
        return AuxiUtil.isLegalCommonCode(police, "2012", commonCodePbService);
    }

    private static boolean isPositionLegal(String position, CommonCodePbService commonCodePbService) {
        return AuxiUtil.isLegalCommonCode(position, "2011", commonCodePbService);
    }

    private static boolean iscommTypeLegal(String commType, CommonCodePbService commonCodePbService) {
        return AuxiUtil.isLegalCommonCode(commType, "2015", commonCodePbService);
    }

    private static boolean isLegalCommonCode(String value, String code, CommonCodePbService commonCodePbService) {
        List<CommonCode> commonCodes = commonCodePbService.queryByType(code);
        if (commonCodes == null) {
            return false;
        }
        for (CommonCode cc : commonCodes) {
            if (!cc.getCode().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String readJsonStrFromRequest(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        try (ServletInputStream in = request.getInputStream();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("\u53c2\u6570\u8bfb\u53d6\u5f02\u5e38");
        }
        return sb.toString();
    }

    public static <T> List<T> parseToList(String jsonStr, Class<T> tClass) {
        if (Util.varCheckEmp(jsonStr)) {
            return null;
        }
        JSONArray jsonArray = JSON.parseArray((String)jsonStr);
        return jsonArray.toJavaList(tClass);
    }

    public static <T> T parseToObject(String jsonStr, Class<T> tClass) {
        if (Util.varCheckEmp(jsonStr)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        return (T)jsonObject.toJavaObject(tClass);
    }
}

