/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.pams.bims.bean.FieldConfigParam;
import com.xdja.pams.bims.entity.FieldConfig;
import com.xdja.pams.bims.service.FieldConfigService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class FieldConfigController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigController.class);
    @Autowired
    private FieldConfigService service;
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/bims/FieldConfigController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            List<FieldConfig> list = this.service.queryDefaultList();
            map.put((Object)"list", list);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/bims/FieldConfigController/query.do"})
    public void query(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        try {
            List<FieldConfig> list = this.service.queryDefaultList();
            map.put((Object)"list", list);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
    }

    @RequestMapping(value={"/bims/FieldConfigController/updateFieldConfig.do"})
    public void updateFieldConfig(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, FieldConfigParam fcp) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.service.updateDisplayState(fcp.getFcbs());
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/FieldConfigController/queryCunstomColumns.do"})
    public void queryCode(HttpServletRequest request, HttpServletResponse response) {
        List<FieldConfig> list = this.service.queryCustomList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", list.size());
        result.put("rows", list);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/FieldConfigController/toAddCode.do"})
    public String toAddCode(String id, ModelMap map) {
        FieldConfig fc = new FieldConfig();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            fc = this.service.getById(id);
            map.put((Object)"id", (Object)id);
        }
        map.put((Object)"fc", (Object)fc);
        return "bims/fieldConfig/default/addCode";
    }

    @RequestMapping(value={"/bims/FieldConfigController/checkCode.do"})
    public void checkCode(String fieldName, String name, String id, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)fieldName) && StringUtils.isBlank((CharSequence)name)) {
            Util.writeUtf8Text(response, "false");
            return;
        }
        boolean existed = this.service.checkFieldIfExisted(fieldName, name, id);
        Util.writeUtf8Text(response, Boolean.toString(!existed));
    }

    @RequestMapping(value={"/bims/FieldConfigController/addCode.do"})
    public void addCode(FieldConfig fc, HttpServletResponse response) {
        ReturnResult result = new ReturnResult();
        try {
            boolean existed = false;
            existed = this.service.checkFieldIfExisted(null, fc.getName(), fc.getId());
            if (existed) {
                result.setRtnCode("0");
                result.setRtnMsg("\u4fe1\u606f\u9879\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            } else {
                existed = this.service.checkFieldIfExisted(fc.getFieldName(), null, fc.getId());
                if (existed) {
                    result.setRtnCode("0");
                    result.setRtnMsg("\u5b57\u6bb5\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                } else {
                    fc.setType("2");
                    fc.setDisplayStateDetail("0");
                    fc.setDisplayStateList("0");
                    this.service.save(fc);
                    result.setRtnCode("1");
                    result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result.setRtnCode("0");
            result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/FieldConfigController/updateCode.do"})
    public void updateCode(FieldConfig fc, HttpServletResponse response) {
        ReturnResult result = new ReturnResult();
        try {
            boolean existed = false;
            existed = this.service.checkFieldIfExisted(null, fc.getName(), fc.getId());
            if (existed) {
                result.setRtnCode("0");
                result.setRtnMsg("\u4fe1\u606f\u9879\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            } else {
                existed = this.service.checkFieldIfExisted(fc.getFieldName(), null, fc.getId());
                if (existed) {
                    result.setRtnCode("0");
                    result.setRtnMsg("\u5b57\u6bb5\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                } else {
                    this.service.updateField(fc);
                    result.setRtnCode("1");
                    result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result.setRtnCode("0");
            result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/FieldConfigController/deleteCode.do"})
    public void deleteCode(FieldConfig fc, HttpServletResponse response) {
        ReturnResult result = new ReturnResult();
        try {
            this.service.deleteField(fc);
            result.setRtnCode("1");
            result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            result.setRtnCode("0");
            result.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(result));
    }
}

