/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.dao.impl;

import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.entity.WorkFlowControlDept;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DepartmentDaoImpl
implements DepartmentDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public String addDepartment(Department department) {
        return (String)this.baseDao.create(department);
    }

    @Override
    public void deleteDepartment(Department department) {
        this.baseDao.delete(department);
    }

    @Override
    public void updateDepartment(Department department) {
        this.baseDao.update(department);
    }

    @Override
    public Department queryDepartmentById(String departmentId) {
        return (Department)this.baseDao.getObjectById(Department.class, (Serializable)((Object)departmentId));
    }

    @Override
    public List<Department> queryAllDepartmentList(boolean includeDelete) {
        String select = " from Department ";
        if (!includeDelete) {
            select = select + " where flag != 1";
        }
        return this.baseDao.getListByHQL(select, null);
    }

    @Override
    public List<Department> queryDepartmentListBySql(String selectCount, String select, Object[] values, Page page) {
        return this.baseDao.getListBySQL(selectCount, select, values, page, Department.class);
    }

    @Override
    public Department queryDepartmentByHql(String strHql, String[] values) {
        return (Department)this.baseDao.getObjectByHQL(strHql, values);
    }

    @Override
    public void deleteWorkFlowControlDept(String personId) {
        this.baseDao.updateBySql("delete from T_WORKFLOW_PERSON_CONTROLDEP where PERSON_ID = ? ", new String[]{personId});
    }

    @Override
    public List<WorkFlowControlDept> getWorkFlowControlDept(String depId, String personId) {
        if (Util.varCheckEmp(depId) && Util.varCheckEmp(personId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        sql.append("from WorkFlowControlDept where 1 = 1 ");
        if (!Util.varCheckEmp(depId)) {
            sql.append(" and depId = ? ");
            paramList.add(depId);
        }
        if (!Util.varCheckEmp(personId)) {
            sql.append(" and personId = ? ");
            paramList.add(personId);
        }
        return this.baseDao.getListByHQL(sql.toString(), paramList.toArray());
    }

    @Override
    public void addWorkFlowControlDept(WorkFlowControlDept wfcd) {
        this.baseDao.create(wfcd);
    }

    @Override
    public void deleteWorkFlowControlDeptByDepId(String depId) {
        this.baseDao.updateBySql("delete from T_WORKFLOW_PERSON_CONTROLDEP where DEP_ID = ? ", new String[]{depId});
    }
}

