/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.control;

import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.service.CommonTreeService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.FlowUser;
import com.xdja.pams.syms.entity.CommonCode;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class CommonTreeController
extends BaseControler {
    @Autowired
    private CommonTreeService commonTreeService;
    @Autowired
    private UserManageService userManageService;
    private static final Logger log = LoggerFactory.getLogger(CommonTreeController.class);

    @RequestMapping(value={"/common/CommonTreeController/getChild.do"})
    public void getChild(String type, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getChild(type);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + type + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getChild2.do"})
    public void getChild2(String type, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getChild2(type);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + type + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepJson.do"})
    public void getDepJson(String id, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String jsonlist = "";
        try {
            String controlDeps = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getDepJson(id, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepJson2.do"})
    public void getDepJsonNoLogin(String id, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String jsonlist = "";
        try {
            String controlDeps = "8888888888";
            List<Map<String, Object>> listmap = this.commonTreeService.getDepJson(id, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepJsonZT.do"})
    public void getDepJsonNoLoginZT(String id, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String jsonlist = "";
        try {
            String controlDeps = "8888888888";
            List<Map<String, Object>> listmap = this.commonTreeService.getDepJsonZT(id, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getParentDepJson.do"})
    public void getParentDepJson(String[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String jsonlist = "";
        try {
            String controlDeps = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getParentDepJson(ids, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + ids + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getParentDepPersonJson.do"})
    public void getParentDepPersonJson(String id, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String jsonlist = "";
        try {
            String controlDeps = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getParentDepPersonJson(id, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    public List<Map<String, Object>> getChileDep(Map<String, Object> map, Map<String, Department> mapdep) {
        ArrayList<Map<String, Object>> listmap = new ArrayList();
        try {
            listmap = this.commonTreeService.getChildDep(map, mapdep);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + map + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        return listmap;
    }

    @RequestMapping(value={"/common/CommonTreeController/queryGroupListForSelect.do"})
    public void queryGroupListForSelect(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId) {
        String jsonlist = "";
        try {
            QueryGroupBean groupBean = new QueryGroupBean();
            String controlDeps = this.getControlDeps(request);
            this.setOperator(request);
            groupBean.setCreatorID(this.person.getId());
            List<Map<String, Object>> listmap = this.commonTreeService.queryGroupListForSelect(personId, groupBean, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + personId + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/queryGroupListForTree.do"})
    public void getGroupList(HttpServletRequest request, HttpServletResponse response, String id) {
        String jsonlist = "";
        try {
            QueryGroupBean groupBean = new QueryGroupBean();
            String controlDeps = this.getControlDeps(request);
            this.setOperator(request);
            groupBean.setCreatorID(this.person.getId());
            List<Map<String, Object>> listmap = this.commonTreeService.getGroupList(id, groupBean, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/queryGroupListForTreeZT.do"})
    public void getGroupListZT(HttpServletRequest request, HttpServletResponse response, String id) {
        String jsonlist = "";
        try {
            QueryGroupBean groupBean = new QueryGroupBean();
            String controlDeps = this.getControlDeps(request);
            this.setOperator(request);
            groupBean.setCreatorID(this.person.getId());
            List<Map<String, Object>> listmap = this.commonTreeService.getGroupListZT(id, groupBean, controlDeps);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonTypeList.do"})
    public void getPersonTypeList(HttpServletRequest request, HttpServletResponse response, String id, String appId) {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonTypeList(id, appId);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonTypeListZT.do"})
    public void getPersonTypeListZT(HttpServletRequest request, HttpServletResponse response, String id, String appId) {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonTypeListZT(id, appId);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepsJsonByName.do"})
    public void getDepsJsonByName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        if (q == null) {
            return;
        }
        String jsonlist = "";
        try {
            String depName = URLDecoder.decode(q, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getDepsJsonByName(depName, limit, controlDepsIds);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepAndPersonJson.do"})
    public void getDepAndPersonJson(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String rootId) {
        String jsonlist = "";
        try {
            String controlPolices = this.getControlPolices(request);
            String controlDeps = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getDepAndPersonJson(id, rootId, controlDeps, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepAndPersonJsonZT.do"})
    public void getDepAndPersonJsonZT(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String rootId) {
        String jsonlist = "";
        try {
            String controlPolices = this.getControlPolices(request);
            String controlDeps = this.getControlDeps(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getDepAndPersonJsonZT(id, rootId, controlDeps, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getDepAndPersonJsonNoLoginZT.do"})
    public void getDepAndPersonJsonNoLoginZT(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String personId, String key) {
        String jsonlist = "";
        try {
            Person person = this.userManageService.queryPersonById(personId);
            String controlPolices = "";
            String controlDeps = "";
            List<Department> list = person.getControlDepdList();
            if (list == null || list.size() == 0) {
                controlDeps = person.getDepartment().getId();
            } else {
                controlDeps = list.get(0).getId();
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); ++i) {
                        Department dep = list.get(i);
                        if ("1".equals(dep.getFlag())) continue;
                        controlDeps = controlDeps + "," + list.get(i).getId();
                    }
                }
            }
            List<CommonCode> list2 = person.getControlPolicedList();
            if (list2 == null || list2.size() == 0) {
                controlPolices = "all";
            } else {
                controlPolices = list2.get(0).getCode();
                if (list2.size() > 1) {
                    for (int i = 1; i < list2.size(); ++i) {
                        controlPolices = controlPolices + "," + list.get(i).getCode();
                    }
                }
            }
            boolean isReturnDep = true;
            if (StringUtils.isNotBlank((CharSequence)key)) {
                isReturnDep = false;
            }
            List<Map<String, Object>> listmap = this.commonTreeService.getDepAndPersonJsonZT(id, null, controlDeps, controlPolices, key, isReturnDep);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/showWorkflowUserPage.do"})
    public String showWorkflowUserPage(HttpServletResponse response, HttpServletRequest request, FlowUser fu, ModelMap map) {
        String sendUrl = "scms/apply/default/selectFlowUser";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.showWorkflowUserPage(fu);
            if (listmap != null && listmap.size() > 0) {
                map.put((Object)"mapsList", (Object)Util.toJsonStr(listmap));
            }
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u5f85\u6d41\u8f6c\u7684\u4eba\u5458\u6811\u51fa\u73b0\u4f4d\u7f6e\u5f02\u5e38\u3010" + fu.getGroupId() + fu.getPersonId() + fu.getPowerId() + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
            sendUrl = "error/error";
        }
        return sendUrl;
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonsJsonByName.do"})
    public void getPersonsJsonByName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String personName = URLDecoder.decode(q, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonsJsonByName(personName, limit, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonsJsonByCode.do"})
    public void getPersonsJsonByCode(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String code = URLDecoder.decode(q, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonsJsonByCode(code, limit, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonsJsonByCodeOrName.do"})
    public void getPersonsJsonByCodeOrName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String codeOrName = URLDecoder.decode(q, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonsJsonByCodeOrName(codeOrName, limit, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonJson.do"})
    public void getPersonJson(HttpServletRequest request, HttpServletResponse response, ModelMap map, String name, String maxNum) {
        String jsonlist = "";
        try {
            String personName = URLDecoder.decode(name, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonJson(personName, maxNum, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + name + "," + maxNum + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getPersonJsonZT.do"})
    public void getPersonJsonZT(HttpServletRequest request, HttpServletResponse response, ModelMap map, String name, String maxNum) {
        String jsonlist = "";
        try {
            String personName = URLDecoder.decode(name, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.commonTreeService.getPersonJsonZT(personName, maxNum, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + name + "," + maxNum + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getSysRoleList.do"})
    public void getSysRoleList(String type, HttpServletRequest request, HttpServletResponse response, String personId) throws IOException {
        String jsonlist = "";
        try {
            this.setOperator(request);
            String operatorId = this.person.getId();
            List<Map<String, Object>> listmap = this.commonTreeService.getSysRoleList(personId, operatorId);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + personId + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getTerminalRoleList.do"})
    public void getTerminalRoleList(String type, HttpServletRequest request, HttpServletResponse response, String personId) throws IOException {
        String jsonlist = "";
        try {
            this.setOperator(request);
            String operatorId = this.person.getId();
            List<Map<String, Object>> listmap = this.commonTreeService.getTerminalRoleList(personId, operatorId);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + personId + "\u3011\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getBusinessReports.do"})
    public void getBusinessReports(HttpServletRequest request, HttpServletResponse response) {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getBusinessReports();
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/common/CommonTreeController/getReportFiles.do"})
    public void getReportFiles(HttpServletRequest request, HttpServletResponse response) {
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.commonTreeService.getReportFiles();
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e2) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        Util.writeUtf8Text(response, jsonlist);
    }
}

