/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUpload {
    private static final Logger log = LoggerFactory.getLogger(FtpUpload.class);
    private String ip;
    private String userId;
    private String pwd;
    private int port = 21;
    private String workDir = "JWT";
    private String controlEncoding = "GBK";
    private FTPClient ftpClient = new FTPClient();

    public FtpUpload(String ip, String user, String password, String port, String wirkDir) {
        this(ip, user, password, port, wirkDir, "GBK");
    }

    public FtpUpload(String ip, String user, String password, String port, String wirkDir, String controlEncoding) {
        log.info("#ftp ip:" + ip);
        log.info("#ftp userId:" + this.userId);
        log.info("#ftp pwd:" + this.pwd);
        log.info("#ftp port:" + port);
        log.info("#ftp workDir:" + ip);
        log.info("#ftp ip:" + ip);
        log.info("#ftp controlEncoding:" + controlEncoding);
        this.ip = ip;
        this.userId = user;
        this.pwd = password;
        this.port = Integer.parseInt(port);
        this.workDir = wirkDir;
        this.controlEncoding = controlEncoding;
        this.ftpClient.setControlEncoding(controlEncoding);
    }

    public void upMyFile(String fileName, InputStream ins) {
        log.info("#ftp\u6587\u4ef6\u4e0a\u4f20>>>");
        try {
            this.checkFtpInfo();
            this.ftpClient.setFileType(2);
            if (!this.ftpClient.storeFile(fileName, ins)) {
                throw new RuntimeException("\u6307\u5b9a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            this.ftpClient.logout();
            this.ftpClient.disconnect();
            ins.close();
        }
        catch (Exception e2) {
            log.error("#ftp\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        log.info("#ftp\u6587\u4ef6\u4e0a\u4f20<<<");
    }

    public void checkFtpInfo() {
        log.info("#ftp\u6d4b\u8bd5>>>");
        try {
            this.ftpClient.connect(this.ip, this.port);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                throw new RuntimeException("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!this.ftpClient.login(this.userId, this.pwd)) {
                throw new RuntimeException("ftp\u767b\u5f55\u5931\u8d25,\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            }
            if (this.ftpClient.cwd(this.workDir) != 250) {
                throw new RuntimeException("ftp\u8bbf\u95ee\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e2) {
            log.error("#ftp\u6d4b\u8bd5\u5931\u8d25", (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        log.info("#ftp\u6d4b\u8bd5<<<");
    }

    public static void main(String[] args) {
        String file = "jwt/20120709/14/CLYTCL410139201200000000007687.jpg";
        System.out.println(file.substring(4));
    }
}

