/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHepler {
    private static Logger logger = LoggerFactory.getLogger(ImageHepler.class);

    private static BufferedImage makeThumbnail(Image img, int width, int height) {
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.setColor(Color.WHITE);
        g.drawImage(img.getScaledInstance(width, height, 4), 0, 0, Color.WHITE, null);
        g.dispose();
        return tag;
    }

    private static void saveSubImage(BufferedImage image, Rectangle subImageBounds, File subImageFile) throws IOException {
        String fileName = subImageFile.getName();
        String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage subImage = new BufferedImage(subImageBounds.width, subImageBounds.height, 1);
        Graphics g = subImage.getGraphics();
        if (subImageBounds.width > image.getWidth() || subImageBounds.height > image.getHeight()) {
            int left = subImageBounds.x;
            int top = subImageBounds.y;
            if (image.getWidth() < subImageBounds.width) {
                left = (subImageBounds.width - image.getWidth()) / 2;
            }
            if (image.getHeight() < subImageBounds.height) {
                top = (subImageBounds.height - image.getHeight()) / 2;
            }
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, subImageBounds.width, subImageBounds.height);
            g.drawImage(image, left, top, Color.WHITE, null);
            ImageIO.write((RenderedImage)image, formatName, subImageFile);
            logger.debug("if is running left:" + left + " top: " + top);
        } else {
            g.drawImage(image.getSubimage(subImageBounds.x, subImageBounds.y, subImageBounds.width, subImageBounds.height), 0, 0, null);
            logger.debug("else is running");
        }
        g.dispose();
        ImageIO.write((RenderedImage)subImage, formatName, subImageFile);
    }

    public static void cut(String srcImageFile, String descDir, int width, int height, Rectangle rect) throws IOException {
        BufferedImage image = ImageIO.read(new File(srcImageFile));
        BufferedImage bImage = ImageHepler.makeThumbnail(image, width, height);
        ImageHepler.saveSubImage(bImage, rect, new File(descDir));
    }

    public static void cut(File srcImageFile, File descDir, int width, int height, Rectangle rect) throws IOException {
        BufferedImage image = ImageIO.read(srcImageFile);
        BufferedImage bImage = ImageHepler.makeThumbnail(image, width, height);
        ImageHepler.saveSubImage(bImage, rect, descDir);
    }
}

