/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.getwayapi;

import com.google.common.io.ByteArrayDataInput;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.getwayapi.httpservice.client.HttpRequestUtil;
import com.xdja.pams.getwayapi.service.UdpCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UdpCallback callback;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private String url;
    private String[] urlArr;

    public HttpServer(String url, UdpCallback callback) {
        this.callback = callback;
        this.url = url;
        this.urlArr = url.split(",");
    }

    public void startOnlineInfoListenServer() {
        for (final String gatewayUrl : this.urlArr) {
            if (StringUtils.isBlank((CharSequence)gatewayUrl)) continue;
            this.logger.debug("\u542f\u52a8\u4e0a\u4e0b\u7ebf\u76d1\u542c\u670d\u52a1,\u5730\u5740:" + gatewayUrl);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    HttpRequestUtil httpUtil = new HttpRequestUtil();
                    String param = "{\"jsonrpc\": \"2.0\",\"method\": \"users.getupdate\"}";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Content-Type", "application/json; charset=UTF-8");
                    header.put("Connection", "keep-alive");
                    int errTime = 0;
                    while (true) {
                        try {
                            while (true) {
                                String respJson = httpUtil.post(gatewayUrl, param, header);
                                HttpServer.this.processReceiveHttpData(respJson, gatewayUrl);
                                errTime = 0;
                            }
                        }
                        catch (Exception e2) {
                            if (errTime < 3) {
                                HttpServer.this.logger.warn(gatewayUrl + "---\u5904\u7406\u6536\u5230\u7684\u6570\u636e\u51fa\u9519\uff01" + e2.getMessage());
                            } else {
                                HttpServer.this.logger.warn(gatewayUrl + "---\u5904\u7406\u6536\u5230\u7684\u6570\u636e\u51fa\u9519\uff01" + e2.getMessage());
                            }
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e1) {
                            }
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    private void processReceiveHttpData(String respJson, String gatewayUrl) {
        Map rsp = Util.readValue(respJson, Map.class);
        List result = (List)rsp.get("result");
        if (result == null) {
            int code;
            Map error = (Map)rsp.get("error");
            if (error != null && (code = ((Integer)error.get("code")).intValue()) == -32604) {
                ArrayList<String> snList = new ArrayList<String>();
                this.callback.updateOffLine(snList, new Date(), gatewayUrl);
            }
            return;
        }
        if (result != null && !result.isEmpty()) {
            for (Map param : result) {
                String type = (String)param.get("event");
                Map msg = (Map)param.get("message");
                if ("user.login".equals(type)) {
                    String port = Integer.toString((Integer)msg.get("port"));
                    this.callback.online((String)msg.get("ip"), (String)msg.get("sn"), null, port, gatewayUrl);
                    continue;
                }
                if (!"user.logout".equals(type)) continue;
                String onlineTime = Integer.toString((Integer)msg.get("online-time"));
                String uploaded = Integer.toString((Integer)msg.get("uploaded"));
                String downloaded = Integer.toString((Integer)msg.get("downloaded"));
                String port = Integer.toString((Integer)msg.get("port"));
                this.callback.offline((String)msg.get("ip"), (String)msg.get("sn"), uploaded, downloaded, onlineTime, port, gatewayUrl);
            }
        }
    }

    public void startGetCurrentOnlineInfo() {
        for (final String gatewayUrl : this.urlArr) {
            if (StringUtils.isBlank((CharSequence)gatewayUrl)) continue;
            this.logger.debug("\u83b7\u53d6\u5df2\u5728\u7ebf\u4fe1\u606f,\u5730\u5740:" + gatewayUrl);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    HttpRequestUtil httpUtil = new HttpRequestUtil();
                    String param = "{\"jsonrpc\": \"2.0\",\"method\": \"users.getall\"}";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Content-Type", "application/json; charset=UTF-8");
                    try {
                        String respJson = httpUtil.post(gatewayUrl, param, header);
                        HttpServer.this.logger.debug(gatewayUrl + "---users.getall\u6536\u5230\u7f51\u5173\u7684\u901a\u77e5\u4fe1\u606f:" + respJson);
                        HttpServer.this.processReceiveHttpDataForCurrentOnlineInfo(respJson, gatewayUrl);
                    }
                    catch (Exception e2) {
                        HttpServer.this.logger.warn(gatewayUrl + "---\u5904\u7406\u6536\u5230\u7684\u6570\u636e\u51fa\u9519\uff01" + e2.getMessage(), (Throwable)e2);
                    }
                }
            });
        }
    }

    private void processReceiveHttpDataForCurrentOnlineInfo(String respJson, String gatewayUrl) {
        Map rsp = Util.readValue(respJson, Map.class);
        List result = (List)rsp.get("result");
        if (result != null && !result.isEmpty()) {
            for (Map param : result) {
                String onlineTime = Integer.toString((Integer)param.get("online-time"));
                String port = Integer.toString((Integer)param.get("port"));
                this.callback.online((String)param.get("ip"), (String)param.get("sn"), onlineTime, port, gatewayUrl);
            }
        }
    }

    public void startGetCurrentOnlineInfoTimer() {
        for (final String gatewayUrl : this.urlArr) {
            if (StringUtils.isBlank((CharSequence)gatewayUrl)) continue;
            this.logger.debug("\u542f\u52a8\u5b9a\u65f6\u68c0\u6d4b\u5728\u7ebf\u670d\u52a1,\u5730\u5740:" + gatewayUrl);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    HttpRequestUtil httpUtil = new HttpRequestUtil();
                    String param = "{\"jsonrpc\": \"2.0\",\"method\": \"users.getall\"}";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Content-Type", "application/json; charset=UTF-8");
                    int errTime = 0;
                    while (true) {
                        Date reqDate = new Date();
                        try {
                            String respJson = httpUtil.post(gatewayUrl, param, header);
                            HttpServer.this.logger.debug(gatewayUrl + "---users.getall\u5b9a\u65f6\u4efb\u52a1\u6536\u5230\u7f51\u5173\u7684\u901a\u77e5\u4fe1\u606f:" + respJson);
                            try {
                                HttpServer.this.timerProcessReceiveHttpDataForCurrentOnlineInfo(respJson, reqDate, gatewayUrl);
                            }
                            catch (Exception e2) {
                                HttpServer.this.logger.warn(gatewayUrl + "---\u5904\u7406\u6536\u5230\u7684\u6570\u636e\u51fa\u9519\uff01" + e2.getMessage(), (Throwable)e2);
                            }
                            errTime = 0;
                            Thread.sleep(1200000L);
                        }
                        catch (Exception e3) {
                            if (++errTime < 5) {
                                HttpServer.this.logger.error(gatewayUrl + "---\u8c03\u7528-B\u5728\u7ebf\u4eba\u5458\u63a5\u53e3\u5931\u8d25\uff1a" + e3.getMessage(), (Throwable)e3);
                            } else {
                                HttpServer.this.logger.error(gatewayUrl + "---\u8c03\u7528-B\u5728\u7ebf\u4eba\u5458\u63a5\u53e3\u5931\u8d25\uff1a" + e3.getMessage());
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                        }
                        if (errTime != 10) continue;
                        ArrayList<String> snList = new ArrayList<String>();
                        HttpServer.this.callback.updateOffLine(snList, reqDate, gatewayUrl);
                    }
                }
            });
        }
    }

    private void timerProcessReceiveHttpDataForCurrentOnlineInfo(String respJson, Date reqDate, String gatewayUrl) {
        Map rsp = Util.readValue(respJson, Map.class);
        List result = (List)rsp.get("result");
        if (result != null && !result.isEmpty()) {
            ArrayList<String> snList = new ArrayList<String>();
            for (Map param : result) {
                String ip = (String)param.get("ip");
                String port = Integer.toString((Integer)param.get("port"));
                String sn = (String)param.get("sn");
                String ipPortSn = ip + "," + port + "," + sn;
                snList.add(ipPortSn);
                String onlineTime = Integer.toString((Integer)param.get("online-time"));
                String uploaded = Integer.toString((Integer)param.get("uploaded"));
                String downloaded = Integer.toString((Integer)param.get("downloaded"));
                this.callback.onlineFlowTimer(ip, sn, uploaded, downloaded, onlineTime, port, gatewayUrl);
            }
            this.callback.updateOffLine(snList, reqDate, gatewayUrl);
        }
    }

    private String getSnFromPack(ByteArrayDataInput input, int snLen) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < snLen; ++i) {
            String s = Integer.toHexString(input.readUnsignedByte());
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        if (sb.charAt(0) == '0') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private Integer getForwardPort(ByteArrayDataInput input, int markLen) {
        int i = input.readUnsignedShort();
        return i;
    }

    private String getVirtualIp(ByteArrayDataInput input, int markLen) {
        return input.readUnsignedByte() + "." + input.readUnsignedByte() + "." + input.readUnsignedByte() + "." + input.readUnsignedByte();
    }

    public void shutdown() throws Exception {
        this.executorService.shutdownNow();
    }
}

